/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.coverage.JacocoOptions;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.AdbOptions;
import com.android.build.gradle.internal.dsl.AndroidSourceSetFactory;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.managed.AndroidConfig;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.LibraryRequest;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.internal.reflect.Instantiator;

public class AndroidConfigHelper {
    public static void configure(AndroidConfig model, ExtraModelInfo extraModelInfo, Instantiator instantiator) {
        model.setDefaultPublishConfig("release");
        model.setGeneratePureSplits(false);
        model.setDeviceProviders(Lists.newArrayList());
        model.setTestServers(Lists.newArrayList());
        model.setAaptOptions((AaptOptions)instantiator.newInstance(AaptOptions.class, new Object[0]));
        model.setDexOptions((DexOptions)instantiator.newInstance(DexOptions.class, new Object[]{extraModelInfo}));
        model.setLintOptions((LintOptions)instantiator.newInstance(LintOptions.class, new Object[0]));
        model.setTestOptions((TestOptions)instantiator.newInstance(TestOptions.class, new Object[]{instantiator}));
        model.setCompileOptions((CompileOptions)instantiator.newInstance(CompileOptions.class, new Object[0]));
        model.setPackagingOptions((PackagingOptions)instantiator.newInstance(PackagingOptions.class, new Object[0]));
        model.setJacoco((JacocoOptions)instantiator.newInstance(JacocoOptions.class, new Object[0]));
        model.setAdbOptions((AdbOptions)instantiator.newInstance(AdbOptions.class, new Object[0]));
        model.setSplits((Splits)instantiator.newInstance(Splits.class, new Object[]{instantiator}));
        model.setLibraryRequests(new ArrayList<LibraryRequest>());
        model.setBaseFeature(false);
        model.setBuildToolsRevision(AndroidBuilder.DEFAULT_BUILD_TOOLS_REVISION);
    }

    public static NamedDomainObjectContainer<AndroidSourceSet> createSourceSetsContainer(Project project, Instantiator instantiator, boolean publishPackage) {
        NamedDomainObjectContainer sourceSetsContainer = project.container(AndroidSourceSet.class, (NamedDomainObjectFactory)new AndroidSourceSetFactory(instantiator, project, publishPackage));
        sourceSetsContainer.whenObjectAdded(sourceSet -> {
            ConfigurationContainer configurations = project.getConfigurations();
            String implementationName = sourceSet.getImplementationConfigurationName();
            String runtimeOnlyName = sourceSet.getRuntimeOnlyConfigurationName();
            String compileOnlyName = sourceSet.getCompileOnlyConfigurationName();
            String compileName = sourceSet.getCompileConfigurationName();
            Configuration compile = AndroidConfigHelper.createConfiguration(configurations, compileName, String.format("%s dependencies for '%s' sources (deprecated: use '%s' instead).", "Compile", sourceSet.getName(), implementationName), "compile".equals(compileName) || "testCompile".equals(compileName));
            compile.getAllDependencies().whenObjectAdded((Action)new AndroidConfig.DeprecatedConfigurationAction(project, compile, implementationName));
            String packageConfigDescription = publishPackage ? String.format("%s dependencies for '%s' sources (deprecated: use '%s' instead).", "Publish", sourceSet.getName(), runtimeOnlyName) : String.format("%s dependencies for '%s' sources (deprecated: use '%s' instead).", "Apk", sourceSet.getName(), runtimeOnlyName);
            Configuration apk = AndroidConfigHelper.createConfiguration(configurations, sourceSet.getPackageConfigurationName(), packageConfigDescription);
            apk.getAllDependencies().whenObjectAdded((Action)new AndroidConfig.DeprecatedConfigurationAction(project, apk, runtimeOnlyName));
            Configuration provided = AndroidConfigHelper.createConfiguration(configurations, sourceSet.getProvidedConfigurationName(), String.format("%s dependencies for '%s' sources (deprecated: use '%s' instead).", "Provided", sourceSet.getName(), compileOnlyName));
            provided.getAllDependencies().whenObjectAdded((Action)new AndroidConfig.DeprecatedConfigurationAction(project, provided, compileOnlyName));
            String apiName = sourceSet.getApiConfigurationName();
            Configuration api = AndroidConfigHelper.createConfiguration(configurations, apiName, String.format("%s dependencies for '%s' sources.", "API", sourceSet.getName()));
            api.extendsFrom(new Configuration[]{compile});
            Configuration implementation = AndroidConfigHelper.createConfiguration(configurations, implementationName, String.format("%s dependencies for '%s' sources.", "Implementation only", sourceSet.getName()));
            implementation.extendsFrom(new Configuration[]{api});
            Configuration runtimeOnly = AndroidConfigHelper.createConfiguration(configurations, runtimeOnlyName, String.format("%s dependencies for '%s' sources.", "Runtime only", sourceSet.getName()));
            runtimeOnly.extendsFrom(new Configuration[]{apk});
            Configuration compileOnly = AndroidConfigHelper.createConfiguration(configurations, compileOnlyName, String.format("%s dependencies for '%s' sources.", "Compile only", sourceSet.getName()));
            compileOnly.extendsFrom(new Configuration[]{provided});
            Configuration wearConfig = AndroidConfigHelper.createConfiguration(configurations, sourceSet.getWearAppConfigurationName(), "Link to a wear app to embed for object '" + sourceSet.getName() + "'.");
            AndroidConfigHelper.createConfiguration(configurations, sourceSet.getAnnotationProcessorConfigurationName(), "Classpath for the annotation processor for '" + sourceSet.getName() + "'.");
            sourceSet.setRoot(String.format("src/%s", sourceSet.getName()));
        });
        return sourceSetsContainer;
    }

    private static Configuration createConfiguration(ConfigurationContainer configurations, String name, String description) {
        return AndroidConfigHelper.createConfiguration(configurations, name, description, false);
    }

    private static Configuration createConfiguration(ConfigurationContainer configurations, String name, String description, boolean canBeResolved) {
        Configuration configuration = (Configuration)configurations.findByName(name);
        if (configuration == null) {
            configuration = (Configuration)configurations.create(name);
        }
        configuration.setCanBeConsumed(false);
        configuration.setCanBeResolved(canBeResolved);
        return configuration;
    }
}

