/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.NativeDependencyLinkage;
import com.android.build.gradle.internal.dependency.AndroidNativeDependencySpec;
import com.android.build.gradle.internal.dependency.AndroidNativeDependencySpecContainer;
import com.android.build.gradle.internal.dependency.ArtifactContainer;
import com.android.build.gradle.internal.dependency.NativeDependencyResolveResult;
import com.android.build.gradle.internal.dependency.NativeLibraryArtifact;
import com.android.utils.StringHelper;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.internal.resolve.LibraryResolveException;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.PrebuiltLibraries;
import org.gradle.nativeplatform.PrebuiltLibrary;
import org.gradle.nativeplatform.Repositories;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.StaticLibraryBinary;
import org.gradle.nativeplatform.internal.prebuilt.PrebuiltLibraryResolveException;

public class NativeDependencyResolver {
    private ServiceRegistry serviceRegistry;
    private AndroidNativeDependencySpecContainer dependencyContainer;
    private AndroidNativeDependencySpec defaultDependencySpec;

    public NativeDependencyResolver(ServiceRegistry serviceRegistry, AndroidNativeDependencySpecContainer dependencyContainer, AndroidNativeDependencySpec defaultDependencySpec) {
        this.serviceRegistry = serviceRegistry;
        this.dependencyContainer = dependencyContainer;
        this.defaultDependencySpec = defaultDependencySpec;
    }

    public NativeDependencyResolveResult resolve() {
        NativeDependencyResolveResult result = new NativeDependencyResolveResult();
        for (AndroidNativeDependencySpec dependency : this.dependencyContainer.getDependencies()) {
            if (dependency.getProjectPath() != null) {
                result.getNativeArtifacts().addAll(this.resolveForNativeBinaries(dependency));
                continue;
            }
            if (dependency.getLibraryPath() == null) continue;
            this.resolveForPrebuiltLibraries(result, dependency);
        }
        return result;
    }

    private void resolveForPrebuiltLibraries(NativeDependencyResolveResult result, AndroidNativeDependencySpec dependency) {
        NativeDependencyLinkage linkage = (NativeDependencyLinkage)((Object)MoreObjects.firstNonNull((Object)((Object)dependency.getLinkage()), (Object)((Object)this.defaultDependencySpec.getLinkage())));
        for (NativeLibraryBinary binary : this.getBinaries(dependency.getLibraryPath())) {
            if (linkage.equals((Object)NativeDependencyLinkage.STATIC)) {
                if (!(binary instanceof StaticLibraryBinary) || ((StaticLibraryBinary)binary).getStaticLibraryFile() == null) continue;
                result.getPrebuiltLibraries().add(binary);
                continue;
            }
            if (!(binary instanceof SharedLibraryBinary) || ((SharedLibraryBinary)binary).getSharedLibraryFile() == null) continue;
            result.getPrebuiltLibraries().add(binary);
        }
    }

    private Collection<NativeLibraryBinary> getBinaries(String library) {
        ModelRegistry projectModel = (ModelRegistry)this.serviceRegistry.get(ModelRegistry.class);
        NamedDomainObjectSet repositories = ((Repositories)projectModel.realize(ModelPath.path((String)"repositories"), ModelType.of(Repositories.class))).withType(PrebuiltLibraries.class);
        if (repositories.isEmpty()) {
            throw new PrebuiltLibraryResolveException("Project does not have any prebuilt library repositories.");
        }
        PrebuiltLibrary prebuiltLibrary = NativeDependencyResolver.getPrebuiltLibrary((NamedDomainObjectSet<PrebuiltLibraries>)repositories, library);
        return prebuiltLibrary.getBinaries();
    }

    private static PrebuiltLibrary getPrebuiltLibrary(NamedDomainObjectSet<PrebuiltLibraries> repositories, String libraryName) {
        ArrayList<String> repositoryNames = new ArrayList<String>();
        for (PrebuiltLibraries prebuiltLibraries : repositories) {
            repositoryNames.add(prebuiltLibraries.getName());
            PrebuiltLibrary prebuiltLibrary = prebuiltLibraries.resolveLibrary(libraryName);
            if (prebuiltLibrary == null) continue;
            return prebuiltLibrary;
        }
        throw new PrebuiltLibraryResolveException(String.format("Prebuilt library with name '%s' not found in repositories '%s'.", libraryName, repositoryNames));
    }

    private Collection<NativeLibraryArtifact> resolveForNativeBinaries(AndroidNativeDependencySpec dependency) {
        NativeDependencyLinkage linkage;
        String productFlavor;
        Collection<NativeLibraryArtifact> matches;
        String project = dependency.getProjectPath();
        ProjectModelResolver projectModelResolver = (ProjectModelResolver)this.serviceRegistry.get(ProjectModelResolver.class);
        ModelRegistry projectModel = projectModelResolver.resolveProjectModel(project);
        ArtifactContainer artifactContainer = (ArtifactContainer)projectModel.find(ModelPath.path((String)"artifacts"), ModelType.of(ArtifactContainer.class));
        if (artifactContainer == null) {
            throw new InvalidUserDataException("Project '" + project + "' does not export native artifacts");
        }
        String buildType = NativeDependencyResolver.findUniqueBuildTypeCount(matches = NativeDependencyResolver.filter(artifactContainer.getNativeArtifacts().values(), dependency.getBuildType(), dependency.getProductFlavor(), dependency.getLinkage())) > 1 ? this.defaultDependencySpec.getBuildType() : null;
        Collection<NativeLibraryArtifact> libraries = NativeDependencyResolver.filter(matches, buildType, productFlavor = NativeDependencyResolver.findUniqueProductFlavorCount(matches) > 1 ? this.defaultDependencySpec.getProductFlavor() : null, linkage = NativeDependencyResolver.findUniqueLinkageCount(matches) > 1 ? this.defaultDependencySpec.getLinkage() : null);
        if (libraries.isEmpty()) {
            throw new LibraryResolveException(String.format("Unable to find Android binary with buildType '%s' and productFlavor '%s' in project '%s'", buildType, productFlavor, project));
        }
        return libraries;
    }

    private static int findUniqueBuildTypeCount(Iterable<NativeLibraryArtifact> artifacts) {
        HashSet unique = Sets.newHashSet();
        for (NativeLibraryArtifact artifact : artifacts) {
            unique.add(artifact.getBuildType() == null ? null : artifact.getBuildType());
        }
        return unique.size();
    }

    private static int findUniqueProductFlavorCount(Iterable<NativeLibraryArtifact> artifacts) {
        HashSet unique = Sets.newHashSet();
        for (NativeLibraryArtifact artifact : artifacts) {
            unique.add(artifact.getProductFlavors() == null ? null : artifact.getProductFlavors());
        }
        return unique.size();
    }

    private static int findUniqueLinkageCount(Iterable<NativeLibraryArtifact> artifacts) {
        HashSet unique = Sets.newHashSet();
        for (NativeLibraryArtifact artifact : artifacts) {
            unique.add(artifact.getLinkage() == null ? null : artifact.getLinkage());
        }
        return unique.size();
    }

    private static Collection<NativeLibraryArtifact> filter(Collection<NativeLibraryArtifact> artifacts, String buildType, String productFlavor, NativeDependencyLinkage linkage) {
        if (buildType == null && productFlavor == null && linkage == null) {
            return artifacts;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (NativeLibraryArtifact artifact : artifacts) {
            if (buildType != null && !buildType.equals(artifact.getBuildType()) || productFlavor != null && !productFlavor.equals(StringHelper.combineAsCamelCase(artifact.getProductFlavors())) || linkage != null && !linkage.equals((Object)artifact.getLinkage()) && artifact.getLinkage() != null) continue;
            builder.add((Object)artifact);
        }
        return builder.build();
    }
}

