/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.managed.adaptor;

import com.android.build.api.transform.Transform;
import com.android.build.api.variant.VariantFilter;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceFile;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.coverage.JacocoOptions;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.AdbOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.DexOptions;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.model.CoreExternalNativeBuild;
import com.android.build.gradle.managed.adaptor.BuildTypeAdaptor;
import com.android.build.gradle.managed.adaptor.DataBindingOptionsAdapter;
import com.android.build.gradle.managed.adaptor.NdkOptionsAdaptor;
import com.android.build.gradle.managed.adaptor.ProductFlavorAdaptor;
import com.android.build.gradle.managed.adaptor.SigningConfigAdaptor;
import com.android.builder.core.LibraryRequest;
import com.android.builder.model.DataBindingOptions;
import com.android.builder.model.DimensionAware;
import com.android.builder.model.SigningConfig;
import com.android.builder.testing.api.DeviceProvider;
import com.android.builder.testing.api.TestServer;
import com.android.repository.Revision;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.model.ModelMap;

public class AndroidConfigAdaptor
implements AndroidConfig {
    private final com.android.build.gradle.managed.AndroidConfig model;
    private NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer;

    public AndroidConfigAdaptor(com.android.build.gradle.managed.AndroidConfig model, NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer) {
        this.model = model;
        this.sourceSetsContainer = sourceSetsContainer;
        this.applyProjectSourceSet();
    }

    public String getBuildToolsVersion() {
        return this.model.getBuildToolsVersion();
    }

    public String getCompileSdkVersion() {
        return this.model.getCompileSdkVersion();
    }

    public Revision getBuildToolsRevision() {
        return this.model.getBuildToolsRevision();
    }

    public CoreProductFlavor getDefaultConfig() {
        return new ProductFlavorAdaptor(this.model.getDefaultConfig());
    }

    public List<DeviceProvider> getDeviceProviders() {
        return ImmutableList.copyOf(this.model.getDeviceProviders());
    }

    public List<TestServer> getTestServers() {
        return ImmutableList.copyOf(this.model.getTestServers());
    }

    public List<Transform> getTransforms() {
        return ImmutableList.of();
    }

    public List<List<Object>> getTransformsDependencies() {
        return ImmutableList.of();
    }

    public String getDefaultPublishConfig() {
        return this.model.getDefaultPublishConfig();
    }

    public Action<VariantFilter> getVariantFilter() {
        return this.model.getVariantFilter();
    }

    public String getResourcePrefix() {
        return this.model.getResourcePrefix();
    }

    public List<String> getFlavorDimensionList() {
        return this.getProductFlavors().stream().filter(flavor -> flavor.getDimension() != null).map(DimensionAware::getDimension).distinct().sorted().collect(Collectors.toList());
    }

    public boolean getGeneratePureSplits() {
        return this.model.getGeneratePureSplits();
    }

    public Collection<CoreBuildType> getBuildTypes() {
        return ImmutableList.copyOf(this.model.getBuildTypes().values().stream().map(BuildTypeAdaptor::new).iterator());
    }

    public Collection<CoreProductFlavor> getProductFlavors() {
        return ImmutableList.copyOf(this.model.getProductFlavors().values().stream().map(ProductFlavorAdaptor::new).iterator());
    }

    public Collection<SigningConfig> getSigningConfigs() {
        return ImmutableList.copyOf(this.model.getSigningConfigs().values().stream().map(SigningConfigAdaptor::new).iterator());
    }

    public NamedDomainObjectContainer<AndroidSourceSet> getSourceSets() {
        return this.sourceSetsContainer;
    }

    public Boolean getPackageBuildConfig() {
        return true;
    }

    public Boolean getBaseFeature() {
        return this.model.getBaseFeature();
    }

    public ModelMap<FunctionalSourceSet> getSources() {
        return this.model.getSources();
    }

    public CoreNdkOptions getNdk() {
        return new NdkOptionsAdaptor(this.model.getNdk());
    }

    public AdbOptions getAdbOptions() {
        return this.model.getAdbOptions();
    }

    public AaptOptions getAaptOptions() {
        return this.model.getAaptOptions();
    }

    public CompileOptions getCompileOptions() {
        return this.model.getCompileOptions();
    }

    public DexOptions getDexOptions() {
        return this.model.getDexOptions();
    }

    public JacocoOptions getJacoco() {
        return this.model.getJacoco();
    }

    public LintOptions getLintOptions() {
        return this.model.getLintOptions();
    }

    public PackagingOptions getPackagingOptions() {
        return this.model.getPackagingOptions();
    }

    public TestOptions getTestOptions() {
        return this.model.getTestOptions();
    }

    public Splits getSplits() {
        return this.model.getSplits();
    }

    public CoreExternalNativeBuild getExternalNativeBuild() {
        return this.model.getExternalNativeBuild();
    }

    public DataBindingOptions getDataBinding() {
        return new DataBindingOptionsAdapter(this.model.getDataBinding());
    }

    public Collection<BaseVariantOutput> getBuildOutputs() {
        ArrayList<BaseVariantOutput> buildOutputs = new ArrayList<BaseVariantOutput>();
        Iterators.addAll(buildOutputs, (Iterator)this.model.getBuildOutputs().iterator());
        return buildOutputs;
    }

    public Collection<LibraryRequest> getLibraryRequests() {
        return this.model.getLibraryRequests();
    }

    public Collection<String> getAidlPackageWhiteList() {
        return ImmutableSet.copyOf(this.model.getAidlPackageWhitelist());
    }

    public String getTestBuildType() {
        if (this.model instanceof TestAndroidConfig) {
            return ((TestAndroidConfig)this.model).getTestBuildType();
        }
        return null;
    }

    private void applyProjectSourceSet() {
        for (String name : this.getSources().keySet()) {
            FunctionalSourceSet source = (FunctionalSourceSet)this.getSources().get(name);
            AndroidSourceSet androidSource = name.equals("main") ? (AndroidSourceSet)this.sourceSetsContainer.maybeCreate(this.getDefaultConfig().getName()) : (AndroidSourceSet)this.sourceSetsContainer.maybeCreate(name);
            AndroidConfigAdaptor.convertSourceFile(androidSource.getManifest(), source, "manifest");
            AndroidConfigAdaptor.convertSourceSet(androidSource.getResources(), source, "resource");
            AndroidConfigAdaptor.convertSourceSet(androidSource.getJava(), source, "java");
            AndroidConfigAdaptor.convertSourceSet(androidSource.getRes(), source, "res");
            AndroidConfigAdaptor.convertSourceSet(androidSource.getAssets(), source, "assets");
            AndroidConfigAdaptor.convertSourceSet(androidSource.getAidl(), source, "aidl");
            AndroidConfigAdaptor.convertSourceSet(androidSource.getRenderscript(), source, "renderscript");
            AndroidConfigAdaptor.convertSourceSet(androidSource.getJni(), source, "jni");
            AndroidConfigAdaptor.convertSourceSet(androidSource.getJniLibs(), source, "jniLibs");
        }
    }

    private static void convertSourceFile(AndroidSourceFile androidFile, FunctionalSourceSet source, String sourceName) {
        LanguageSourceSet languageSourceSet = (LanguageSourceSet)source.get(sourceName);
        if (languageSourceSet == null) {
            return;
        }
        SourceDirectorySet dir = languageSourceSet.getSource();
        if (dir == null) {
            return;
        }
        Set files = dir.getAsFileTree().getFiles();
        if (!files.isEmpty()) {
            androidFile.srcFile(Iterables.getOnlyElement((Iterable)files));
        }
    }

    private static void convertSourceSet(AndroidSourceDirectorySet androidDir, FunctionalSourceSet source, String sourceName) {
        LanguageSourceSet languageSourceSet = (LanguageSourceSet)source.get(sourceName);
        if (languageSourceSet == null) {
            return;
        }
        SourceDirectorySet dir = languageSourceSet.getSource();
        if (dir == null) {
            return;
        }
        androidDir.setSrcDirs((Iterable)dir.getSrcDirs());
        androidDir.include((Iterable)dir.getIncludes());
        androidDir.exclude((Iterable)dir.getExcludes());
    }
}

