/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.model;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.external.gson.NativeBuildConfigValue;
import com.android.build.gradle.internal.AndroidConfigHelper;
import com.android.build.gradle.internal.BuildCacheUtils;
import com.android.build.gradle.internal.ExecutionConfigurationUtil;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.JniLibsLanguageTransform;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.NativeBuildConfigGsonUtil;
import com.android.build.gradle.internal.NativeDependencyLinkage;
import com.android.build.gradle.internal.NdkOptionsHelper;
import com.android.build.gradle.internal.ProductFlavorCombo;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.ToolingRegistryProvider;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.coverage.JacocoPlugin;
import com.android.build.gradle.internal.dependency.AndroidNativeDependencySpec;
import com.android.build.gradle.internal.dependency.NativeDependencyResolveResult;
import com.android.build.gradle.internal.dependency.NativeDependencyResolver;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.model.CoreExternalNativeBuild;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.process.GradleJavaProcessExecutor;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DependencyReportTask;
import com.android.build.gradle.internal.tasks.SigningReportTask;
import com.android.build.gradle.internal.transforms.DexTransform;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.managed.BuildType;
import com.android.build.gradle.managed.DataBindingOptions;
import com.android.build.gradle.managed.NativeBuildConfig;
import com.android.build.gradle.managed.NativeLibrary;
import com.android.build.gradle.managed.NdkConfig;
import com.android.build.gradle.managed.NdkOptions;
import com.android.build.gradle.managed.ProductFlavor;
import com.android.build.gradle.managed.SigningConfig;
import com.android.build.gradle.managed.VectorDrawablesOptions;
import com.android.build.gradle.managed.adaptor.AndroidConfigAdaptor;
import com.android.build.gradle.managed.adaptor.BuildTypeAdaptor;
import com.android.build.gradle.managed.adaptor.DataBindingOptionsAdapter;
import com.android.build.gradle.managed.adaptor.ProductFlavorAdaptor;
import com.android.build.gradle.model.AndroidBinary;
import com.android.build.gradle.model.AndroidComponentModelPlugin;
import com.android.build.gradle.model.AndroidComponentSpec;
import com.android.build.gradle.model.AndroidLanguageSourceSet;
import com.android.build.gradle.model.ComponentModelBuilder;
import com.android.build.gradle.model.JniLibsSourceSet;
import com.android.build.gradle.model.NdkComponentModelPlugin;
import com.android.build.gradle.model.TaskModelMapAdaptor;
import com.android.build.gradle.model.internal.AndroidBinaryInternal;
import com.android.build.gradle.model.internal.AndroidComponentSpecInternal;
import com.android.build.gradle.model.internal.DefaultAndroidLanguageSourceSet;
import com.android.build.gradle.model.internal.DefaultJniLibsSourceSet;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.ErrorReporter;
import com.android.builder.internal.compiler.PreDexCache;
import com.android.builder.profile.ThreadRecorder;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.internal.ExecutorSingleton;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.prefs.AndroidLocation;
import com.android.resources.Density;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.model.Defaults;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class BaseComponentModelPlugin
implements Plugin<Project>,
ToolingRegistryProvider {
    private final ToolingModelBuilderRegistry toolingRegistry;
    private final ModelRegistry modelRegistry;

    @Inject
    protected BaseComponentModelPlugin(ToolingModelBuilderRegistry toolingRegistry, ModelRegistry modelRegistry) {
        this.toolingRegistry = toolingRegistry;
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project project) {
        ProjectOptions projectOptions = new ProjectOptions(project);
        ExecutionConfigurationUtil.setThreadPoolSize((ProjectOptions)projectOptions);
        project.getPlugins().apply(AndroidComponentModelPlugin.class);
        project.getPlugins().apply(JavaBasePlugin.class);
        project.getPlugins().apply(JacocoPlugin.class);
        ConfigurationContainer configurations = project.getConfigurations();
        BaseComponentModelPlugin.createConfiguration(configurations, "compile", "Classpath for compiling the default sources.");
        BaseComponentModelPlugin.createConfiguration(configurations, "testCompile", "Classpath for compiling the test sources.");
        BaseComponentModelPlugin.createConfiguration(configurations, "androidTestCompile", "Classpath for compiling the androidTest sources.");
        BaseComponentModelPlugin.createConfiguration(configurations, "provided", "Classpath for compiling the default sources.");
        BaseComponentModelPlugin.createConfiguration(configurations, "annotationProcessor", "Classpath for annotation processors.");
        project.getPlugins().apply(NdkComponentModelPlugin.class);
        this.toolingRegistry.register((ToolingModelBuilder)new ComponentModelBuilder(this.modelRegistry));
        this.modelRegistry.register(ModelRegistrations.bridgedInstance((ModelReference)ModelReference.of((String)"toolingRegistry", ToolingModelBuilderRegistry.class), (Object)this.toolingRegistry).descriptor("Tooling model builder model registry.").build());
        SdkHandler sdkHandler = this.createSdkHandler(project);
        this.modelRegistry.register(ModelRegistrations.bridgedInstance((ModelReference)ModelReference.of((String)"createSdkHandler", SdkHandler.class), (Object)sdkHandler).descriptor("SDK handler.").build());
    }

    private SdkHandler createSdkHandler(final Project project) {
        LoggerWrapper logger = new LoggerWrapper(project.getLogger());
        final SdkHandler sdkHandler = new SdkHandler(project, (ILogger)logger);
        project.getGradle().addBuildListener(new BuildListener((ILogger)logger){
            final /* synthetic */ ILogger val$logger;
            {
                this.val$logger = iLogger;
            }

            public void buildStarted(Gradle gradle) {
            }

            public void settingsEvaluated(Settings settings) {
            }

            public void projectsLoaded(Gradle gradle) {
            }

            public void projectsEvaluated(Gradle gradle) {
            }

            public void buildFinished(BuildResult buildResult) {
                if (buildResult.getGradle().getParent() != null) {
                    return;
                }
                ExecutorSingleton.shutdown();
                sdkHandler.unload();
                try {
                    PreDexCache.getCache().clear(FileUtils.join((File)project.getRootProject().getBuildDir(), (String[])new String[]{"intermediates", "dex-cache", "cache.xml"}), this.val$logger);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        project.getGradle().getTaskGraph().whenReady((Closure)new Closure<Void>((Object)this, (Object)this){

            public void doCall(TaskExecutionGraph taskGraph) {
                for (Task task : taskGraph.getAllTasks()) {
                    Transform transform;
                    if (!(task instanceof TransformTask) || !((transform = ((TransformTask)task).getTransform()) instanceof DexTransform)) continue;
                    PreDexCache.getCache().load(new File(project.getRootProject().getBuildDir(), "intermediates/dex-cache/cache.xml"));
                    break;
                }
            }
        });
        return sdkHandler;
    }

    private static void createConfiguration(ConfigurationContainer configurations, String configurationName, String configurationDescription) {
        Configuration configuration = (Configuration)configurations.findByName(configurationName);
        if (configuration == null) {
            configuration = (Configuration)configurations.create(configurationName);
        }
        configuration.setVisible(false);
        configuration.setDescription(configurationDescription);
    }

    public ToolingModelBuilderRegistry getModelBuilderRegistry() {
        return this.toolingRegistry;
    }

    public static class Rules
    extends RuleSource {
        @ComponentType
        public static void registerJniLibsSourceSet(TypeBuilder<JniLibsSourceSet> builder) {
            builder.defaultImplementation(DefaultJniLibsSourceSet.class);
        }

        @ComponentType
        public static void registerAndroidLanguageSourceSet(TypeBuilder<AndroidLanguageSourceSet> builder) {
            builder.defaultImplementation(DefaultAndroidLanguageSourceSet.class);
        }

        @Mutate
        public static void registerLanguageTransform(LanguageTransformContainer languages, ServiceRegistry serviceRegistry, NdkHandler ndkHandler) {
            languages.add((Object)new JniLibsLanguageTransform(ndkHandler));
        }

        @Defaults
        public static void configureAndroidModel(com.android.build.gradle.managed.AndroidConfig androidModel, ExtraModelInfo extraModelInfo, ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            AndroidConfigHelper.configure(androidModel, extraModelInfo, instantiator);
        }

        @Defaults
        public static void initSigningConfigs(@Path(value="android.signingConfigs") ModelMap<SigningConfig> signingConfigs) {
            signingConfigs.beforeEach(signingConfig -> {
                signingConfig.setStoreType(KeyStore.getDefaultType());
                signingConfig.setV1SigningEnabled(true);
                signingConfig.setV2SigningEnabled(true);
            });
            signingConfigs.create("debug", signingConfig -> {
                try {
                    signingConfig.setStoreFile(new File(KeystoreHelper.defaultDebugKeystoreLocation()));
                    signingConfig.setStorePassword("android");
                    signingConfig.setKeyAlias("AndroidDebugKey");
                    signingConfig.setKeyPassword("android");
                }
                catch (AndroidLocation.AndroidLocationException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        @Defaults
        public static void copyNdkConfig(@Path(value="android.defaultConfig.ndk") NdkOptions defaultNdkConfig, @Path(value="android.ndk") NdkConfig pluginNdkConfig) {
            NdkOptionsHelper.merge(defaultNdkConfig, (NdkOptions)pluginNdkConfig);
        }

        @Defaults
        public static void configureDefaultDataBindingOptions(@Path(value="android.dataBinding") DataBindingOptions dataBindingOptions) {
            dataBindingOptions.setEnabled(false);
            dataBindingOptions.setAddDefaultAdapters(true);
            dataBindingOptions.setEnabledForTests(false);
        }

        @Model(value="globalScope")
        public static GlobalScope createGlobalScope(Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, AndroidConfig androidConfig, SdkHandler sdkHandler, NdkHandler ndkHandler, ToolingModelBuilderRegistry toolingModelBuilderRegistry) {
            return new GlobalScope(project, projectOptions, androidBuilder, androidConfig, sdkHandler, ndkHandler, toolingModelBuilderRegistry, BuildCacheUtils.createBuildCacheIfEnabled((Project)project, (ProjectOptions)projectOptions));
        }

        @Mutate
        public void setUpSdkRepositories(SdkHandler sdkHandler, Project project) {
            sdkHandler.addLocalRepositories(project);
        }

        @Model(value="extraModelInfo")
        public static ExtraModelInfo createExtraModelInfo(Project project, ProjectOptions projectOptions) {
            return new ExtraModelInfo(projectOptions, project.getLogger());
        }

        @Model
        public static DataBindingBuilder createDataBindingBuilder() {
            return new DataBindingBuilder();
        }

        @Model(value="androidBuilder")
        public static AndroidBuilder createAndroidBuilder(Project project, ExtraModelInfo extraModelInfo) {
            String creator = "Android Gradle";
            LoggerWrapper logger = new LoggerWrapper(project.getLogger());
            return new AndroidBuilder(project.equals(project.getRootProject()) ? project.getName() : project.getPath(), creator, (ProcessExecutor)new GradleProcessExecutor(project), (JavaProcessExecutor)new GradleJavaProcessExecutor(project), (ErrorReporter)extraModelInfo, (ILogger)logger, project.getLogger().isEnabled(LogLevel.INFO));
        }

        @Defaults
        public static void initDebugBuildTypes(@Path(value="android.buildTypes") ModelMap<BuildType> buildTypes, @Path(value="android.signingConfigs") ModelMap<SigningConfig> signingConfigs) {
            buildTypes.beforeEach(Rules::initBuildType);
            buildTypes.named("debug", buildType -> buildType.setSigningConfig((SigningConfig)signingConfigs.get("debug")));
        }

        private static void initBuildType(BuildType buildType) {
            buildType.setDebuggable(false);
            buildType.setTestCoverageEnabled(false);
            buildType.setPseudoLocalesEnabled(false);
            buildType.setRenderscriptDebuggable(false);
            buildType.setRenderscriptOptimLevel(3);
            buildType.setMinifyEnabled(false);
            buildType.setUseProguard(true);
            buildType.setZipAlignEnabled(true);
            buildType.setEmbedMicroApp(true);
            buildType.setShrinkResources(false);
        }

        @Defaults
        public static void initDefaultConfigVectorDrawables(@Path(value="android.defaultConfig.vectorDrawables") VectorDrawablesOptions vectorDrawablesOptions) {
            vectorDrawablesOptions.setUseSupportLibrary(false);
            Set densities = Density.getRecommendedValuesForDevice();
            Set<String> strings = densities.stream().map(Density::getResourceValue).collect(Collectors.toSet());
            vectorDrawablesOptions.setGeneratedDensities(strings);
        }

        @Defaults
        public static void addDefaultAndroidSourceSet(@Path(value="android.sources") ModelMap<FunctionalSourceSet> sources) {
            sources.beforeEach(sourceSet -> {
                DefaultSourceSetAction srcDirSetter = new DefaultSourceSetAction(sourceSet.getName());
                sourceSet.create("resources", AndroidLanguageSourceSet.class, (Action)srcDirSetter);
                sourceSet.create("java", AndroidLanguageSourceSet.class, (Action)srcDirSetter);
                sourceSet.create("manifest", AndroidLanguageSourceSet.class, (Action)srcDirSetter);
                sourceSet.create("res", AndroidLanguageSourceSet.class, (Action)srcDirSetter);
                sourceSet.create("assets", AndroidLanguageSourceSet.class, (Action)srcDirSetter);
                sourceSet.create("aidl", AndroidLanguageSourceSet.class, (Action)srcDirSetter);
                sourceSet.create("renderscript", AndroidLanguageSourceSet.class, (Action)srcDirSetter);
                sourceSet.create("jniLibs", JniLibsSourceSet.class, (Action)srcDirSetter);
                sourceSet.named("manifest", manifest -> manifest.getSource().setIncludes((Iterable)ImmutableList.of((Object)"AndroidManifest.xml")));
            });
        }

        @Mutate
        public void androidConfigImplicitDependencies(com.android.build.gradle.managed.AndroidConfig androidConfig, @Path(value="android.dataBinding") DataBindingOptions dataBindingOptions) {
        }

        @Model(value="androidConfigAdaptor")
        public static AndroidConfig createModelAdaptor(ServiceRegistry serviceRegistry, com.android.build.gradle.managed.AndroidConfig androidExtension, Project project, @Path(value="isApplication") Boolean isApplication) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return new AndroidConfigAdaptor(androidExtension, AndroidConfigHelper.createSourceSetsContainer(project, instantiator, isApplication == false));
        }

        @Model(value="jniLibsDependencies")
        public static Multimap<String, NativeDependencyResolveResult> resolveJniLibsDependencies(@Path(value="binaries") ModelMap<AndroidBinary> androidBinary, @Path(value="android.sources") ModelMap<FunctionalSourceSet> sources, ServiceRegistry serviceRegistry) {
            ArrayListMultimap dependencies = ArrayListMultimap.create();
            for (AndroidBinary binary : androidBinary.values()) {
                DomainObjectSet jniSources = binary.getInputs().withType(JniLibsSourceSet.class);
                for (JniLibsSourceSet sourceSet : jniSources) {
                    dependencies.put((Object)binary.getName(), (Object)new NativeDependencyResolver(serviceRegistry, sourceSet.getDependencies(), new AndroidNativeDependencySpec(null, null, binary.getBuildType().getName(), ProductFlavorCombo.getFlavorComboName(binary.getProductFlavors()), NativeDependencyLinkage.SHARED)).resolve());
                }
            }
            return dependencies;
        }

        @Mutate
        public static void createAndroidComponents(ModelMap<AndroidComponentSpec> androidSpecs, GlobalScope globalScope, ServiceRegistry serviceRegistry, com.android.build.gradle.managed.AndroidConfig androidExtension, AndroidConfig adaptedModel, @Path(value="android.buildTypes") ModelMap<BuildType> buildTypes, @Path(value="android.productFlavors") ModelMap<ProductFlavor> productFlavors, @Path(value="android.signingConfigs") ModelMap<SigningConfig> signingConfigs, VariantFactory variantFactory, TaskManager taskManager, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, SdkHandler sdkHandler, ExtraModelInfo extraModelInfo, @Path(value="isApplication") Boolean isApplication) {
            TargetInfo targetInfo = androidBuilder.getTargetInfo();
            if (targetInfo == null) {
                sdkHandler.initTarget(androidExtension.getCompileSdkVersion(), androidExtension.getBuildToolsRevision(), androidExtension.getLibraryRequests(), androidBuilder, SdkHandler.useCachedSdk((ProjectOptions)projectOptions));
            }
            VariantManager variantManager = new VariantManager(globalScope, project, projectOptions, androidBuilder, adaptedModel, variantFactory, taskManager, ThreadRecorder.get());
            variantFactory.validateModel((VariantModel)variantManager);
            for (BuildType buildType : buildTypes.values()) {
                variantManager.addBuildType((CoreBuildType)new BuildTypeAdaptor(buildType));
            }
            for (ProductFlavor productFlavor : productFlavors.values()) {
                variantManager.addProductFlavor((CoreProductFlavor)new ProductFlavorAdaptor(productFlavor));
            }
            androidSpecs.named("android", androidSpec -> {
                AndroidComponentSpecInternal spec = (AndroidComponentSpecInternal)androidSpec;
                spec.setExtension(androidExtension);
                spec.setVariantManager(variantManager);
            });
        }

        @Mutate
        public static void createVariantData(@Path(value="binaries") ModelMap<AndroidBinaryInternal> binaries, ModelMap<AndroidComponentSpec> specs, TaskManager taskManager) {
            VariantManager variantManager = ((AndroidComponentSpecInternal)specs.get("android")).getVariantManager();
            binaries.afterEach(binary -> {
                List adaptedFlavors = binary.getProductFlavors().stream().map(ProductFlavorAdaptor::new).collect(Collectors.toList());
                binary.setVariantData(variantManager.createVariantData((com.android.builder.model.BuildType)new BuildTypeAdaptor(binary.getBuildType()), adaptedFlavors, true));
                for (BaseVariantData variantData : binary.getVariantData()) {
                    variantManager.addVariant(variantData);
                }
            });
        }

        @Defaults
        public static void createLifeCycleTasks(ModelMap<Task> tasks, TaskManager taskManager) {
            taskManager.createTasksBeforeEvaluate((TaskFactory)new TaskModelMapAdaptor(tasks));
        }

        @Mutate
        public static void addDataBindingDependenciesIfNecessary(TaskManager taskManager, @Path(value="android.dataBinding") DataBindingOptions dataBindingOptions) {
            taskManager.addDataBindingDependenciesIfNecessary((com.android.builder.model.DataBindingOptions)new DataBindingOptionsAdapter(dataBindingOptions));
        }

        @Mutate
        public static void createAndroidTasks(ModelMap<Task> tasks, ModelMap<AndroidComponentSpec> androidSpecs, TaskManager taskManager, SdkHandler sdkHandler, Project project, @Path(value="android.sources") ModelMap<FunctionalSourceSet> androidSources) {
            sdkHandler.addLocalRepositories(project);
        }

        @Mutate
        public static void createBinaryTasks(ModelMap<Task> tasks, @Path(value="binaries") ModelMap<AndroidBinaryInternal> binaries, ModelMap<AndroidComponentSpec> specs, TaskManager taskManager) {
            taskManager.configureCustomLintChecks((TaskFactory)new TaskModelMapAdaptor(tasks));
            VariantManager variantManager = ((AndroidComponentSpecInternal)specs.get("android")).getVariantManager();
            variantManager.configureDependencies();
            for (AndroidBinaryInternal binary : binaries) {
                for (BaseVariantData variantData : binary.getVariantData()) {
                    variantManager.createTasksForVariantData((TaskFactory)new TaskModelMapAdaptor(tasks), variantData.getScope());
                }
            }
        }

        @Model(value="nativeBuildConfigValues")
        public static List<NativeBuildConfigValue> createExternalNativeBuildJsonGenerators(Project project, ProjectOptions projectOptions, com.android.build.gradle.managed.AndroidConfig androidExtension, AndroidBuilder androidBuilder, SdkHandler sdkHandler, ModelMap<AndroidComponentSpec> specs) throws IOException, ProcessException {
            CoreExternalNativeBuild externalNativeBuild = androidExtension.getExternalNativeBuild();
            ExternalNativeBuildTaskUtils.ExternalNativeBuildProjectPathResolution pathResolution = ExternalNativeBuildTaskUtils.getProjectPath((CoreExternalNativeBuild)externalNativeBuild);
            if (pathResolution.makeFile == null) {
                return Lists.newArrayList();
            }
            boolean createJsons = ExternalNativeBuildTaskUtils.shouldRegenerateOutOfDateJsons((ProjectOptions)projectOptions);
            boolean forceRegeneration = projectOptions.get(BooleanOption.IDE_REFRESH_EXTERNAL_NATIVE_MODEL);
            VariantManager variantManager = ((AndroidComponentSpecInternal)specs.get("android")).getVariantManager();
            ArrayList configValues = Lists.newArrayList();
            for (VariantScope variantScope : variantManager.getVariantScopes()) {
                ExternalNativeJsonGenerator generator;
                if (variantScope.getVariantData().getType().isForTesting() || (generator = ExternalNativeJsonGenerator.create((File)project.getProjectDir(), (File)project.getBuildDir(), (File)pathResolution.externalNativeBuildDir, (NativeBuildSystem)pathResolution.buildSystem, (File)pathResolution.makeFile, (AndroidBuilder)androidBuilder, (SdkHandler)sdkHandler, (VariantScope)variantScope)) == null) continue;
                if (createJsons) {
                    generator.build(forceRegeneration);
                }
                configValues.addAll(generator.readExistingNativeBuildConfigurations());
            }
            return configValues;
        }

        @Mutate
        public static void modifyBuildSystemList(@Path(value="nativeBuildSystems") List<String> buildSystems, com.android.build.gradle.managed.AndroidConfig androidExtension) {
            CoreExternalNativeBuild externalNativeBuild = androidExtension.getExternalNativeBuild();
            ExternalNativeBuildTaskUtils.ExternalNativeBuildProjectPathResolution pathResolution = ExternalNativeBuildTaskUtils.getProjectPath((CoreExternalNativeBuild)externalNativeBuild);
            if (pathResolution.buildSystem != null) {
                buildSystems.add(pathResolution.buildSystem.getName());
            }
        }

        @Mutate
        public static void modifyNativeBuildModel(@Path(value="nativeBuildConfig") NativeBuildConfig config, @Path(value="nativeBuildConfigValues") List<NativeBuildConfigValue> configValues) {
            for (NativeBuildConfigValue configValue : configValues) {
                NativeBuildConfigGsonUtil.copyToNativeBuildConfig(configValue, config);
            }
            config.getLibraries().afterEach((Action)new Action<NativeLibrary>(){

                public void execute(NativeLibrary nativeLibrary) {
                    nativeLibrary.setAssembleTaskName(String.format("%sExternalNativeBuild", nativeLibrary.getGroupName()));
                }
            });
        }

        @Defaults
        public static void createRemainingTasks(ModelMap<Task> tasks, TaskManager taskManager, ModelMap<AndroidComponentSpec> spec) {
            VariantManager variantManager = ((AndroidComponentSpecInternal)spec.get("android")).getVariantManager();
            taskManager.createTopLevelTestTasks((TaskFactory)new TaskModelMapAdaptor(tasks), !variantManager.getProductFlavors().isEmpty());
        }

        @Mutate
        public static void createRemainingTasksForReal(ModelMap<Task> tasks, TaskManager taskManager, ModelMap<AndroidComponentSpec> spec) {
            VariantManager variantManager = ((AndroidComponentSpecInternal)spec.get("android")).getVariantManager();
            taskManager.configureGlobalLintTask((Collection)variantManager.getVariantScopes());
        }

        @Mutate
        public static void createReportTasks(ModelMap<Task> tasks, ModelMap<AndroidComponentSpecInternal> specs) {
            VariantManager variantManager = ((AndroidComponentSpecInternal)specs.get("android")).getVariantManager();
            tasks.create("androidDependencies", DependencyReportTask.class, dependencyReportTask -> {
                dependencyReportTask.setDescription("Displays the Android dependencies of the project");
                dependencyReportTask.setVariants((Collection)variantManager.getVariantScopes());
                dependencyReportTask.setGroup("Android");
            });
            tasks.create("signingReport", SigningReportTask.class, signingReportTask -> {
                signingReportTask.setDescription("Displays the signing info for each variant");
                signingReportTask.setVariants((Collection)variantManager.getVariantScopes());
                signingReportTask.setGroup("Android");
            });
        }

        @Mutate
        public static void modifyAssembleTaskDescription(@Path(value="tasks.assemble") Task assembleTask) {
            assembleTask.setDescription("Assembles all variants of all applications and secondary packages.");
        }

        private static class DefaultSourceSetAction
        implements Action<LanguageSourceSet> {
            private final String name;

            private DefaultSourceSetAction(String name) {
                this.name = name;
            }

            public void execute(LanguageSourceSet sourceSet) {
                sourceSet.getSource().setSrcDirs(Collections.singleton("src/" + this.name + "/" + sourceSet.getName()));
            }
        }
    }
}

