/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.NativeToolSpecification;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.Map;
import org.gradle.nativeplatform.platform.NativePlatform;

public class ClangNativeToolSpecification
implements NativeToolSpecification {
    private NdkHandler ndkHandler;
    private NativePlatform platform;
    private boolean isDebugBuild;
    private static final Map<String, String> TARGET_TRIPLE = ImmutableMap.builder().put((Object)"x86", (Object)"i686-none-linux-android").put((Object)"x86_64", (Object)"x86_64-none-linux-android").put((Object)"armeabi", (Object)"armv5-none-linux-android").put((Object)"armeabi-v7a", (Object)"armv7-none-linux-android").put((Object)"arm64-v8a", (Object)"aarch64-none-linux-android").put((Object)"mips", (Object)"mipsel-none-linux-android").put((Object)"mips64", (Object)"mips64el-none-linux-android").build();
    private static final ListMultimap<String, String> RELEASE_CFLAGS = ImmutableListMultimap.builder().putAll((Object)"armeabi", (Iterable)ImmutableList.of((Object)"-fpic", (Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-fstack-protector", (Object)"-no-canonical-prefixes", (Object)"-march=armv5te", (Object)"-mtune=xscale", (Object)"-msoft-float", (Object)"-mthumb", (Object)"-Os", (Object)"-g", (Object)"-DNDEBUG", (Object[])new String[]{"-fomit-frame-pointer", "-fstrict-aliasing"})).putAll((Object)"armeabi-v7a", (Iterable)ImmutableList.of((Object)"-fpic", (Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-fstack-protector", (Object)"-no-canonical-prefixes", (Object)"-march=armv7-a", (Object)"-mfloat-abi=softfp", (Object)"-mfpu=vfpv3-d16", (Object)"-mthumb", (Object)"-Os", (Object)"-g", (Object)"-DNDEBUG", (Object[])new String[]{"-fomit-frame-pointer", "-fstrict-aliasing"})).putAll((Object)"arm64-v8a", (Iterable)ImmutableList.of((Object)"-fpic", (Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-fstack-protector", (Object)"-no-canonical-prefixes", (Object)"-O2", (Object)"-g", (Object)"-DNDEBUG", (Object)"-fomit-frame-pointer", (Object)"-fstrict-aliasing")).putAll((Object)"x86", (Iterable)ImmutableList.of((Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-fstack-protector", (Object)"-fPIC", (Object)"-no-canonical-prefixes", (Object)"-O2", (Object)"-g", (Object)"-DNDEBUG", (Object)"-fomit-frame-pointer", (Object)"-fstrict-aliasing")).putAll((Object)"x86_64", (Iterable)ImmutableList.of((Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-fstack-protector", (Object)"-fPIC", (Object)"-no-canonical-prefixes", (Object)"-O2", (Object)"-g", (Object)"-DNDEBUG", (Object)"-fomit-frame-pointer", (Object)"-fstrict-aliasing")).putAll((Object)"mips", (Iterable)ImmutableList.of((Object)"-mips32", (Object)"-fpic", (Object)"-fno-strict-aliasing", (Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-fmessage-length=0", (Object)"-no-canonical-prefixes", (Object)"-O2", (Object)"-g", (Object)"-DNDEBUG", (Object)"-fomit-frame-pointer")).putAll((Object)"mips64", (Iterable)ImmutableList.of((Object)"-fpic", (Object)"-fno-strict-aliasing", (Object)"-finline-functions", (Object)"-ffunction-sections", (Object)"-funwind-tables", (Object)"-fmessage-length=0", (Object)"-no-canonical-prefixes", (Object)"-O2", (Object)"-g", (Object)"-DNDEBUG", (Object)"-fomit-frame-pointer", (Object)"-fintegrated-as", (Object[])new String[0])).build();
    private static final ListMultimap<String, String> DEBUG_CFLAGS = ImmutableListMultimap.builder().putAll((Object)"armeabi", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-marm", (Object)"-fno-strict-aliasing", (Object)"-fno-limit-debug-info")).putAll((Object)"armeabi-v7a", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-marm", (Object)"-fno-strict-aliasing", (Object)"-fno-limit-debug-info")).putAll((Object)"arm64-v8a", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-fno-omit-frame-pointer", (Object)"-fno-strict-aliasing", (Object)"-fno-limit-debug-info")).putAll((Object)"x86", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-fno-omit-frame-pointer", (Object)"-fno-strict-aliasing", (Object)"-fno-limit-debug-info")).putAll((Object)"x86_64", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-fno-omit-frame-pointer", (Object)"-fno-strict-aliasing", (Object)"-fno-limit-debug-info")).putAll((Object)"mips", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-fno-omit-frame-pointer", (Object)"-fno-limit-debug-info")).putAll((Object)"mips64", (Iterable)ImmutableList.of((Object)"-O0", (Object)"-UNDEBUG", (Object)"-fno-omit-frame-pointer", (Object)"-fno-limit-debug-info")).build();

    public ClangNativeToolSpecification(NdkHandler ndkHandler, NativePlatform platform, boolean isDebugBuild) {
        this.ndkHandler = ndkHandler;
        this.isDebugBuild = isDebugBuild;
        this.platform = platform;
    }

    public Iterable<String> getCFlags() {
        return Iterables.concat(this.getTargetFlags(), (Iterable)RELEASE_CFLAGS.get((Object)this.platform.getName()), (Iterable)(this.isDebugBuild ? DEBUG_CFLAGS.get((Object)this.platform.getName()) : ImmutableList.of()));
    }

    public Iterable<String> getCppFlags() {
        return this.getCFlags();
    }

    public Iterable<String> getLdFlags() {
        ImmutableList flags;
        switch (this.platform.getName()) {
            case "armeabi-v7a": {
                flags = ImmutableList.of((Object)"-Wl,--fix-cortex-a8");
                break;
            }
            case "mips": {
                flags = ImmutableList.of((Object)"-mips32");
                break;
            }
            default: {
                flags = ImmutableList.of();
            }
        }
        return Iterables.concat(this.getTargetFlags(), (Iterable)flags);
    }

    private Iterable<String> getTargetFlags() {
        return ImmutableList.of((Object)"-gcc-toolchain", (Object)this.ndkHandler.getDefaultGccToolchainPath(Abi.getByName((String)this.platform.getName())).toString(), (Object)"-target", (Object)TARGET_TRIPLE.get(this.platform.getName()));
    }
}

