/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.Toolchain;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.managed.NdkAbiOptions;
import com.android.utils.FileUtils;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.model.ModelMap;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.Clang;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.nativeplatform.toolchain.NativeToolChainRegistry;
import org.gradle.nativeplatform.toolchain.internal.gcc.DefaultGccPlatformToolChain;
import org.gradle.platform.base.PlatformContainer;

public class ToolchainConfiguration {
    public static void configurePlatforms(PlatformContainer platforms, NdkHandler ndkHandler) {
        for (Abi abi : ndkHandler.getSupportedAbis()) {
            NativePlatform platform = (NativePlatform)platforms.maybeCreate(abi.getName(), NativePlatform.class);
            platform.architecture("ppc");
            platform.operatingSystem("linux");
        }
    }

    public static void configureToolchain(NativeToolChainRegistry toolchainRegistry, String toolchainName, ModelMap<NdkAbiOptions> abiConfigs, NdkHandler ndkHandler) {
        Toolchain ndkToolchain = Toolchain.getByName((String)toolchainName);
        toolchainRegistry.create("ndk-" + toolchainName, toolchainName.equals("gcc") ? Gcc.class : Clang.class, toolchain -> {
            for (Abi abi : ndkHandler.getSupportedAbis()) {
                toolchain.target(abi.getName(), targetPlatform -> {
                    if ((ndkHandler.getRevision() == null || ndkHandler.getRevision().getMajor() <= 12) && OperatingSystem.current().isWindows() && toolchainName.equals("clang")) {
                        ((DefaultGccPlatformToolChain)targetPlatform).setCanUseCommandFile(false);
                    }
                    if (Toolchain.GCC == ndkToolchain) {
                        targetPlatform.getcCompiler().setExecutable(ndkHandler.getCCompiler(abi).getName());
                        targetPlatform.getCppCompiler().setExecutable(ndkHandler.getCppCompiler(abi).getName());
                        targetPlatform.getLinker().setExecutable(ndkHandler.getLinker(abi).getName());
                        targetPlatform.getAssembler().setExecutable(ndkHandler.getAssembler(abi).getName());
                    }
                    targetPlatform.getStaticLibArchiver().setExecutable(ndkHandler.getAr(abi).getName());
                    targetPlatform.getLinker().withArguments(args -> args.removeAll(Collections.singleton("-Xlinker")));
                    NdkAbiOptions config = (NdkAbiOptions)abiConfigs.get(abi.getName());
                    String platformVersion = config != null && config.getPlatformVersion() != null ? config.getPlatformVersion() : ndkHandler.getPlatformVersion();
                    String compilerSysroot = ndkHandler.getCompilerSysroot(abi, platformVersion);
                    if (ndkHandler.isUseUnifiedHeaders() && platformVersion != null) {
                        Pattern pattern = Pattern.compile("android-(\\d+)");
                        Matcher matcher = pattern.matcher(platformVersion);
                        if (matcher.matches()) {
                            String api = matcher.group(1);
                            targetPlatform.getcCompiler().withArguments(args -> args.add("-D__ANDROID_API__=" + api));
                            targetPlatform.getCppCompiler().withArguments(args -> args.add("-D__ANDROID_API__=" + api));
                        }
                        targetPlatform.getcCompiler().withArguments(args -> {
                            args.add("-isystem");
                            args.add(FileUtils.join((String[])new String[]{compilerSysroot, "usr", "include", abi.getGccExecutablePrefix()}));
                        });
                        targetPlatform.getCppCompiler().withArguments(args -> {
                            args.add("-isystem");
                            args.add(FileUtils.join((String[])new String[]{compilerSysroot, "usr", "include", abi.getGccExecutablePrefix()}));
                        });
                    }
                    targetPlatform.getcCompiler().withArguments(args -> args.add("--sysroot=" + compilerSysroot));
                    targetPlatform.getCppCompiler().withArguments(args -> args.add("--sysroot=" + compilerSysroot));
                    targetPlatform.getLinker().withArguments(args -> args.add("--sysroot=" + ndkHandler.getLinkerSysroot(abi, platformVersion)));
                    if (config != null) {
                        targetPlatform.getcCompiler().withArguments(args -> args.addAll(config.getCFlags()));
                        targetPlatform.getCppCompiler().withArguments(args -> args.addAll(config.getCppFlags()));
                        targetPlatform.getLinker().withArguments(args -> {
                            args.addAll(config.getLdFlags());
                            for (String lib : config.getLdLibs()) {
                                args.add("-l" + lib);
                            }
                        });
                    }
                });
                toolchain.path(new Object[]{ndkHandler.getCCompiler(abi).getParentFile(), ndkHandler.getAr(abi).getParentFile()});
            }
        });
    }
}

