/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.ndk.internal.NdkNamingScheme;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

public class StripDependenciesTask
extends DefaultTask {
    private Map<Abi, File> stripExecutables = Maps.newHashMap();
    private Map<File, Abi> inputFiles = Maps.newHashMap();
    private Multimap<File, Abi> stripedFiles = ArrayListMultimap.create();
    private File outputFolder;

    @Input
    public Collection<File> getStripExecutables() {
        return ImmutableList.copyOf(this.stripExecutables.values());
    }

    public void addStripExecutables(Map<Abi, File> stripCommands) {
        this.stripExecutables.putAll(stripCommands);
    }

    @OutputDirectory
    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    @InputFiles
    Iterable<File> getInputFiles() {
        return Iterables.concat((Iterable)this.stripedFiles.keySet(), this.inputFiles.keySet());
    }

    public void addInputFiles(Map<File, Abi> files) {
        this.inputFiles.putAll(files);
    }

    public void addStripedFiles(Multimap<File, Abi> files) {
        this.stripedFiles.putAll(files);
    }

    @TaskAction
    void taskAction(IncrementalTaskInputs inputs) throws IOException {
        inputs.outOfDate(inputFileDetails -> {
            File input = inputFileDetails.getFile();
            if (this.inputFiles.containsKey(input)) {
                Abi abi = this.inputFiles.get(input);
                File output = FileUtils.join((File)this.getOutputFolder(), (String[])new String[]{abi.getName(), input.getName()});
                this.stripFile(input, output, abi);
            } else {
                for (Abi abi : this.stripedFiles.get((Object)input)) {
                    File output = FileUtils.join((File)this.getOutputFolder(), (String[])new String[]{abi.getName(), input.getName()});
                    try {
                        FileUtils.mkdirs((File)output.getParentFile());
                        Files.copy((File)input, (File)output);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        inputs.removed(inputFileDetails -> {
            File input = inputFileDetails.getFile();
            if (this.inputFiles.containsKey(input)) {
                this.removeFile(input, this.inputFiles.get(input));
            } else {
                for (Abi abi : this.stripedFiles.get((Object)input)) {
                    this.removeFile(input, abi);
                }
            }
        });
    }

    private void removeFile(File file, Abi abi) {
        File output = FileUtils.join((File)this.getOutputFolder(), (String[])new String[]{abi.getName(), file.getName()});
        try {
            FileUtils.deleteIfExists((File)output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void stripFile(File input, File output, Abi abi) {
        boolean result;
        File outputDir = output.getParentFile();
        if (!output.getParentFile().exists() && !(result = outputDir.mkdirs())) {
            throw new RuntimeException("Unabled to create directory '" + outputDir.toString() + "' for native binaries.");
        }
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.stripExecutables.get(abi));
        builder.addArgs("--strip-unneeded");
        builder.addArgs("-o");
        builder.addArgs(output.toString());
        builder.addArgs(input.toString());
        new GradleProcessExecutor(this.getProject()).execute(builder.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)new LoggerWrapper(this.getLogger())));
    }

    public static class ConfigAction
    implements Action<StripDependenciesTask> {
        private final String buildType;
        private final String flavor;
        private final Map<File, Abi> inputFiles;
        private final Multimap<File, Abi> stripedFiles;
        private final File buildDir;
        private final NdkHandler handler;

        public ConfigAction(String buildType, String flavor, Map<File, Abi> inputFiles, Multimap<File, Abi> stripedFiles, File buildDir, NdkHandler handler) {
            this.buildType = buildType;
            this.flavor = flavor;
            this.buildDir = buildDir;
            this.handler = handler;
            this.inputFiles = inputFiles;
            this.stripedFiles = stripedFiles;
        }

        public void execute(StripDependenciesTask task) {
            task.addInputFiles(this.inputFiles);
            task.addStripedFiles(this.stripedFiles);
            task.setOutputFolder(new File(this.buildDir, NdkNamingScheme.getOutputDirectoryName(this.buildType, this.flavor, "")));
            HashMap stripCommands = Maps.newHashMap();
            if (this.handler.isConfigured()) {
                for (Abi abi : this.handler.getSupportedAbis()) {
                    stripCommands.put(abi, this.handler.getStripExecutable(abi));
                    task.addStripExecutables(stripCommands);
                }
            }
        }
    }
}

