/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.beust.jcommander.internal.Sets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.analysis.ClassProvider;
import org.jf.dexlib2.analysis.DexClassProvider;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedOdexFile;
import org.jf.dexlib2.dexbacked.OatFile;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.MultiDexContainer;

public class ClassPathResolver {
    private final Iterable<String> classPathDirs;
    private final Opcodes opcodes;
    private final Set<File> loadedFiles = Sets.newHashSet();
    private final List<ClassProvider> classProviders = Lists.newArrayList();

    public ClassPathResolver(@Nonnull List<String> bootClassPathDirs, @Nonnull List<String> bootClassPathEntries, @Nonnull List<String> extraClassPathEntries, @Nonnull DexFile dexFile) throws IOException {
        this(bootClassPathDirs, bootClassPathEntries, extraClassPathEntries, dexFile, true);
    }

    public ClassPathResolver(@Nonnull List<String> bootClassPathDirs, @Nonnull List<String> extraClassPathEntries, @Nonnull DexFile dexFile) throws IOException {
        this(bootClassPathDirs, null, extraClassPathEntries, dexFile, true);
    }

    private ClassPathResolver(@Nonnull List<String> bootClassPathDirs, @Nullable List<String> bootClassPathEntries, @Nonnull List<String> extraClassPathEntries, @Nonnull DexFile dexFile, boolean unused) throws IOException {
        this.classPathDirs = bootClassPathDirs;
        this.opcodes = dexFile.getOpcodes();
        if (bootClassPathEntries == null) {
            bootClassPathEntries = ClassPathResolver.getDefaultBootClassPath(dexFile, this.opcodes.api);
        }
        for (String entry : bootClassPathEntries) {
            try {
                this.loadLocalOrDeviceBootClassPathEntry(entry);
            }
            catch (NoDexException ex) {
                if (entry.endsWith(".jar")) {
                    String odexEntry = entry.substring(0, entry.length() - 4) + ".odex";
                    try {
                        this.loadLocalOrDeviceBootClassPathEntry(odexEntry);
                        continue;
                    }
                    catch (NoDexException ex2) {
                        throw new ResolveException("Neither %s nor %s contain a dex file", entry, odexEntry);
                    }
                    catch (NotFoundException ex2) {
                        throw new ResolveException(ex);
                    }
                }
                throw new ResolveException(ex);
            }
            catch (NotFoundException ex) {
                if (entry.endsWith(".odex")) {
                    String jarEntry = entry.substring(0, entry.length() - 5) + ".jar";
                    try {
                        this.loadLocalOrDeviceBootClassPathEntry(jarEntry);
                        continue;
                    }
                    catch (NoDexException ex2) {
                        throw new ResolveException("Neither %s nor %s contain a dex file", entry, jarEntry);
                    }
                    catch (NotFoundException ex2) {
                        throw new ResolveException(ex);
                    }
                }
                throw new ResolveException(ex);
            }
        }
        for (String entry : extraClassPathEntries) {
            try {
                this.loadLocalClassPathEntry(entry);
            }
            catch (NoDexException ex) {
                throw new ResolveException(ex);
            }
        }
        if (dexFile instanceof MultiDexContainer.MultiDexFile) {
            MultiDexContainer<? extends MultiDexContainer.MultiDexFile> container = ((MultiDexContainer.MultiDexFile)dexFile).getContainer();
            for (String entry : container.getDexEntryNames()) {
                this.classProviders.add(new DexClassProvider(container.getEntry(entry)));
            }
        } else {
            this.classProviders.add(new DexClassProvider(dexFile));
        }
    }

    @Nonnull
    public List<ClassProvider> getResolvedClassProviders() {
        return this.classProviders;
    }

    private boolean loadLocalClassPathEntry(@Nonnull String entry) throws NoDexException, IOException {
        File entryFile = new File(entry);
        if (entryFile.exists() && entryFile.isFile()) {
            try {
                this.loadEntry(entryFile, true);
                return true;
            }
            catch (DexFileFactory.UnsupportedFileTypeException ex) {
                throw new ResolveException((Throwable)((Object)ex), "Couldn't load classpath entry %s", entry);
            }
        }
        return false;
    }

    private void loadLocalOrDeviceBootClassPathEntry(@Nonnull String entry) throws IOException, NoDexException, NotFoundException {
        if (this.loadLocalClassPathEntry(entry)) {
            return;
        }
        List<String> pathComponents = ClassPathResolver.splitDevicePath(entry);
        Joiner pathJoiner = Joiner.on((char)File.pathSeparatorChar);
        for (String directory : this.classPathDirs) {
            File directoryFile = new File(directory);
            if (!directoryFile.exists()) continue;
            for (int i = 0; i < pathComponents.size(); ++i) {
                String partialPath = pathJoiner.join(pathComponents.subList(i, pathComponents.size()));
                File entryFile = new File(directoryFile, partialPath);
                if (!entryFile.exists() || !entryFile.isFile()) continue;
                this.loadEntry(entryFile, true);
                return;
            }
        }
        throw new NotFoundException("Could not find classpath entry %s", entry);
    }

    private void loadEntry(@Nonnull File entryFile, boolean loadOatDependencies) throws IOException, NoDexException {
        List<String> oatDependencies;
        MultiDexContainer<? extends DexBackedDexFile> container;
        if (this.loadedFiles.contains(entryFile)) {
            return;
        }
        try {
            container = DexFileFactory.loadDexContainer(entryFile, this.opcodes);
        }
        catch (DexFileFactory.UnsupportedFileTypeException ex) {
            throw new ResolveException((Throwable)((Object)ex));
        }
        List<String> entryNames = container.getDexEntryNames();
        if (entryNames.size() == 0) {
            throw new NoDexException("%s contains no dex file", entryFile);
        }
        this.loadedFiles.add(entryFile);
        for (String entryName : entryNames) {
            this.classProviders.add(new DexClassProvider(container.getEntry(entryName)));
        }
        if (loadOatDependencies && container instanceof OatFile && !(oatDependencies = ((OatFile)container).getBootClassPath()).isEmpty()) {
            try {
                this.loadOatDependencies(entryFile.getParentFile(), oatDependencies);
            }
            catch (NotFoundException ex) {
                throw new ResolveException(ex, "Error while loading oat file %s", entryFile);
            }
            catch (NoDexException ex) {
                throw new ResolveException(ex, "Error while loading dependencies for oat file %s", entryFile);
            }
        }
    }

    @Nonnull
    private static List<String> splitDevicePath(@Nonnull String path) {
        return Lists.newArrayList((Iterable)Splitter.on((char)'/').split((CharSequence)path));
    }

    private void loadOatDependencies(@Nonnull File directory, @Nonnull List<String> oatDependencies) throws IOException, NoDexException, NotFoundException {
        for (String oatDependency : oatDependencies) {
            String oatDependencyName = this.getFilenameForOatDependency(oatDependency);
            File file = new File(directory, oatDependencyName);
            if (!file.exists()) {
                throw new NotFoundException("Cannot find dependency %s in %s", oatDependencyName, directory);
            }
            this.loadEntry(file, false);
        }
    }

    @Nonnull
    private String getFilenameForOatDependency(String oatDependency) {
        int index = oatDependency.lastIndexOf(47);
        String dependencyLeaf = oatDependency.substring(index + 1);
        if (dependencyLeaf.endsWith(".art")) {
            return dependencyLeaf.substring(0, dependencyLeaf.length() - 4) + ".oat";
        }
        return dependencyLeaf;
    }

    @Nonnull
    private static List<String> getDefaultBootClassPath(@Nonnull DexFile dexFile, int apiLevel) {
        if (dexFile instanceof OatFile.OatDexFile) {
            List<String> bcp = ((OatFile.OatDexFile)dexFile).getContainer().getBootClassPath();
            if (!bcp.isEmpty()) {
                for (int i = 0; i < bcp.size(); ++i) {
                    String entry = bcp.get(i);
                    if (!entry.endsWith(".art")) continue;
                    bcp.set(i, entry.substring(0, entry.length() - 4) + ".oat");
                }
                return bcp;
            }
            return Lists.newArrayList((Object[])new String[]{"boot.oat"});
        }
        if (dexFile instanceof DexBackedOdexFile) {
            return ((DexBackedOdexFile)dexFile).getDependencies();
        }
        if (apiLevel <= 8) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar"});
        }
        if (apiLevel <= 11) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/core-junit.jar"});
        }
        if (apiLevel <= 13) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/apache-xml.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/core-junit.jar"});
        }
        if (apiLevel <= 15) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar", "/system/framework/filterfw.jar"});
        }
        if (apiLevel <= 17) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar"});
        }
        if (apiLevel <= 18) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar"});
        }
        if (apiLevel <= 19) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core.jar", "/system/framework/conscrypt.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/framework2.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/services.jar", "/system/framework/apache-xml.jar", "/system/framework/webviewchromium.jar"});
        }
        if (apiLevel <= 22) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core-libart.jar", "/system/framework/conscrypt.jar", "/system/framework/okhttp.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/ims-common.jar", "/system/framework/mms-common.jar", "/system/framework/android.policy.jar", "/system/framework/apache-xml.jar"});
        }
        if (apiLevel <= 23) {
            return Lists.newArrayList((Object[])new String[]{"/system/framework/core-libart.jar", "/system/framework/conscrypt.jar", "/system/framework/okhttp.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/ims-common.jar", "/system/framework/apache-xml.jar", "/system/framework/org.apache.http.legacy.boot.jar"});
        }
        return Lists.newArrayList((Object[])new String[]{"/system/framework/core-oj.jar", "/system/framework/core-libart.jar", "/system/framework/conscrypt.jar", "/system/framework/okhttp.jar", "/system/framework/core-junit.jar", "/system/framework/bouncycastle.jar", "/system/framework/ext.jar", "/system/framework/framework.jar", "/system/framework/telephony-common.jar", "/system/framework/voip-common.jar", "/system/framework/ims-common.jar", "/system/framework/apache-xml.jar", "/system/framework/org.apache.http.legacy.boot.jar"});
    }

    public static class ResolveException
    extends RuntimeException {
        public ResolveException(String message, Object ... formatArgs) {
            super(String.format(message, formatArgs));
        }

        public ResolveException(Throwable cause) {
            super(cause);
        }

        public ResolveException(Throwable cause, String message, Object ... formatArgs) {
            super(String.format(message, formatArgs), cause);
        }
    }

    private static class NoDexException
    extends Exception {
        public NoDexException(String message, Object ... formatArgs) {
            super(String.format(message, formatArgs));
        }
    }

    private static class NotFoundException
    extends Exception {
        public NotFoundException(String message, Object ... formatArgs) {
            super(String.format(message, formatArgs));
        }
    }
}

