/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import com.android.ide.common.rendering.api.Bridge;
import com.android.ide.common.rendering.api.Capability;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LayoutLibrary {
    private final Bridge mBridge;
    private final ClassLoader mClassLoader;
    private Method mViewGetParentMethod;
    private Method mViewGetBaselineMethod;
    private Class<?> mMarginLayoutParamClass;
    private Field mLeftMarginField;
    private Field mTopMarginField;
    private Field mRightMarginField;
    private Field mBottomMarginField;

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    static LayoutLibrary load(Bridge bridge, ClassLoader classLoader) {
        return new LayoutLibrary(bridge, classLoader);
    }

    private LayoutLibrary(Bridge bridge, ClassLoader classLoader) {
        this.mBridge = bridge;
        this.mClassLoader = classLoader;
    }

    public int getApiLevel() {
        if (this.mBridge != null) {
            return this.mBridge.getApiLevel();
        }
        return 0;
    }

    public int getRevision() {
        if (this.mBridge != null) {
            return this.mBridge.getRevision();
        }
        return 0;
    }

    @Deprecated
    public boolean supports(Capability capability) {
        return this.supports(capability.ordinal());
    }

    public boolean supports(int capability) {
        if (this.mBridge != null) {
            if (this.mBridge.getApiLevel() > 12) {
                return this.mBridge.supports(capability);
            }
            return capability <= 13 && this.mBridge.getCapabilities().contains(Capability.values()[capability]);
        }
        return false;
    }

    public boolean init(Map<String, String> platformProperties, File fontLocation, Map<String, Map<String, Integer>> enumValueMap, LayoutLog log) {
        if (this.mBridge != null) {
            return this.mBridge.init(platformProperties, fontLocation, enumValueMap, log);
        }
        return false;
    }

    public boolean dispose() {
        if (this.mBridge != null) {
            return this.mBridge.dispose();
        }
        return true;
    }

    public RenderSession createSession(SessionParams params) {
        if (this.mBridge != null) {
            List infoList;
            RenderSession session = this.mBridge.createSession(params);
            if (params.getExtendedViewInfoMode() && !this.supports(9) && (infoList = session.getRootViews()) != null) {
                for (ViewInfo info : infoList) {
                    this.addExtendedViewInfo(info);
                }
            }
            return session;
        }
        return null;
    }

    public Result renderDrawable(DrawableParams params) {
        if (this.mBridge != null) {
            return this.mBridge.renderDrawable(params);
        }
        return Result.Status.NOT_IMPLEMENTED.createResult();
    }

    public void clearCaches(Object projectKey) {
        if (this.mBridge != null) {
            this.mBridge.clearCaches(projectKey);
        }
    }

    public Result getViewParent(Object viewObject) {
        Result r;
        if (this.mBridge != null && (r = this.mBridge.getViewParent(viewObject)).isSuccess()) {
            return r;
        }
        return this.getViewParentWithReflection(viewObject);
    }

    public boolean isRtl(String locale) {
        return this.supports(11) && this.mBridge != null && this.mBridge.isRtl(locale);
    }

    private Result getViewParentWithReflection(Object viewObject) {
        try {
            if (this.mViewGetParentMethod == null) {
                Class<?> viewClass = Class.forName("android.view.View");
                this.mViewGetParentMethod = viewClass.getMethod("getParent", new Class[0]);
            }
            return Result.Status.SUCCESS.createResult(this.mViewGetParentMethod.invoke(viewObject, new Object[0]));
        }
        catch (Exception e) {
            return Result.Status.ERROR_REFLECTION.createResult(null, (Throwable)e);
        }
    }

    private void addExtendedViewInfo(@NotNull ViewInfo info) {
        this.computeExtendedViewInfo(info);
        List children = info.getChildren();
        for (ViewInfo child : children) {
            this.addExtendedViewInfo(child);
        }
    }

    private void computeExtendedViewInfo(@NotNull ViewInfo info) {
        Object viewObject = info.getViewObject();
        Object params = info.getLayoutParamsObject();
        int baseLine = this.getViewBaselineReflection(viewObject);
        int leftMargin = 0;
        int topMargin = 0;
        int rightMargin = 0;
        int bottomMargin = 0;
        try {
            if (this.mMarginLayoutParamClass == null) {
                this.mMarginLayoutParamClass = Class.forName("android.view.ViewGroup$MarginLayoutParams");
                this.mLeftMarginField = this.mMarginLayoutParamClass.getField("leftMargin");
                this.mTopMarginField = this.mMarginLayoutParamClass.getField("topMargin");
                this.mRightMarginField = this.mMarginLayoutParamClass.getField("rightMargin");
                this.mBottomMarginField = this.mMarginLayoutParamClass.getField("bottomMargin");
            }
            if (this.mMarginLayoutParamClass.isAssignableFrom(params.getClass())) {
                leftMargin = (Integer)this.mLeftMarginField.get(params);
                topMargin = (Integer)this.mTopMarginField.get(params);
                rightMargin = (Integer)this.mRightMarginField.get(params);
                bottomMargin = (Integer)this.mBottomMarginField.get(params);
            }
        }
        catch (Exception e) {
            leftMargin = Integer.MIN_VALUE;
            topMargin = Integer.MIN_VALUE;
            rightMargin = Integer.MIN_VALUE;
            bottomMargin = Integer.MIN_VALUE;
        }
        info.setExtendedInfo(baseLine, leftMargin, topMargin, rightMargin, bottomMargin);
    }

    private int getViewBaselineReflection(Object viewObject) {
        try {
            Object result;
            if (this.mViewGetBaselineMethod == null) {
                Class<?> viewClass = Class.forName("android.view.View");
                this.mViewGetBaselineMethod = viewClass.getMethod("getBaseline", new Class[0]);
            }
            if ((result = this.mViewGetBaselineMethod.invoke(viewObject, new Object[0])) instanceof Integer) {
                return (Integer)result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.MIN_VALUE;
    }

    protected LayoutLibrary() {
        this.mBridge = null;
        this.mClassLoader = null;
    }
}

