/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import android.os._Original_Build;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.commons.ClassRemapper;
import org.jetbrains.org.objectweb.asm.commons.Remapper;

public class LayoutlibClassLoader
extends ClassLoader {
    private static Logger LOG = Logger.getInstance(LayoutlibClassLoader.class);

    LayoutlibClassLoader(@NotNull ClassLoader parent) {
        super(parent);
        LayoutlibClassLoader.generate(_Original_Build.class, (className, classBytes) -> this.defineClass((String)className, (byte[])classBytes, 0, ((byte[])classBytes).length));
    }

    @NotNull
    private static String toBinaryClassName(@NotNull String name) {
        return name.replace('.', '/');
    }

    @NotNull
    private static String toClassName(@NotNull String name) {
        return name.replace('/', '.');
    }

    @VisibleForTesting
    static void generate(@NotNull Class<?> originalBuildClass, @NotNull BiConsumer<String, byte[]> defineClass) {
        ClassLoader loader = originalBuildClass.getClassLoader();
        String originalBuildClassName = originalBuildClass.getName();
        final String originalBuildBinaryClassName = LayoutlibClassLoader.toBinaryClassName(originalBuildClassName);
        final LinkedList<String> pendingClasses = new LinkedList<String>();
        pendingClasses.push(originalBuildClassName);
        Remapper remapper = new Remapper(){

            public String map(String typeName) {
                if (typeName.startsWith(originalBuildBinaryClassName)) {
                    return "android/os/Build" + StringUtil.trimStart((String)typeName, (String)originalBuildBinaryClassName);
                }
                return typeName;
            }
        };
        while (!pendingClasses.isEmpty()) {
            String name = (String)pendingClasses.pop();
            String newName = "android.os.Build" + StringUtil.trimStart((String)name, (String)originalBuildClassName);
            final String binaryName = LayoutlibClassLoader.toBinaryClassName(name);
            try {
                InputStream is = loader.getResourceAsStream(binaryName + ".class");
                Throwable throwable = null;
                try {
                    ClassWriter writer = new ClassWriter(0);
                    ClassReader reader = new ClassReader(is);
                    ClassRemapper classRemapper = new ClassRemapper((ClassVisitor)writer, remapper){

                        public void visitInnerClass(String name, String outerName, String innerName, int access) {
                            if (outerName.startsWith(binaryName)) {
                                pendingClasses.push(LayoutlibClassLoader.toClassName(name));
                            }
                            super.visitInnerClass(name, outerName, innerName, access);
                        }
                    };
                    reader.accept((ClassVisitor)classRemapper, 0);
                    defineClass.accept(newName, writer.toByteArray());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to define android.os.Build", (Throwable)e);
            }
        }
    }
}

