/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.model;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dependency.NativeDependencyResolveResult;
import com.android.build.gradle.internal.dependency.NativeLibraryArtifact;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.model.NativeLibraryImpl;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.managed.NdkAbiOptions;
import com.android.build.gradle.managed.NdkConfig;
import com.android.build.gradle.managed.NdkOptions;
import com.android.build.gradle.model.AndroidBinary;
import com.android.build.gradle.model.internal.AndroidBinaryInternal;
import com.android.build.gradle.ndk.internal.NativeCompilerArgsUtil;
import com.android.builder.model.NativeLibrary;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.model.ModelMap;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.NativeLibraryBinarySpec;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.StaticLibraryBinary;

public class ComponentNativeLibraryFactory
implements NativeLibraryFactory {
    ModelMap<AndroidBinaryInternal> binaries;
    NdkHandler ndkHandler;
    ModelMap<NdkAbiOptions> abiOptions;
    Multimap<String, NativeDependencyResolveResult> nativeDependencies;
    Multimap<String, NativeDependencyResolveResult> jniLibsDependencies;

    public ComponentNativeLibraryFactory(ModelMap<AndroidBinaryInternal> binaries, NdkHandler ndkHandler, ModelMap<NdkAbiOptions> abiOptions, Multimap<String, NativeDependencyResolveResult> nativeDependencies, Multimap<String, NativeDependencyResolveResult> jniLibsDependencies) {
        this.binaries = binaries;
        this.ndkHandler = ndkHandler;
        this.abiOptions = abiOptions;
        this.nativeDependencies = nativeDependencies;
        this.jniLibsDependencies = jniLibsDependencies;
    }

    public Optional<NativeLibrary> create(VariantScope scope, String toolchainName, Abi abi) {
        BaseVariantData variantData = scope.getVariantData();
        AndroidBinaryInternal androidBinary = (AndroidBinaryInternal)this.binaries.get("android" + StringHelper.capitalize((String)variantData.getName()));
        if (androidBinary == null) {
            return Optional.empty();
        }
        Optional<NativeLibraryBinarySpec> nativeBinary = androidBinary.getNativeBinaries().stream().filter(binary -> binary.getTargetPlatform().getName().equals(abi.getName())).findFirst();
        if (!nativeBinary.isPresent()) {
            return Optional.of(new NativeLibraryImpl(abi.getName(), toolchainName, abi.getName(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), this.findDebuggableLibraryDirectories((BaseVariantData<? extends BaseVariantOutputData>)variantData, androidBinary, abi)));
        }
        NdkOptions targetOptions = (NdkOptions)this.abiOptions.get(abi.getName());
        Iterable cFlags = nativeBinary.get().getcCompiler().getArgs();
        Iterable cppFlags = nativeBinary.get().getCppCompiler().getArgs();
        if (targetOptions != null) {
            if (!targetOptions.getCFlags().isEmpty()) {
                cFlags = Iterables.concat((Iterable)cFlags, targetOptions.getCFlags());
            }
            if (!targetOptions.getCppFlags().isEmpty()) {
                cppFlags = Iterables.concat((Iterable)cppFlags, targetOptions.getCppFlags());
            }
        }
        List<File> debuggableLibDir = this.findDebuggableLibraryDirectories((BaseVariantData<? extends BaseVariantOutputData>)variantData, androidBinary, abi);
        NdkConfig ndkConfig = androidBinary.getMergedNdkConfig();
        return Optional.of(new NativeLibraryImpl(ndkConfig.getModuleName(), toolchainName, abi.getName(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), this.ndkHandler.getStlNativeToolSpecification(Stl.getById((String)ndkConfig.getStl()), ndkConfig.getStlVersion(), abi).getIncludes(), Collections.emptyList(), Collections.emptyList(), NativeCompilerArgsUtil.transform((Iterable)cFlags), NativeCompilerArgsUtil.transform((Iterable)cppFlags), debuggableLibDir));
    }

    private List<File> findDebuggableLibraryDirectories(BaseVariantData<? extends BaseVariantOutputData> variantData, AndroidBinaryInternal binary, Abi abi) {
        LinkedHashSet debuggableLibDir = Sets.newLinkedHashSet();
        debuggableLibDir.add(variantData.getScope().getNdkDebuggableLibraryFolders(abi));
        ComponentNativeLibraryFactory.addNativeDebuggableLib(debuggableLibDir, binary, abi, this.nativeDependencies);
        ComponentNativeLibraryFactory.addJniLibsDebuggableLib(debuggableLibDir, binary, abi, this.jniLibsDependencies);
        return ImmutableList.copyOf((Collection)debuggableLibDir);
    }

    private static void addNativeDebuggableLib(Collection<File> debuggableLibDir, AndroidBinaryInternal binary, Abi abi, Multimap<String, NativeDependencyResolveResult> dependencyMap) {
        Optional<NativeLibraryBinarySpec> nativeBinary = binary.getNativeBinaries().stream().filter(candidateBinary -> candidateBinary.getTargetPlatform().getName().equals(abi.getName())).findFirst();
        if (nativeBinary.isPresent()) {
            ComponentNativeLibraryFactory.addDebuggableLib(debuggableLibDir, binary, abi, dependencyMap.get((Object)nativeBinary.get().getName()));
        }
    }

    private static void addJniLibsDebuggableLib(Collection<File> debuggableLibDir, AndroidBinary binary, Abi abi, Multimap<String, NativeDependencyResolveResult> dependencyMap) {
        ComponentNativeLibraryFactory.addDebuggableLib(debuggableLibDir, binary, abi, dependencyMap.get((Object)binary.getName()));
    }

    private static void addDebuggableLib(Collection<File> debuggableLibDir, AndroidBinary binary, Abi abi, Iterable<NativeDependencyResolveResult> dependencies) {
        for (NativeDependencyResolveResult dependency : dependencies) {
            for (NativeLibraryArtifact artifact : dependency.getNativeArtifacts()) {
                debuggableLibDir.addAll(artifact.getLibraries().stream().map(File::getParentFile).collect(Collectors.toList()));
            }
            for (NativeLibraryBinary nativeBinary : dependency.getPrebuiltLibraries()) {
                File output;
                if (!nativeBinary.getTargetPlatform().getName().equals(abi.getName()) || (output = nativeBinary instanceof SharedLibraryBinary ? ((SharedLibraryBinary)nativeBinary).getSharedLibraryFile() : ((StaticLibraryBinary)nativeBinary).getStaticLibraryFile()) == null) continue;
                debuggableLibDir.add(output.getParentFile());
            }
        }
    }
}

