/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.build.gradle.internal.core.Toolchain;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.managed.NdkConfig;
import com.google.common.primitives.Ints;
import org.gradle.api.InvalidUserDataException;

public class NdkExtensionConvention {
    public static void setExtensionDefault(NdkConfig ndkConfig) {
        if (ndkConfig.getToolchain().isEmpty()) {
            ndkConfig.setToolchain(Toolchain.getDefault().getName());
        } else if (!ndkConfig.getToolchain().equals("gcc") && !ndkConfig.getToolchain().equals("clang")) {
            throw new InvalidUserDataException(String.format("Invalid toolchain '%s'.  Supported toolchains are 'gcc' and 'clang'.", ndkConfig.getToolchain()));
        }
        if (ndkConfig.getStl().isEmpty()) {
            ndkConfig.setStl(Stl.DEFAULT.getId());
        } else {
            Stl.getById((String)ndkConfig.getStl());
        }
        if (ndkConfig.getPlatformVersion() != null && !ndkConfig.getPlatformVersion().startsWith("android-") && Ints.tryParse((String)ndkConfig.getPlatformVersion()) != null) {
            ndkConfig.setPlatformVersion("android-" + ndkConfig.getPlatformVersion());
        }
    }
}

