/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.QualifiedRecommendation;
import com.google.archivepatcher.generator.Recommendation;
import com.google.archivepatcher.generator.RecommendationModifier;
import com.google.archivepatcher.generator.RecommendationReason;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DeltaFriendlyOldBlobSizeLimiter
implements RecommendationModifier {
    private final long maxSizeBytes;
    private static final Comparator<QualifiedRecommendation> COMPARATOR = new UncompressedOldEntrySizeComparator();

    public DeltaFriendlyOldBlobSizeLimiter(long maxSizeBytes) {
        if (maxSizeBytes < 0L) {
            throw new IllegalArgumentException("maxSizeBytes must be non-negative: " + maxSizeBytes);
        }
        this.maxSizeBytes = maxSizeBytes;
    }

    @Override
    public List<QualifiedRecommendation> getModifiedRecommendations(File oldFile, File newFile, List<QualifiedRecommendation> originalRecommendations) {
        List<QualifiedRecommendation> sorted = DeltaFriendlyOldBlobSizeLimiter.sortRecommendations(originalRecommendations);
        ArrayList<QualifiedRecommendation> result = new ArrayList<QualifiedRecommendation>(sorted.size());
        long bytesRemaining = this.maxSizeBytes - oldFile.length();
        for (QualifiedRecommendation originalRecommendation : sorted) {
            if (!originalRecommendation.getRecommendation().uncompressOldEntry) {
                result.add(originalRecommendation);
                continue;
            }
            long extraBytesConsumed = originalRecommendation.getOldEntry().getUncompressedSize() - originalRecommendation.getOldEntry().getCompressedSize();
            if (bytesRemaining - extraBytesConsumed >= 0L) {
                result.add(originalRecommendation);
                bytesRemaining -= extraBytesConsumed;
                continue;
            }
            result.add(new QualifiedRecommendation(originalRecommendation.getOldEntry(), originalRecommendation.getNewEntry(), Recommendation.UNCOMPRESS_NEITHER, RecommendationReason.RESOURCE_CONSTRAINED));
        }
        return result;
    }

    private static List<QualifiedRecommendation> sortRecommendations(List<QualifiedRecommendation> originalRecommendations) {
        ArrayList<QualifiedRecommendation> sorted = new ArrayList<QualifiedRecommendation>(originalRecommendations);
        Collections.sort(sorted, COMPARATOR);
        Collections.reverse(sorted);
        return sorted;
    }

    private static class UncompressedOldEntrySizeComparator
    implements Comparator<QualifiedRecommendation> {
        private UncompressedOldEntrySizeComparator() {
        }

        @Override
        public int compare(QualifiedRecommendation qr1, QualifiedRecommendation qr2) {
            return Long.compare(qr1.getOldEntry().getUncompressedSize(), qr2.getOldEntry().getUncompressedSize());
        }
    }
}

