/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator.bsdiff;

import com.google.archivepatcher.generator.bsdiff.RandomAccessObject;
import java.io.File;
import java.io.IOException;

public interface RandomAccessObjectFactory {
    public RandomAccessObject create(int var1) throws IOException;

    public static final class RandomAccessMmapObjectFactory
    implements RandomAccessObjectFactory {
        private static final String FILE_NAME_PREFIX = "wavsprafof";
        private String mMode;

        public RandomAccessMmapObjectFactory(String mode) {
            this.mMode = mode;
        }

        @Override
        public RandomAccessObject create(int size) throws IOException {
            return new RandomAccessObject.RandomAccessMmapObject(FILE_NAME_PREFIX, this.mMode, size);
        }
    }

    public static final class RandomAccessByteArrayObjectFactory
    implements RandomAccessObjectFactory {
        @Override
        public RandomAccessObject create(int size) {
            return new RandomAccessObject.RandomAccessByteArrayObject(size);
        }
    }

    public static final class RandomAccessFileObjectFactory
    implements RandomAccessObjectFactory {
        private static final String FILE_NAME_PREFIX = "wavsprafof";
        private final String mMode;

        public RandomAccessFileObjectFactory(String mode) {
            this.mMode = mode;
        }

        @Override
        public RandomAccessObject create(int size) throws IOException {
            return new RandomAccessObject.RandomAccessFileObject(File.createTempFile(FILE_NAME_PREFIX, "temp"), this.mMode, true);
        }
    }
}

