/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.execution.junit2.info.LocationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class AbstractAllInDirectoryConfigurationProducer
extends JUnitConfigurationProducer {
    protected AbstractAllInDirectoryConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected boolean setupConfigurationFromContext(JUnitConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Project project = configuration.getProject();
        PsiElement element = context.getPsiLocation();
        if (!(element instanceof PsiDirectory)) {
            return false;
        }
        PsiPackage aPackage = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)element);
        if (aPackage == null) {
            return false;
        }
        VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return false;
        }
        if (!ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(virtualFile)) {
            return false;
        }
        int testRootCount = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE).size();
        if (testRootCount < 2) {
            return false;
        }
        if (!LocationUtil.isJarAttached((Location)context.getLocation(), (PsiPackage)aPackage, (String[])new String[]{"junit.framework.TestCase"})) {
            return false;
        }
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        JUnitConfiguration.Data data = configuration.getPersistentData();
        data.setDirName(virtualFile.getPath());
        data.TEST_OBJECT = "directory";
        configuration.setGeneratedName();
        return true;
    }
}

