/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.Location;
import com.intellij.execution.junit.JUnitExternalLibraryDescriptor;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit3Framework
extends JavaTestFramework {
    @NotNull
    public String getName() {
        return "JUnit3";
    }

    public char getMnemonic() {
        return '3';
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit3 Test Class.java");
    }

    public boolean isSingleConfig() {
        return true;
    }

    public boolean isTestMethod(PsiMethod method, PsiClass myClass) {
        return JUnitUtil.isTestMethod((Location)MethodLocation.elementInClass((PsiMethod)method, (PsiClass)myClass));
    }

    @NotNull
    public Icon getIcon() {
        return AllIcons.RunConfigurations.Junit;
    }

    protected String getMarkerClassFQName() {
        return "junit.framework.TestCase";
    }

    @Nullable
    public ExternalLibraryDescriptor getFrameworkLibraryDescriptor() {
        return JUnitExternalLibraryDescriptor.JUNIT3;
    }

    @Nullable
    public String getDefaultSuperClass() {
        return "junit.framework.TestCase";
    }

    public boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        if (JUnitUtil.isJUnit3TestClass((PsiClass)clazz)) {
            return true;
        }
        return JUnitUtil.findSuiteMethod((PsiClass)clazz) != null;
    }

    @Nullable
    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (!JUnitUtil.isJUnit3TestClass((PsiClass)clazz)) {
            return null;
        }
        for (PsiMethod each : clazz.getMethods()) {
            if (!each.getName().equals("setUp")) continue;
            return each;
        }
        return null;
    }

    @Nullable
    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (!JUnitUtil.isJUnit3TestClass((PsiClass)clazz)) {
            return null;
        }
        for (PsiMethod each : clazz.getMethods()) {
            if (!each.getName().equals("tearDown")) continue;
            return each;
        }
        return null;
    }

    @Nullable
    protected PsiMethod findOrCreateSetUpMethod(PsiClass clazz) throws IncorrectOperationException {
        PsiMethod inClass;
        PsiMethod baseMethod;
        PsiManager manager = clazz.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiMethod patternMethod = this.createSetUpPatternMethod((JVMElementFactory)factory);
        PsiClass baseClass = clazz.getSuperClass();
        if (baseClass != null && (baseMethod = baseClass.findMethodBySignature(patternMethod, false)) != null && baseMethod.hasModifierProperty("public")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)patternMethod, (String)"protected", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)patternMethod, (String)"public", (boolean)true);
        }
        if ((inClass = clazz.findMethodBySignature(patternMethod, false)) == null) {
            PsiMethod testMethod = JUnitUtil.findFirstTestMethod((PsiClass)clazz);
            if (testMethod != null) {
                return (PsiMethod)clazz.addBefore((PsiElement)patternMethod, (PsiElement)testMethod);
            }
            return (PsiMethod)clazz.add((PsiElement)patternMethod);
        }
        if (inClass.getBody() == null) {
            return (PsiMethod)inClass.replace((PsiElement)patternMethod);
        }
        return inClass;
    }

    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit3 SetUp Method.java");
    }

    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit3 TearDown Method.java");
    }

    @NotNull
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit3 Test Method.java");
    }

    public boolean isTestMethod(PsiElement element) {
        return element instanceof PsiMethod && JUnitUtil.getTestMethod((PsiElement)element) != null;
    }
}

