/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryDependencyScopeSuggester;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitDependencyScopeSuggester
extends LibraryDependencyScopeSuggester {
    private static final String[] JUNIT_JAR_MARKERS = new String[]{"org.junit.Test", "junit.framework.TestCase", "org.hamcrest.Matcher", "org.hamcrest.Matchers"};

    @Nullable
    public DependencyScope getDefaultDependencyScope(@NotNull Library library) {
        VirtualFile[] files = library.getFiles(OrderRootType.CLASSES);
        if (files.length == 0) {
            return null;
        }
        for (VirtualFile file : files) {
            if (JUnitDependencyScopeSuggester.isTestJarRoot(file)) continue;
            return null;
        }
        return DependencyScope.TEST;
    }

    private static boolean isTestJarRoot(VirtualFile file) {
        for (String marker : JUNIT_JAR_MARKERS) {
            if (!LibraryUtil.isClassAvailableInLibrary(Collections.singletonList(file), (String)marker)) continue;
            return true;
        }
        return false;
    }
}

