/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.util.PathUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JUnitExternalLibraryDescriptor
extends ExternalLibraryDescriptor {
    public static final ExternalLibraryDescriptor JUNIT3 = new JUnitExternalLibraryDescriptor("3"){

        @NotNull
        public List<String> getLibraryClassesRoots() {
            return Collections.singletonList(JavaSdkUtil.getJunit3JarPath());
        }
    };
    public static final ExternalLibraryDescriptor JUNIT4 = new JUnitExternalLibraryDescriptor("4"){

        @NotNull
        public List<String> getLibraryClassesRoots() {
            return JavaSdkUtil.getJUnit4JarPaths();
        }
    };
    public static final ExternalLibraryDescriptor JUNIT5 = new JUnitExternalLibraryDescriptor("org.junit.jupiter", "junit-jupiter-api", "5"){

        @NotNull
        public List<String> getLibraryClassesRoots() {
            try {
                return Arrays.asList(PathUtil.getJarPathForClass(Class.forName("org.junit.jupiter.api.Test")), PathUtil.getJarPathForClass(Class.forName("org.opentest4j.AssertionFailedError")));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final String myVersion;

    private JUnitExternalLibraryDescriptor(String version) {
        this("junit", "junit", version);
    }

    private JUnitExternalLibraryDescriptor(String groupId, String artifactId, String version) {
        super(groupId, artifactId, version + ".0", version + ".999");
        this.myVersion = version;
    }

    public String getPresentableName() {
        return "JUnit" + this.myVersion;
    }
}

