/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;

public class MessageUtil {
    private MessageUtil() {
    }

    @Nullable
    public static CompilerMessageLocation psiElementToMessageLocation(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        return MessageUtil.psiFileToMessageLocation(file2, "<no path>", DiagnosticUtils.getLineAndColumnInPsiFile(file2, element.getTextRange()));
    }

    @Nullable
    public static CompilerMessageLocation psiFileToMessageLocation(@NotNull PsiFile file2, @Nullable String defaultValue, @NotNull DiagnosticUtils.LineAndColumn lineAndColumn) {
        String path;
        VirtualFile virtualFile;
        if (file2 == null) {
            MessageUtil.$$$reportNull$$$0(0);
        }
        if (lineAndColumn == null) {
            MessageUtil.$$$reportNull$$$0(1);
        }
        if ((virtualFile = file2.getVirtualFile()) == null) {
            path = defaultValue;
        } else {
            path = virtualFile.getPath();
            if (virtualFile instanceof CoreLocalVirtualFile || virtualFile instanceof CoreJarVirtualFile) {
                path = FileUtil.toSystemDependentName(path);
            }
        }
        return CompilerMessageLocation.create(path, lineAndColumn.getLine(), lineAndColumn.getColumn(), lineAndColumn.getLineContent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "lineAndColumn";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/cli/common/messages/MessageUtil";
        objectArray[2] = "psiFileToMessageLocation";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

