/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.FactoryMap;

public abstract class ConcurrentFactoryMap<T, V>
extends FactoryMap<T, V> {
    @Override
    protected Map<T, V> createMap() {
        return ContainerUtil.newConcurrentMap();
    }

    @NotNull
    public static <T, V> ConcurrentFactoryMap<T, V> createConcurrentMap(final @NotNull Function<T, V> computeValue) {
        if (computeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computeValue", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentFactoryMap", "createConcurrentMap"));
        }
        ConcurrentFactoryMap concurrentFactoryMap = new ConcurrentFactoryMap<T, V>(){

            @Override
            @Nullable
            protected V create(T key) {
                return computeValue.fun(key);
            }
        };
        if (concurrentFactoryMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentFactoryMap", "createConcurrentMap"));
        }
        return concurrentFactoryMap;
    }
}

