/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.graph.GraphGenerator;
import org.jetbrains.kotlin.com.intellij.util.graph.InboundSemiGraph;

public class CachingSemiGraph<Node>
implements GraphGenerator.SemiGraph<Node> {
    private final Set<Node> myNodes;
    private final Map<Node, Set<Node>> myIn;

    public static <T> InboundSemiGraph<T> cache(InboundSemiGraph<T> original) {
        return new CachingSemiGraph<T>(original);
    }

    private CachingSemiGraph(InboundSemiGraph<Node> original) {
        this.myNodes = ContainerUtil.newLinkedHashSet(original.getNodes());
        this.myIn = new LinkedHashMap<Node, Set<Node>>();
        for (Node node : this.myNodes) {
            LinkedHashSet value = new LinkedHashSet();
            ContainerUtil.addAll(value, original.getIn(node));
            this.myIn.put(node, value);
        }
    }

    @Override
    public Collection<Node> getNodes() {
        return this.myNodes;
    }

    @Override
    public Iterator<Node> getIn(Node n) {
        return this.myIn.get(n).iterator();
    }
}

