/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.util.Objects;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestSource;

@API(value=API.Usage.Experimental)
public class PackageSource
implements TestSource {
    private static final long serialVersionUID = 1L;
    private final String packageName;

    public PackageSource(Package javaPackage) {
        this(((Package)Preconditions.notNull((Object)javaPackage, (String)"package must not be null")).getName());
    }

    public PackageSource(String packageName) {
        this.packageName = Preconditions.notBlank((String)packageName, (String)"package name must not be null or blank");
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageSource that = (PackageSource)o;
        return Objects.equals(this.packageName, that.packageName);
    }

    public int hashCode() {
        return this.packageName.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("packageName", (Object)this.packageName).toString();
    }
}

