/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLLanguage;

public class YAMLLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings((Language)YAMLLanguage.INSTANCE);
        CommonCodeStyleSettings.IndentOptions indentOptions = defaultSettings.initIndentOptions();
        indentOptions.INDENT_SIZE = 2;
        indentOptions.USE_TAB_CHARACTER = false;
        return defaultSettings;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new YAMLIndentOptionsEditor();
    }

    @NotNull
    public Language getLanguage() {
        return YAMLLanguage.INSTANCE;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        return "product: \n  name: RubyMine\n  version: 8\n  vendor: JetBrains\n  url: \"https://www.jetbrains.com/ruby\"";
    }

    private class YAMLIndentOptionsEditor
    extends IndentOptionsEditor {
        private YAMLIndentOptionsEditor() {
        }

        protected void addComponents() {
            this.addTabOptions();
            this.myCbUseTab.setEnabled(false);
            this.myTabSizeField = this.createIndentTextField();
            this.myTabSizeLabel = new JLabel(ApplicationBundle.message((String)"editbox.indent.tab.size", (Object[])new Object[0]));
            this.myIndentField = this.createIndentTextField();
            this.myIndentLabel = new JLabel(ApplicationBundle.message((String)"editbox.indent.indent", (Object[])new Object[0]));
            this.add(this.myIndentLabel, this.myIndentField);
        }

        public void setEnabled(boolean enabled) {
        }
    }
}

