/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

public class YAMLBreadcrumbsInfoProvider
extends BreadcrumbsInfoProvider {
    private static final Language[] LANGUAGES = new Language[]{YAMLLanguage.INSTANCE};
    private static final int SCALAR_MAX_LENGTH = 20;

    public Language[] getLanguages() {
        return LANGUAGES;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        return e instanceof YAMLScalar || e instanceof YAMLKeyValue || e instanceof YAMLSequenceItem || e instanceof YAMLDocument;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        if (e instanceof YAMLDocument) {
            YAMLFile file = (YAMLFile)e.getContainingFile();
            if (file == null) {
                return "Document";
            }
            List<YAMLDocument> documents = file.getDocuments();
            return "Document " + YAMLBreadcrumbsInfoProvider.getIndexOf(documents, e);
        }
        if (e instanceof YAMLKeyValue) {
            return ((YAMLKeyValue)e).getKeyText() + ':';
        }
        if (e instanceof YAMLSequenceItem) {
            PsiElement parent = e.getParent();
            if (!(parent instanceof YAMLSequence)) {
                return "Item";
            }
            List<YAMLSequenceItem> items = ((YAMLSequence)parent).getItems();
            return "Item " + YAMLBreadcrumbsInfoProvider.getIndexOf(items, e);
        }
        if (e instanceof YAMLScalar) {
            return StringUtil.first((String)((YAMLScalar)e).getTextValue(), (int)20, (boolean)true);
        }
        throw new IllegalArgumentException("This element should not pass #acceptElement");
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        return null;
    }

    @NotNull
    private static String getIndexOf(@NotNull List<?> list, Object o) {
        return String.valueOf(1 + list.indexOf(o)) + '/' + list.size();
    }
}

