/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public abstract class YAMLBlockScalarImpl
extends YAMLScalarImpl {
    protected static final int DEFAULT_CONTENT_INDENT = 2;

    public YAMLBlockScalarImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    protected abstract IElementType getContentType();

    @Override
    public boolean isMultiline() {
        return true;
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        int lastNonEmpty;
        ASTNode firstContentChild = this.getFirstContentNode();
        if (firstContentChild == null) {
            return Collections.emptyList();
        }
        int myStart = this.getTextRange().getStartOffset();
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        int indent = this.locateIndent();
        ASTNode firstEol = TreeUtil.findSibling((ASTNode)firstContentChild, (IElementType)YAMLTokenTypes.EOL);
        if (firstEol == null) {
            return Collections.emptyList();
        }
        int thisLineStart = firstEol.getStartOffset() + 1;
        for (ASTNode child = firstEol.getTreeNext(); child != null; child = child.getTreeNext()) {
            IElementType childType = child.getElementType();
            TextRange childRange = child.getTextRange();
            if (childType == YAMLTokenTypes.INDENT && YAMLBlockScalarImpl.isEol(child.getTreePrev())) {
                thisLineStart = child.getStartOffset() + Math.min(indent, child.getTextLength());
                continue;
            }
            if (childType == YAMLTokenTypes.EOL) {
                if (thisLineStart != -1) {
                    result.add(TextRange.create((int)thisLineStart, (int)child.getStartOffset()).shiftRight(-myStart));
                }
                thisLineStart = child.getStartOffset() + 1;
                continue;
            }
            if (!YAMLBlockScalarImpl.isEol(child.getTreeNext())) continue;
            if (thisLineStart == -1) {
                Logger.getInstance(YAMLBlockScalarImpl.class).warn("thisLineStart == -1: '" + this.getText() + "'", new Throwable());
                continue;
            }
            result.add(TextRange.create((int)thisLineStart, (int)childRange.getEndOffset()).shiftRight(-myStart));
            thisLineStart = -1;
        }
        if (thisLineStart != -1 && thisLineStart != this.getTextRange().getEndOffset()) {
            result.add(TextRange.create((int)thisLineStart, (int)this.getTextRange().getEndOffset()).shiftRight(-myStart));
        }
        return (lastNonEmpty = ContainerUtil.lastIndexOf(result, range -> range.getLength() != 0)) == -1 ? result : result.subList(0, lastNonEmpty + 1);
    }

    protected int locateIndent() {
        int number = 0;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != this.getContentType() || ++number != 2) continue;
            return YAMLUtil.getIndentInThisLine(child.getPsi());
        }
        return 0;
    }

    private static boolean isEol(@Nullable ASTNode node) {
        return node != null && node.getElementType() == YAMLTokenTypes.EOL;
    }
}

