/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public class YAMLQuotedTextImpl
extends YAMLScalarImpl
implements YAMLQuotedText {
    private final boolean myIsSingleQuoted;

    public YAMLQuotedTextImpl(@NotNull ASTNode node) {
        super(node);
        ASTNode firstContentNode = this.getFirstContentNode();
        this.myIsSingleQuoted = firstContentNode != null && firstContentNode.getElementType() == YAMLTokenTypes.SCALAR_STRING;
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        ASTNode firstContentNode = this.getFirstContentNode();
        if (firstContentNode == null) {
            return Collections.emptyList();
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        TextRange contentRange = TextRange.create((int)firstContentNode.getStartOffset(), (int)this.getTextRange().getEndOffset()).shiftRight(-this.getTextRange().getStartOffset());
        List lines = StringUtil.split((String)contentRange.substring(this.getText()), (String)"\n", (boolean)true, (boolean)false);
        int cumulativeOffset = contentRange.getStartOffset();
        for (int i = 0; i < lines.size(); ++i) {
            int lineStart;
            String line = (String)lines.get(i);
            int lineEnd = line.length();
            if (i == 0) {
                ++lineStart;
            } else {
                for (lineStart = 0; lineStart < line.length() && YAMLGrammarCharUtil.isSpaceLike(line.charAt(lineStart)); ++lineStart) {
                }
            }
            if (i == lines.size() - 1) {
                --lineEnd;
            } else {
                while (lineEnd > lineStart && YAMLGrammarCharUtil.isSpaceLike(line.charAt(lineEnd - 1))) {
                    --lineEnd;
                }
            }
            result.add(TextRange.create((int)lineStart, (int)lineEnd).shiftRight(cumulativeOffset));
            cumulativeOffset += line.length() + 1;
        }
        return result;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges, int indexBefore) {
        TextRange leftRange = contentRanges.get(indexBefore);
        if (leftRange.isEmpty() || !this.isSingleQuote() && text.charAt(leftRange.getEndOffset() - 1) == '\\') {
            return "\n";
        }
        if (contentRanges.get(indexBefore + 1).isEmpty()) {
            return "";
        }
        return " ";
    }

    @Override
    protected List<Pair<TextRange, String>> getDecodeReplacements(@NotNull CharSequence input) {
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int i = 0;
        while (i + 1 < input.length()) {
            if (this.isSingleQuote() && input.charAt(i) == '\'' && input.charAt(i + 1) == '\'') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)2), (Object)"'"));
                ++i;
            } else if (!this.isSingleQuote() && input.charAt(i) == '\\') {
                if (input.charAt(i + 1) == '\n') {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)2), (Object)""));
                    ++i;
                } else {
                    int length = Escaper.findEscapementLength(input, i);
                    int charCode = Escaper.toUnicodeChar(input, i, length);
                    TextRange range = TextRange.create((int)i, (int)Math.min(i + length + 1, input.length()));
                    result.add((Pair<TextRange, String>)Pair.create((Object)range, (Object)Character.toString((char)charCode)));
                    i += range.getLength() - 1;
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        if (this.isSingleQuote()) {
            for (int i = 0; i < input.length(); ++i) {
                if (input.charAt(i) != '\n' || YAMLQuotedTextImpl.isSurroundedByNoSpace(input, i)) continue;
                throw new IllegalArgumentException("Newlines with spaces around are not convertible");
            }
        }
        int indent = YAMLUtil.getIndentToThisElement((PsiElement)this);
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int currentLength = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\n') {
                if (!this.isSingleQuote() && i + 1 < input.length() && YAMLGrammarCharUtil.isSpaceLike(input.charAt(i + 1))) {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\\n\\\n" + indentString + "\\")));
                } else if (!this.isSingleQuote() && i + 1 < input.length() && input.charAt(i + 1) == '\n') {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\\\n" + indentString + "\\n")));
                } else {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n\n" + indentString)));
                }
                currentLength = 0;
                continue;
            }
            if (currentLength > 60 && (!this.isSingleQuote() || c == ' ' && YAMLQuotedTextImpl.isSurroundedByNoSpace(input, i))) {
                String replacement = this.isSingleQuote() ? "\n" + indentString : (YAMLGrammarCharUtil.isSpaceLike(c) ? "\\\n" + indentString + "\\" : "\\\n" + indentString);
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)(this.isSingleQuote() ? 1 : 0)), (Object)replacement));
                currentLength = 0;
            }
            ++currentLength;
            if (this.isSingleQuote() && c == '\'') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)"''"));
                continue;
            }
            if (this.isSingleQuote()) continue;
            if (c == '\"') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)"\\\""));
                continue;
            }
            if (c != '\\') continue;
            result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)"\\\\"));
        }
        return result;
    }

    @Override
    public boolean isMultiline() {
        return this.textContains('\n');
    }

    @Override
    public boolean isSingleQuote() {
        return this.myIsSingleQuoted;
    }

    @Override
    public String toString() {
        return "YAML quoted text";
    }

    private static class Escaper {
        private static final int[][] ONE_LETTER_CONVERSIONS = new int[][]{{48, 0}, {97, 7}, {98, 8}, {116, 9}, {9, 9}, {110, 10}, {118, 11}, {102, 12}, {114, 13}, {101, 27}, {32, 32}, {34, 34}, {47, 47}, {92, 92}, {78, 133}, {95, 160}, {76, 8232}, {80, 8233}};
        private static final NotNullLazyValue<Map<Integer, Integer>> ESC_TO_CODE = new NotNullLazyValue<Map<Integer, Integer>>(){

            @NotNull
            protected Map<Integer, Integer> compute() {
                HashMap map = new HashMap(ONE_LETTER_CONVERSIONS.length);
                for (int[] conversion : ONE_LETTER_CONVERSIONS) {
                    map.put((Object)conversion[0], (Object)conversion[1]);
                }
                return map;
            }
        };
        private static final NotNullLazyValue<Map<Integer, Integer>> CODE_TO_ESC = new NotNullLazyValue<Map<Integer, Integer>>(){

            @NotNull
            protected Map<Integer, Integer> compute() {
                HashMap map = new HashMap(ONE_LETTER_CONVERSIONS.length);
                for (int[] conversion : ONE_LETTER_CONVERSIONS) {
                    map.put((Object)conversion[1], (Object)conversion[2]);
                }
                return map;
            }
        };

        private Escaper() {
        }

        static int findEscapementLength(@NotNull CharSequence text, int pos) {
            if (pos + 1 >= text.length() || text.charAt(pos) != '\\') {
                throw new IllegalArgumentException("This is not an escapement start");
            }
            char c = text.charAt(pos + 1);
            if (c == 'x') {
                return 3;
            }
            if (c == 'u') {
                return 5;
            }
            if (c == 'U') {
                return 9;
            }
            return 1;
        }

        static int toUnicodeChar(@NotNull CharSequence text, int pos, int length) {
            if (length > 1) {
                CharSequence s = text.subSequence(pos + 2, Math.min(text.length(), pos + length + 1));
                try {
                    return Integer.parseInt(s.toString(), 16);
                }
                catch (NumberFormatException e) {
                    return 63;
                }
            }
            Integer result = (Integer)((Map)ESC_TO_CODE.getValue()).get(text.charAt(pos + 1));
            return (Integer)ObjectUtils.notNull((Object)result, (Object)text.charAt(pos + 1));
        }
    }
}

