/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.impl.YAMLValueImpl;

public abstract class YAMLScalarImpl
extends YAMLValueImpl
implements YAMLScalar {
    protected static final int MAX_SCALAR_LENGTH_PREDEFINED = 60;

    public YAMLScalarImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public abstract List<TextRange> getContentRanges();

    @NotNull
    protected abstract String getRangesJoiner(@NotNull CharSequence var1, @NotNull List<TextRange> var2, int var3);

    protected List<Pair<TextRange, String>> getDecodeReplacements(@NotNull CharSequence input) {
        return Collections.emptyList();
    }

    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        throw new IllegalArgumentException("Not implemented");
    }

    @Override
    @NotNull
    public String getTextValue() {
        String text = this.getText();
        List<TextRange> contentRanges = this.getContentRanges();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < contentRanges.size(); ++i) {
            TextRange range = contentRanges.get(i);
            CharSequence curString = range.subSequence((CharSequence)text);
            builder.append(curString);
            if (i + 1 == contentRanges.size()) continue;
            builder.append(this.getRangesJoiner(text, contentRanges, i));
        }
        return YAMLScalarImpl.processReplacements(builder, this.getDecodeReplacements(builder));
    }

    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        return references.length == 1 ? references[0] : null;
    }

    @NotNull
    public PsiReference[] getReferences() {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        return (PsiLanguageInjectionHost)ElementManipulators.getManipulator((PsiElement)this).handleContentChange((PsiElement)this, text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new MyLiteralTextEscaper(this);
    }

    @NotNull
    static String processReplacements(@NotNull CharSequence input, @NotNull List<Pair<TextRange, String>> replacements) throws IndexOutOfBoundsException {
        StringBuilder result = new StringBuilder();
        int currentOffset = 0;
        for (Pair<TextRange, String> replacement : replacements) {
            result.append(input.subSequence(currentOffset, ((TextRange)replacement.getFirst()).getStartOffset()));
            result.append((String)replacement.getSecond());
            currentOffset = ((TextRange)replacement.getFirst()).getEndOffset();
        }
        result.append(input.subSequence(currentOffset, input.length()));
        return result.toString();
    }

    protected static boolean isSurroundedByNoSpace(CharSequence text, int pos) {
        return !(pos - 1 >= 0 && YAMLGrammarCharUtil.isSpaceLike(text.charAt(pos - 1)) || pos + 1 < text.length() && YAMLGrammarCharUtil.isSpaceLike(text.charAt(pos + 1)));
    }

    @Nullable
    protected final ASTNode getFirstContentNode() {
        ASTNode node;
        for (node = this.getNode().getFirstChildNode(); node != null && (node.getElementType() == YAMLTokenTypes.TAG || YAMLElementTypes.BLANK_ELEMENTS.contains(node.getElementType())); node = node.getTreeNext()) {
        }
        return node;
    }

    private static class MyLiteralTextEscaper
    extends LiteralTextEscaper<YAMLScalarImpl> {
        public MyLiteralTextEscaper(YAMLScalarImpl scalar) {
            super((PsiLanguageInjectionHost)scalar);
        }

        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            outChars.append(((YAMLScalarImpl)this.myHost).getTextValue());
            return true;
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            String text = ((YAMLScalarImpl)this.myHost).getText();
            List<TextRange> contentRanges = ((YAMLScalarImpl)this.myHost).getContentRanges();
            int currentOffsetInDecoded = 0;
            for (int i = 0; i < contentRanges.size(); ++i) {
                TextRange range = contentRanges.get(i);
                String curString = range.subSequence((CharSequence)text).toString();
                if (i + 1 != contentRanges.size()) {
                    String joiner = ((YAMLScalarImpl)this.myHost).getRangesJoiner(text, contentRanges, i);
                    curString = curString + joiner;
                }
                List<Pair<TextRange, String>> replacementsForThisLine = ((YAMLScalarImpl)this.myHost).getDecodeReplacements(curString);
                int encodedOffsetInCurrentLine = 0;
                for (Pair<TextRange, String> replacement : replacementsForThisLine) {
                    int deltaLength = ((TextRange)replacement.getFirst()).getStartOffset() - encodedOffsetInCurrentLine;
                    if (currentOffsetInDecoded + deltaLength >= offsetInDecoded) {
                        return range.getStartOffset() + encodedOffsetInCurrentLine + (offsetInDecoded - currentOffsetInDecoded);
                    }
                    currentOffsetInDecoded += deltaLength + ((String)replacement.getSecond()).length();
                    encodedOffsetInCurrentLine += deltaLength + ((TextRange)replacement.getFirst()).getLength();
                }
                int deltaLength = curString.length() - encodedOffsetInCurrentLine;
                if (currentOffsetInDecoded + deltaLength > offsetInDecoded) {
                    return range.getStartOffset() + encodedOffsetInCurrentLine + (offsetInDecoded - currentOffsetInDecoded);
                }
                currentOffsetInDecoded += deltaLength;
            }
            return ((TextRange)ContainerUtil.getLastItem(contentRanges, (Object)rangeInsideHost)).getEndOffset();
        }

        public boolean isOneLine() {
            return ((YAMLScalarImpl)this.myHost).isMultiline();
        }
    }
}

