/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.api;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleValue;
import com.google.appindexing.util.AppIndexingBundle;
import com.google.appindexing.util.DeepLinkUtils;
import com.google.common.collect.ImmutableList;
import com.google.urlassistant.util.InsertCodeUtils;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.StatementFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.VersionComparatorUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApiCreator {
    private static final String METHOD_GET_ACTION = "getIndexApiAction";
    private static final String CLASS_ACTION = "Action";
    private static final String CLASS_FIREBASE_USER_ACTION = "FirebaseUserActions";
    private static final String CLASS_BUILDERS_ACTIONS = "Actions";
    private static final String CLASS_FIREBASE_APP_INDEX = "FirebaseAppIndex";
    private static final String CLASS_INDEXABLE = "Indexable";
    private static final String CLASS_ACTION_FULL = "com.google.firebase.appindexing.Action";
    private static final String CLASS_FIREBASE_USER_ACTION_FULL = "com.google.firebase.appindexing.FirebaseUserActions";
    private static final String CLASS_BUILDERS_ACTIONS_FULL = "com.google.firebase.appindexing.builders.Actions";
    private static final String CLASS_FIREBASE_APP_INDEX_FULL = "com.google.firebase.appindexing.FirebaseAppIndex";
    private static final String CLASS_INDEXABLE_FULL = "com.google.firebase.appindexing.Indexable";
    private static final String ON_START_FORMAT = "@Override\npublic void onStart(){\n  super.onStart();\n  \n  // ATTENTION: This was auto-generated to implement the App Indexing API.\n  // See https://g.co/AppIndexing/AndroidStudio for more information.\n  %1$s\n  %2$s.getInstance().start(%3$s());\n}";
    private static final String ON_STOP_FORMAT = "@Override\npublic void onStop() {\n  \n  // ATTENTION: This was auto-generated to implement the App Indexing API.\n  // See https://g.co/AppIndexing/AndroidStudio for more information.\n  %1$s.getInstance().end(%2$s());\n  super.onStop();\n}";
    private static final String GET_ACTION_FORMAT = "/**\n * ATTENTION: This was auto-generated to implement the App Indexing API.\n * See https://g.co/AppIndexing/AndroidStudio for more information.\n */\npublic %1$s %2$s() {\n  return %3$s.newView(\"%4$s\", \"%5$s\");\n}";
    private static final String FIREBASE_APP_INDEX_UPDATE_TEMPLATE = "%1$s.getInstance().update(new %2$s.Builder().setName(\"%3$s\").setUrl(\"%4$s\").build());";
    private static final String FIREBASE_USER_ACTION_START_TEMPLATE = "%1$s.getInstance().start(%2$s());";
    private static final String FIREBASE_USER_ACTION_END_TEMPLATE = "%1$s.getInstance().end(%2$s());";
    private static final String FIREBASE_USER_ACTION_START = "FirebaseUserActions.getInstance().start";
    private static final String FIREBASE_APP_INDEX_UPDATE = "FirebaseAppIndex.getInstance().update";
    private static final String FIREBASE_USER_ACTION_END = "FirebaseUserActions.getInstance().end";
    private static final List<String> COMMENT_IN_JAVA = ImmutableList.of((Object)"// ATTENTION: This was auto-generated to implement the App Indexing API.", (Object)"// See https://g.co/AppIndexing/AndroidStudio for more information.");
    private static final String APP_INDEXING_LIB_DEPENDENCY = "com.google.firebase:firebase-appindexing:10.0.1+";
    private static final String APP_INDEXING_CLASSPATH_DEPENDENCY = "com.google.gms:google-services:3.0.0+";
    private static final String APP_INDEXING_PLUGIN_DEPENDENCY = "com.google.gms.google-services";
    private Project myProject = null;
    private Module myModule = null;
    private PsiFile myFile = null;
    private PsiClass myActivity = null;
    private PsiElementFactory myFactory = null;
    private CodeStyleManager myCodeStyleManager = null;
    private PsiCodeBlock myOnStart = null;
    private PsiCodeBlock myOnStop = null;
    private String myDeepLink = null;
    private List<PsiStatement> myIndexUpdateStatements = new ArrayList<PsiStatement>();
    private List<PsiStatement> myStartStatements = new ArrayList<PsiStatement>();
    private List<PsiStatement> myEndStatements = new ArrayList<PsiStatement>();
    private static Map<String, String> myImportClasses = new HashMap<String, String>();

    public ApiCreator(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiClass activityClass) {
        this.myProject = project;
        this.myFile = file;
        this.myModule = ModuleUtilCore.findModuleForFile((VirtualFile)this.myFile.getVirtualFile(), (Project)this.myProject);
        this.myActivity = activityClass;
        this.myOnStart = InsertCodeUtils.getMethodBodyByName((String)"onStart", Collections.emptyList(), (PsiClass)this.myActivity);
        this.myOnStop = InsertCodeUtils.getMethodBodyByName((String)"onStop", Collections.emptyList(), (PsiClass)this.myActivity);
        if (this.myOnStart != null) {
            this.myIndexUpdateStatements = StatementFilter.filterCodeBlock((String)FIREBASE_APP_INDEX_UPDATE, (PsiCodeBlock)this.myOnStart);
            this.myStartStatements = StatementFilter.filterCodeBlock((String)FIREBASE_USER_ACTION_START, (PsiCodeBlock)this.myOnStart);
        }
        if (this.myOnStop != null) {
            this.myEndStatements = StatementFilter.filterCodeBlock((String)FIREBASE_USER_ACTION_END, (PsiCodeBlock)this.myOnStop);
        }
        this.myDeepLink = this.getFirstDeepLinkOfActivity();
        this.myFactory = (PsiElementFactory)JVMElementFactories.getFactory((Language)JavaLanguage.INSTANCE, (Project)this.myProject);
        this.myCodeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
        myImportClasses.put(CLASS_ACTION, CLASS_ACTION_FULL);
        myImportClasses.put(CLASS_BUILDERS_ACTIONS, CLASS_BUILDERS_ACTIONS_FULL);
        myImportClasses.put(CLASS_FIREBASE_USER_ACTION, CLASS_FIREBASE_USER_ACTION_FULL);
        myImportClasses.put(CLASS_FIREBASE_APP_INDEX, CLASS_FIREBASE_APP_INDEX_FULL);
        myImportClasses.put(CLASS_INDEXABLE, CLASS_INDEXABLE_FULL);
    }

    @NotNull
    public InsertStatusCode eligibleForInsertingAppIndexingApiCode() {
        if (!(this.myFile instanceof PsiJavaFile)) {
            return InsertStatusCode.NON_JAVA_FILE;
        }
        if (this.myActivity == null) {
            return InsertStatusCode.JAVA_FILE_WITHOUT_ACTIVITY;
        }
        assert (this.myModule != null);
        if (!ApiCreator.hasEnoughDependencies(this.myModule)) {
            return InsertStatusCode.DEPENDENCY_MISSING;
        }
        assert (this.myFactory != null);
        assert (this.myCodeStyleManager != null);
        if (StringUtil.isEmpty((String)this.myDeepLink)) {
            return InsertStatusCode.DEEP_LINK_MISSING;
        }
        if (this.myOnStart == null || this.myOnStop == null) {
            return InsertStatusCode.SUCCESS;
        }
        if (this.myStartStatements.isEmpty() || this.myIndexUpdateStatements.isEmpty() || this.myEndStatements.isEmpty()) {
            return InsertStatusCode.SUCCESS;
        }
        return InsertStatusCode.API_EXISTS;
    }

    @NotNull
    public InsertStatusCode insertAppIndexingApiCodeForActivity() {
        InsertStatusCode statusCode = this.eligibleForInsertingAppIndexingApiCode();
        if (statusCode == InsertStatusCode.SUCCESS) {
            this.insertAppIndexingApiCodeInJavaFile();
        }
        return statusCode;
    }

    void insertAppIndexingApiCodeInJavaFile() {
        this.insertImportStatements();
        String getActionMethodCallText = this.insertGetActionMethod();
        this.addOrMergeOnStart(getActionMethodCallText);
        this.addOrMergeOnStop(getActionMethodCallText);
        JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)this.myActivity);
        this.unlockFromPsiOperation(this.myFile);
    }

    @NotNull
    private String insertGetActionMethod() {
        String methodName = this.getUnusedMethodName(METHOD_GET_ACTION);
        String getActionMethod = String.format(GET_ACTION_FORMAT, myImportClasses.get(CLASS_ACTION), methodName, myImportClasses.get(CLASS_BUILDERS_ACTIONS), this.getMyPageName(), this.myDeepLink);
        PsiMethod newGetAction = this.myFactory.createMethodFromText(getActionMethod, null);
        this.myActivity.add((PsiElement)newGetAction);
        return methodName;
    }

    private String getMyPageName() {
        String pageName = this.myActivity.getName();
        return pageName == null ? "" : StringUtil.trimEnd((String)pageName, (String)"Activity");
    }

    @NotNull
    private String getUnusedMethodName(@NotNull String methodName) {
        PsiMethod[] psiMethods = this.myActivity.getMethods();
        HashSet<String> usedMethodNames = new HashSet<String>();
        for (PsiMethod p : psiMethods) {
            usedMethodNames.add(p.getName());
        }
        String unusedMethodName = methodName;
        int suffix = 0;
        while (usedMethodNames.contains(unusedMethodName)) {
            unusedMethodName = methodName + suffix;
            ++suffix;
        }
        return unusedMethodName;
    }

    private void insertImportStatements() {
        for (Map.Entry<String, String> className : myImportClasses.entrySet()) {
            if (ImportUtils.hasOnDemandImportConflict((String)className.getValue(), (PsiElement)this.myActivity) || ApiCreator.hasExactImportConflict(className.getValue(), (PsiJavaFile)this.myFile)) continue;
            this.insertSingleImportIfNeeded(className.getValue());
            className.setValue(className.getKey());
        }
    }

    private static boolean hasExactImportConflict(String fqName, PsiJavaFile file) {
        PsiImportList imports = file.getImportList();
        if (imports == null) {
            return false;
        }
        PsiImportStatement[] importStatements = imports.getImportStatements();
        int lastDotIndex = fqName.lastIndexOf(46);
        String shortName = fqName.substring(lastDotIndex + 1);
        String dottedShortName = '.' + shortName;
        for (PsiImportStatement importStatement : importStatements) {
            if (importStatement.isOnDemand()) continue;
            String importName = importStatement.getQualifiedName();
            if (importName == null) {
                return false;
            }
            if (importName.equals(fqName) || !importName.endsWith(dottedShortName)) continue;
            return true;
        }
        return false;
    }

    private void addOrMergeOnStart(@NotNull String getActionMethodCallText) {
        if (this.myOnStart == null) {
            String onStartMethod = String.format(ON_START_FORMAT, String.format(FIREBASE_APP_INDEX_UPDATE_TEMPLATE, myImportClasses.get(CLASS_FIREBASE_APP_INDEX), myImportClasses.get(CLASS_INDEXABLE), this.getMyPageName(), this.myDeepLink), myImportClasses.get(CLASS_FIREBASE_USER_ACTION), getActionMethodCallText);
            this.myActivity.add((PsiElement)this.myFactory.createMethodFromText(onStartMethod, null));
            return;
        }
        if (this.myIndexUpdateStatements.isEmpty() || this.myStartStatements.isEmpty()) {
            String updateText = String.format(FIREBASE_APP_INDEX_UPDATE_TEMPLATE, myImportClasses.get(CLASS_FIREBASE_APP_INDEX), myImportClasses.get(CLASS_INDEXABLE), this.getMyPageName(), this.myDeepLink);
            PsiStatement updateStatement = this.myFactory.createStatementFromText(updateText, null);
            updateStatement = this.myStartStatements.isEmpty() ? this.myOnStart.add((PsiElement)updateStatement) : this.myOnStart.addBefore((PsiElement)updateStatement, (PsiElement)this.myStartStatements.get(0));
            String startText = String.format(FIREBASE_USER_ACTION_START_TEMPLATE, myImportClasses.get(CLASS_FIREBASE_USER_ACTION), getActionMethodCallText);
            PsiStatement startStatement = this.myFactory.createStatementFromText(startText, null);
            this.myOnStart.addAfter((PsiElement)startStatement, (PsiElement)updateStatement);
            this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnStart, (PsiElement)updateStatement);
        }
    }

    private void addOrMergeOnStop(@NotNull String getActionMethodCallText) {
        if (this.myOnStop == null) {
            String onStopMethod = String.format(ON_STOP_FORMAT, myImportClasses.get(CLASS_FIREBASE_USER_ACTION), getActionMethodCallText);
            this.myActivity.add((PsiElement)this.myFactory.createMethodFromText(onStopMethod, null));
            return;
        }
        if (!this.myEndStatements.isEmpty()) {
            return;
        }
        PsiStatement endStatement = this.myFactory.createStatementFromText(String.format(FIREBASE_USER_ACTION_END_TEMPLATE, myImportClasses.get(CLASS_FIREBASE_USER_ACTION), getActionMethodCallText), null);
        List superOnStopStatements = StatementFilter.filterCodeBlock((String)"super.onStop();", (PsiCodeBlock)this.myOnStop);
        if (!superOnStopStatements.isEmpty()) {
            endStatement = (PsiStatement)this.myOnStop.addAfter((PsiElement)endStatement, (PsiElement)superOnStopStatements.get(0));
            this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnStop, (PsiElement)endStatement);
        } else {
            endStatement = (PsiStatement)this.myOnStop.addAfter((PsiElement)endStatement, this.myOnStop.getFirstBodyElement());
            this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnStop, (PsiElement)endStatement);
        }
    }

    @Nullable
    String getFirstDeepLinkOfActivity() {
        XmlFile manifest = ManifestUtils.getAndroidManifestPsi((Module)this.myModule);
        if (manifest != null && manifest.getRootTag() != null) {
            List activityTags = ManifestUtils.searchXmlTagsByName((XmlTag)manifest.getRootTag(), (String)"activity");
            for (XmlTag activityTag : activityTags) {
                List<String> deepLinks;
                String activityName = activityTag.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                if (activityName == null || !activityName.equals("." + this.myActivity.getName()) || (deepLinks = DeepLinkUtils.getAllDeepLinks(activityTag)).isEmpty()) continue;
                return deepLinks.get(0);
            }
        }
        return null;
    }

    private void addCommentsBefore(@NotNull List<String> texts, @NotNull PsiElement element, @NotNull PsiElement anchor) {
        this.myCodeStyleManager.reformat(element);
        for (String text : texts) {
            element.addBefore((PsiElement)this.myFactory.createCommentFromText(text, null), anchor);
            this.myCodeStyleManager.reformat(element);
        }
    }

    private void unlockFromPsiOperation(@NotNull PsiFile file) {
        Document doc = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        if (doc != null) {
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(doc);
        }
    }

    private void insertSingleImportIfNeeded(@NotNull String className) {
        PsiImportList importList = ((PsiJavaFile)this.myFile).getImportList();
        if (importList != null && !InsertCodeUtils.hasImportStatement((PsiImportList)importList, (String)className)) {
            String dummyFileName = "_Dummy_" + className + "_." + JavaFileType.INSTANCE.getDefaultExtension();
            PsiJavaFile aFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(dummyFileName, (FileType)JavaFileType.INSTANCE, (CharSequence)("import " + className + ";"));
            PsiImportList dummyImportList = aFile.getImportList();
            if (dummyImportList != null) {
                PsiImportStatement[] statements = dummyImportList.getImportStatements();
                PsiImportStatement statement = (PsiImportStatement)this.myCodeStyleManager.reformat((PsiElement)statements[0]);
                importList.add((PsiElement)statement);
            }
        }
    }

    public static boolean hasEnoughDependencies(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        GradleBuildModel gradleBuildModel = GradleBuildModel.get((Module)module);
        if (gradleBuildModel == null) {
            return false;
        }
        DependenciesModel dependenciesModel = gradleBuildModel.dependencies();
        if (dependenciesModel == null) {
            return false;
        }
        if (!ApiCreator.hasDependency(APP_INDEXING_LIB_DEPENDENCY, dependenciesModel.artifacts())) {
            return false;
        }
        List plugins = GradleValue.getValues((List)gradleBuildModel.appliedPlugins());
        if (!plugins.contains(APP_INDEXING_PLUGIN_DEPENDENCY)) {
            return false;
        }
        GradleBuildModel projectGradleBuildModel = GradleBuildModel.get((Project)module.getProject());
        if (projectGradleBuildModel == null) {
            return false;
        }
        DependenciesModel dependencies = projectGradleBuildModel.buildscript().dependencies();
        return ApiCreator.hasDependency(APP_INDEXING_CLASSPATH_DEPENDENCY, dependencies.artifacts("classpath"));
    }

    private static boolean hasDependency(@NotNull String dependencyValue, @NotNull List<ArtifactDependencyModel> existingDeps) {
        ArtifactDependencySpec requiredDepSpec = ArtifactDependencySpec.create((String)dependencyValue);
        if (requiredDepSpec == null) {
            return true;
        }
        for (ArtifactDependencyModel dependency : existingDeps) {
            ArtifactDependencySpec foundDepSpec = ArtifactDependencySpec.create((ArtifactDependencyModel)dependency);
            if (!foundDepSpec.equalsIgnoreVersion((Object)requiredDepSpec) || VersionComparatorUtil.compare((String)foundDepSpec.version, (String)requiredDepSpec.version) < 0) continue;
            return true;
        }
        return false;
    }

    public static enum InsertStatusCode {
        SUCCESS,
        NON_JAVA_FILE,
        JAVA_FILE_WITHOUT_ACTIVITY,
        DEEP_LINK_MISSING,
        DEPENDENCY_MISSING,
        API_EXISTS;

        private final String message = this.name() == "SUCCESS" ? "" : AppIndexingBundle.message("app.indexing.code.insert.error." + this.name().toLowerCase(), new Object[0]);

        public String getMessage() {
            return this.message;
        }
    }
}

