/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.ui;

import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.analytics.UsageTracker;
import com.google.api.client.util.Lists;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleClient;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleTask;
import com.google.appindexing.util.AppIndexingBundle;
import com.google.appindexing.util.DeepLinkUtils;
import com.google.gct.login.GoogleLogin;
import com.google.urlassistant.util.ManifestUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AppIndexingDialog
extends DialogWrapper {
    private static final String DIALOG_TITLE = "Firebase App Indexing Test";
    private static final String HELP_URL = "https://firebase.google.com/docs/app-indexing/android/test";
    private JPanel myPanel;
    private JComboBox<Module> myModulesComboBox;
    private JLabel myWarningLabel;
    private JButton myLoginButton;
    private TextFieldWithHistory myDeepLinkInputField;
    private JPanel myWarningPanel;
    private JLabel myWarningTitle;
    private JRadioButton myBuildApkRadioButton;
    private JRadioButton myUseApkInPlayRadioButton;
    private final SortedComboBoxModel<Module> myModules;
    private Project myProject;

    private static Logger getLog() {
        return Logger.getInstance(FetchAsGoogleTask.class);
    }

    public AppIndexingDialog(@NotNull Project project) {
        super(project);
        Module[] modules;
        Comparator comparator = (module, module1) -> module.getName().compareToIgnoreCase(module1.getName());
        this.$$$setupUI$$$();
        this.myModules = new SortedComboBoxModel(comparator);
        FormScalingUtil.scaleComponentTree(((Object)((Object)this)).getClass(), (JComponent)this.myPanel);
        this.init();
        this.setTitle(DIALOG_TITLE);
        this.myProject = project;
        for (Module module2 : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (!AppIndexingDialog.isModuleAccepted(module2)) continue;
            this.myModules.add((Object)module2);
        }
        if (this.myModules.getSize() != 0) {
            this.myModules.setSelectedItem(this.myModules.getElementAt(0));
        }
        this.myModulesComboBox.setModel((ComboBoxModel<Module>)this.myModules);
        this.myModulesComboBox.setRenderer((ListCellRenderer<Module>)new ListCellRendererWrapper<Module>(){

            public void customize(JList list, Module value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setIcon(ModuleType.get((Module)value).getIcon());
                    this.setText(value.getName());
                } else {
                    this.setText("<no module>");
                }
            }
        });
        this.myModulesComboBox.addActionListener(e -> this.myDeepLinkInputField.setHistory(this.getDeepLinks()));
        this.myDeepLinkInputField.setEditor((ComboBoxEditor)new MyComboBoxEditor());
        this.myDeepLinkInputField.setHistorySize(-1);
        this.myDeepLinkInputField.setHistory(this.getDeepLinks());
        this.myLoginButton.addActionListener(e -> {
            try {
                this.myLoginButton.setEnabled(false);
                GoogleLogin.promptToLogIn(null, () -> ApplicationManager.getApplication().invokeLater(this::verifyInput, ModalityState.any()));
            }
            catch (Exception ex) {
                AppIndexingDialog.getLog().warn("Login fail", (Throwable)ex);
            }
        });
        this.myWarningTitle.setIcon(AllIcons.General.BalloonError);
        this.myWarningTitle.setFont(this.myWarningTitle.getFont().deriveFont(1));
        this.myWarningPanel.setVisible(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.myBuildApkRadioButton);
        group.add(this.myUseApkInPlayRadioButton);
        this.doValidate();
    }

    static boolean isModuleAccepted(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        return facet != null && facet.isAppProject();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected ValidationInfo doValidate() {
        this.setOKActionEnabled(this.verifyInput());
        return null;
    }

    protected void doOKAction() {
        if (this.verifyInput()) {
            try {
                FetchAsGoogleTask task = FetchAsGoogleTask.createFetchAsGoogleTask(this.myProject, (Module)this.myModules.getSelectedItem(), this.myDeepLinkInputField.getText(), this.myBuildApkRadioButton.isSelected(), FetchAsGoogleTask.RequestType.APP_INDEXING);
                UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.APP_INDEXING).setKind(AndroidStudioEvent.EventKind.APP_INDEXING_START_FEAG_TASK));
                ApplicationManager.getApplication().executeOnPooledThread((Runnable)task);
                super.doOKAction();
            }
            catch (FetchAsGoogleClient.FetchAsGoogleException ex) {
                AppIndexingDialog.getLog().warn((Throwable)ex);
            }
        }
    }

    protected String getHelpId() {
        return "reference.dialogs.appindexing";
    }

    protected void doHelpAction() {
        BrowserUtil.browse((String)HELP_URL);
    }

    private boolean verifyInput() {
        this.myWarningLabel.setText("");
        this.myLoginButton.setVisible(false);
        this.myWarningPanel.setVisible(false);
        if (this.myModules.getSelectedItem() == null) {
            this.myWarningLabel.setText(AppIndexingBundle.message("app.indexing.module.not.provided.warning.message", new Object[0]));
            this.myWarningPanel.setVisible(true);
            return false;
        }
        if (this.myDeepLinkInputField.getText().isEmpty()) {
            this.myWarningLabel.setText(AppIndexingBundle.message("app.indexing.url.not.provided", new Object[0]));
            this.myWarningPanel.setVisible(true);
            return false;
        }
        if (!GoogleLogin.getInstance().isLoggedIn()) {
            this.myWarningLabel.setText(AppIndexingBundle.message("app.indexing.login.warning.message", new Object[0]));
            this.myLoginButton.setVisible(true);
            this.myLoginButton.setEnabled(true);
            this.myWarningPanel.setVisible(true);
            return false;
        }
        return true;
    }

    @NotNull
    private List<String> getDeepLinks() {
        XmlFile manifest;
        Module module;
        if (this.myProject.isInitialized() && (module = (Module)this.myModules.getSelectedItem()) != null && (manifest = ManifestUtils.getAndroidManifestPsi((Module)module)) != null && manifest.getRootTag() != null) {
            return DeepLinkUtils.getAllDeepLinks(manifest.getRootTag());
        }
        return Lists.newArrayList();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        TextFieldWithHistory textFieldWithHistory;
        JButton jButton;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setMinimumSize(new Dimension(550, 180));
        jPanel2.setPreferredSize(new Dimension(550, 180));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("URL:");
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 3, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Module:");
        jPanel2.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myModulesComboBox = jComboBox;
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, new Dimension(-1, 50), null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myWarningPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myWarningTitle = jLabel2 = new JLabel();
        jLabel2.setText("Warning:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myWarningLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLoginButton = jButton = new JButton();
        ((Component)jButton).setVisible(false);
        jButton.setText("Sign in");
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 0, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("This test helps ensure that Google can find and open your URLs");
        jLabel5.setVerifyInputWhenFocusTarget(false);
        jPanel4.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeepLinkInputField = textFieldWithHistory = new TextFieldWithHistory();
        jPanel2.add((Component)textFieldWithHistory, new GridConstraints(2, 1, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myBuildApkRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Build apk");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseApkInPlayRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use apk in Play Store");
        jPanel2.add((Component)jRadioButton, new GridConstraints(3, 2, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    static class MyComboBoxEditor
    extends BasicComboBoxEditor {
        private static final String HINT_MESSAGE = "Specify the URL to test";

        MyComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            JBTextField editor = new JBTextField();
            editor.setBorder(null);
            editor.getEmptyText().setText(HINT_MESSAGE);
            return editor;
        }
    }
}

