/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.Variable;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.eclipse.model.internal.ProjectDependencyBuilder;
import org.gradle.plugins.ide.internal.IdeDependenciesExtractor;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeLocalFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeProjectDependency;
import org.gradle.plugins.ide.internal.resolver.model.UnresolvedIdeRepoFileDependency;

public class EclipseDependenciesCreator {
    private final IdeDependenciesExtractor dependenciesExtractor = new IdeDependenciesExtractor();
    private final EclipseClasspath classpath;
    private final ProjectDependencyBuilder projectDependencyBuilder;

    public EclipseDependenciesCreator(EclipseClasspath classpath) {
        this.classpath = classpath;
        ServiceRegistry serviceRegistry = ((ProjectInternal)classpath.getProject()).getServices();
        this.projectDependencyBuilder = new ProjectDependencyBuilder((LocalComponentRegistry)serviceRegistry.get(LocalComponentRegistry.class));
    }

    public List<AbstractClasspathEntry> createDependencyEntries() {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.createProjectDependencies());
        if (!this.classpath.isProjectDependenciesOnly()) {
            result.addAll(this.createLibraryDependencies());
        }
        return result;
    }

    public Collection<UnresolvedIdeRepoFileDependency> unresolvedExternalDependencies() {
        return this.dependenciesExtractor.unresolvedExternalDependencies(this.classpath.getPlusConfigurations(), this.classpath.getMinusConfigurations());
    }

    private List<AbstractClasspathEntry> createProjectDependencies() {
        ArrayList projects = Lists.newArrayList();
        Collection<IdeProjectDependency> projectDependencies = this.dependenciesExtractor.extractProjectDependencies(this.classpath.getProject(), this.classpath.getPlusConfigurations(), this.classpath.getMinusConfigurations());
        for (IdeProjectDependency projectDependency : projectDependencies) {
            projects.add(this.projectDependencyBuilder.build(projectDependency));
        }
        return projects;
    }

    private List<AbstractClasspathEntry> createLibraryDependencies() {
        ArrayList libraries = Lists.newArrayList();
        boolean downloadSources = this.classpath.isDownloadSources();
        boolean downloadJavadoc = this.classpath.isDownloadJavadoc();
        Collection<IdeExtendedRepoFileDependency> repoFileDependencies = this.dependenciesExtractor.extractRepoFileDependencies(this.classpath.getProject().getDependencies(), this.classpath.getPlusConfigurations(), this.classpath.getMinusConfigurations(), downloadSources, downloadJavadoc);
        for (IdeExtendedRepoFileDependency dependency : repoFileDependencies) {
            libraries.add(EclipseDependenciesCreator.createLibraryEntry(dependency.getFile(), dependency.getSourceFile(), dependency.getJavadocFile(), this.classpath, dependency.getId()));
        }
        Collection<IdeLocalFileDependency> localFileDependencies = this.dependenciesExtractor.extractLocalFileDependencies(this.classpath.getPlusConfigurations(), this.classpath.getMinusConfigurations());
        for (IdeLocalFileDependency it : localFileDependencies) {
            libraries.add(EclipseDependenciesCreator.createLibraryEntry(it.getFile(), null, null, this.classpath, null));
        }
        return libraries;
    }

    private static AbstractLibrary createLibraryEntry(File binary, File source, File javadoc, EclipseClasspath classpath, ModuleVersionIdentifier id) {
        FileReferenceFactory referenceFactory = classpath.getFileReferenceFactory();
        FileReference binaryRef = referenceFactory.fromFile(binary);
        FileReference sourceRef = referenceFactory.fromFile(source);
        FileReference javadocRef = referenceFactory.fromFile(javadoc);
        AbstractLibrary out = binaryRef.isRelativeToPathVariable() ? new Variable(binaryRef) : new Library(binaryRef);
        out.setJavadocPath(javadocRef);
        out.setSourcePath(sourceRef);
        out.setExported(false);
        out.setModuleVersion(id);
        return out;
    }
}

