/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.parser.BindingExpressionLexer;
import android.databinding.parser.BindingExpressionParser;
import android.databinding.tool.BindingTarget;
import android.databinding.tool.ExpressionVisitor;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.store.Location;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ExpressionParser {
    final ExprModel mModel;
    final ExpressionVisitor visitor;

    public ExpressionParser(ExprModel model) {
        this.mModel = model;
        this.visitor = new ExpressionVisitor(this.mModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr parse(String input, Location locationInFile, BindingTarget target) {
        ANTLRInputStream inputStream = new ANTLRInputStream(input);
        BindingExpressionLexer lexer = new BindingExpressionLexer((CharStream)inputStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        final BindingExpressionParser parser = new BindingExpressionParser((TokenStream)tokenStream);
        parser.getErrorListeners().clear();
        this.visitor.setBindingTarget(target);
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                L.e("Syntax error: %s", msg);
            }
        });
        BindingExpressionParser.BindingSyntaxContext root = parser.bindingSyntax();
        try {
            this.mModel.setCurrentLocationInFile(locationInFile);
            this.visitor.setParseTreeListener(new ParseTreeListener(){
                List<ParserRuleContext> mStack = new ArrayList<ParserRuleContext>();

                public void visitTerminal(TerminalNode node) {
                }

                public void visitErrorNode(ErrorNode node) {
                }

                public void enterEveryRule(ParserRuleContext ctx) {
                    this.mStack.add(ctx);
                    ExpressionParser.this.mModel.setCurrentParserContext(ctx);
                }

                public void exitEveryRule(ParserRuleContext ctx) {
                    Preconditions.check(ctx == this.mStack.get(this.mStack.size() - 1), "Inconsistent exit from context. Received %s, expecting %s", ctx.toInfoString((Parser)parser), this.mStack.get(this.mStack.size() - 1).toInfoString((Parser)parser));
                    this.mStack.remove(this.mStack.size() - 1);
                    if (this.mStack.size() > 0) {
                        ExpressionParser.this.mModel.setCurrentParserContext(this.mStack.get(this.mStack.size() - 1));
                    } else {
                        ExpressionParser.this.mModel.setCurrentParserContext(null);
                    }
                }
            });
            Expr expr = (Expr)root.accept(this.visitor);
            return expr;
        }
        finally {
            this.mModel.setCurrentLocationInFile(null);
        }
    }

    public ExprModel getModel() {
        return this.mModel;
    }
}

