/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.table.TableModelEditor;
import gnu.trove.THashSet;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsCredentialsStore;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.ReadOnlySourceManager;
import org.jetbrains.settingsRepository.ReadOnlySourcesEditorKt;
import org.jetbrains.settingsRepository.ReadonlySource;
import org.jetbrains.settingsRepository.UpstreamEditorKt;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\"$\u0010\u0000\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\b\u0001\u0012\u00020\u00040\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\t"}, d2={"COLUMNS", "", "Lcom/intellij/util/ui/table/TableModelEditor$EditableColumnInfo;", "Lorg/jetbrains/settingsRepository/ReadonlySource;", "", "[Lcom/intellij/util/ui/table/TableModelEditor$EditableColumnInfo;", "createReadOnlySourcesEditor", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/settingsRepository/IcsSettings;", "settings-repository"})
public final class ReadOnlySourcesEditorKt {
    private static final TableModelEditor.EditableColumnInfo<ReadonlySource, ? extends Object>[] COLUMNS;

    @NotNull
    public static final ConfigurableUi<IcsSettings> createReadOnlySourcesEditor() {
        TableModelEditor.DialogItemEditor<ReadonlySource> itemEditor2 = new TableModelEditor.DialogItemEditor<ReadonlySource>(){

            @NotNull
            public ReadonlySource clone(@NotNull ReadonlySource item, boolean forInPlaceEditing) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return new ReadonlySource(item.getUrl(), item.getActive());
            }

            @NotNull
            public Class<ReadonlySource> getItemClass() {
                return ReadonlySource.class;
            }

            public void edit(@NotNull ReadonlySource item, @NotNull Function<ReadonlySource, ReadonlySource> mutator, boolean isAdd) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                Intrinsics.checkParameterIsNotNull(mutator, (String)"mutator");
                DialogBuilder dialogBuilder = new DialogBuilder();
                TextFieldWithBrowseButton urlField = new TextFieldWithBrowseButton(new JTextField(20));
                urlField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFolderDescriptor()));
                urlField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(dialogBuilder, urlField){
                    final /* synthetic */ DialogBuilder $dialogBuilder;
                    final /* synthetic */ TextFieldWithBrowseButton $urlField;

                    protected void textChanged(@NotNull DocumentEvent event) {
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        this.$dialogBuilder.setOkActionEnabled(UpstreamEditorKt.checkUrl(StringKt.nullize$default((String)this.$urlField.getText(), (boolean)false, (int)1, null)));
                    }
                    {
                        this.$dialogBuilder = $captured_local_variable$0;
                        this.$urlField = $captured_local_variable$1;
                    }
                });
                dialogBuilder.title("Add read-only source").resizable(false).centerPanel((JComponent)FormBuilder.createFormBuilder().addLabeledComponent("URL:", (JComponent)urlField).getPanel()).setPreferredFocusComponent((JComponent)urlField);
                if (dialogBuilder.showAndGet()) {
                    ((ReadonlySource)mutator.fun((Object)item)).setUrl(urlField.getText());
                }
            }

            public void applyEdited(@NotNull ReadonlySource oldItem, @NotNull ReadonlySource newItem) {
                Intrinsics.checkParameterIsNotNull((Object)oldItem, (String)"oldItem");
                Intrinsics.checkParameterIsNotNull((Object)newItem, (String)"newItem");
                newItem.setUrl(oldItem.getUrl());
            }

            public boolean isUseDialogToAdd() {
                return true;
            }
        };
        TableModelEditor editor2 = new TableModelEditor((ColumnInfo[])COLUMNS, (CollectionItemEditor)itemEditor2, "No sources configured");
        editor2.reset((List)(ApplicationManager.getApplication().isUnitTestMode() ? CollectionsKt.emptyList() : IcsManagerKt.getIcsManager().getSettings().getReadOnlySources()));
        return (ConfigurableUi)new ConfigurableUi<IcsSettings>(editor2){
            final /* synthetic */ TableModelEditor $editor;

            public boolean isModified(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                return this.$editor.isModified();
            }

            /*
             * WARNING - void declaration
             */
            public void apply(@NotNull IcsSettings settings) {
                void title$iv;
                boolean cancellable$iv;
                Project project$iv;
                Object newSource2;
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                List<ReadonlySource> oldList = settings.getReadOnlySources();
                THashSet toDelete = new THashSet(oldList.size());
                for (ReadonlySource oldSource : oldList) {
                    ContainerUtil.addIfNotNull((Collection)((Collection)toDelete), (Object)oldSource.getPath());
                }
                THashSet toCheckout = new THashSet();
                List newList = this.$editor.apply();
                for (Object newSource2 : newList) {
                    String path = ((ReadonlySource)newSource2).getPath();
                    if (path == null || toDelete.remove((Object)path)) continue;
                    toCheckout.add(newSource2);
                }
                if (toDelete.isEmpty() && toCheckout.isEmpty()) {
                    return;
                }
                newSource2 = IcsBundleKt.icsMessage("task.sync.title", new Object[0]);
                Iterator<E> iterator = null;
                boolean path = false;
                int n = 6;
                Object var10_11 = null;
                if ((n & 2) != 0) {
                    project$iv = null;
                }
                if ((n & 4) != 0) {
                    cancellable$iv = true;
                }
                ProgressManager.getInstance().run((Task)new Task.Modal(project$iv, (String)title$iv, cancellable$iv, project$iv, (String)title$iv, cancellable$iv, toDelete, toCheckout, newList){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $title;
                    final /* synthetic */ boolean $cancellable;
                    final /* synthetic */ THashSet $toDelete$inlined;
                    final /* synthetic */ THashSet $toCheckout$inlined;
                    final /* synthetic */ List $newList$inlined;
                    {
                        this.$project = $captured_local_variable$1;
                        this.$title = $captured_local_variable$2;
                        this.$cancellable = $captured_local_variable$3;
                        this.$toDelete$inlined = tHashSet;
                        this.$toCheckout$inlined = tHashSet2;
                        this.$newList$inlined = list;
                        super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                    }

                    public void run(ProgressIndicator indicator) {
                        Logger $receiver$iv;
                        Object path2;
                        ProgressIndicator indicator2 = indicator;
                        indicator2.setIndeterminate(true);
                        Path root = IcsManagerKt.getIcsManager().getReadOnlySourcesManager().getRootDir();
                        Collection collection = (Collection)this.$toDelete$inlined;
                        if (!collection.isEmpty()) {
                            indicator2.setText("Deleting old repositories");
                            for (Object path2 : this.$toDelete$inlined) {
                                indicator2.checkCanceled();
                                $receiver$iv = IcsManagerKt.getLOG();
                                try {
                                    indicator2.setText2((String)path2);
                                    PathKt.delete((Path)root.resolve((String)path2));
                                }
                                catch (ProcessCanceledException e$iv) {
                                }
                                catch (Throwable e$iv) {
                                    $receiver$iv.error(e$iv);
                                }
                            }
                        }
                        if (!(path2 = (Collection)this.$toCheckout$inlined).isEmpty()) {
                            for (ReadonlySource source : this.$toCheckout$inlined) {
                                indicator2.checkCanceled();
                                $receiver$iv = IcsManagerKt.getLOG();
                                try {
                                    Path dir;
                                    StringBuilder stringBuilder = new StringBuilder().append("Cloning ");
                                    String string = source.getUrl();
                                    if (string == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    indicator2.setText(stringBuilder.append(StringKt.trimMiddle((String)string, (int)255)).toString());
                                    String string2 = source.getPath();
                                    if (string2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    if (PathKt.exists((Path)(dir = root.resolve(string2)))) {
                                        PathKt.delete((Path)dir);
                                    }
                                    String string3 = source.getUrl();
                                    if (string3 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    Path path3 = dir;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"dir");
                                    Lazy<IcsCredentialsStore> lazy = IcsManagerKt.getIcsManager().getCredentialsStore();
                                    ProgressMonitor progressMonitor = JGitProgressMonitorKt.asProgressMonitor(indicator2);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)progressMonitor, (String)"indicator.asProgressMonitor()");
                                    GitExKt.cloneBare(string3, path3, lazy, progressMonitor).close();
                                }
                                catch (ProcessCanceledException e$iv) {
                                }
                                catch (Throwable e$iv) {
                                    $receiver$iv.error(e$iv);
                                }
                            }
                        }
                        ReadOnlySourceManager readOnlySourceManager = IcsManagerKt.getIcsManager().getReadOnlySourcesManager();
                        List list = this.$newList$inlined;
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"newList");
                        readOnlySourceManager.setSources(list);
                        ((SchemeManagerFactoryBase)IcsManagerKt.getIcsManager().getSchemeManagerFactory().getValue()).process((Function1)createReadOnlySourcesEditor.apply.1.3.INSTANCE);
                    }
                });
            }

            public void reset(@NotNull IcsSettings settings) {
                Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
                this.$editor.reset(settings.getReadOnlySources());
            }

            @NotNull
            public JComponent getComponent() {
                return this.$editor.createComponent();
            }
            {
                this.$editor = $captured_local_variable$0;
            }
        };
    }

    static {
        TableModelEditor.EditableColumnInfo[] elements$iv = new TableModelEditor.EditableColumnInfo[]{(TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, Boolean>(){

            @NotNull
            public Class<Boolean> getColumnClass() {
                return Boolean.TYPE;
            }

            @NotNull
            public Boolean valueOf(@NotNull ReadonlySource item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return item.getActive();
            }

            public void setValue(@NotNull ReadonlySource item, boolean value) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                item.setActive(value);
            }
        }, (TableModelEditor.EditableColumnInfo)new TableModelEditor.EditableColumnInfo<ReadonlySource, String>(){

            @Nullable
            public String valueOf(@NotNull ReadonlySource item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                return item.getUrl();
            }

            public void setValue(@NotNull ReadonlySource item, @NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                item.setUrl(value);
            }
        }};
        COLUMNS = (TableModelEditor.EditableColumnInfo[])((Object[])elements$iv);
    }
}

