/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.Merger;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.SquashMessageFormatter;
import org.eclipse.jgit.merge.ThreeWayMergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.OperationResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.ImmutableUpdateResult;
import org.jetbrains.settingsRepository.RepositoryManagerKt;
import org.jetbrains.settingsRepository.UpdateResult;
import org.jetbrains.settingsRepository.git.CommitMessageFormatter;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryClient;
import org.jetbrains.settingsRepository.git.GitRepositoryManagerKt;
import org.jetbrains.settingsRepository.git.IdeaCommitMessageFormatter;
import org.jetbrains.settingsRepository.git.JGitProgressMonitorKt;
import org.jetbrains.settingsRepository.git.MergeResultEx;
import org.jetbrains.settingsRepository.git.PullKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0016\b\u0002\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0018\u00010 JL\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001c2\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020)2\b\b\u0002\u0010-\u001a\u00020)2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/J*\u00100\u001a\u0004\u0018\u0001012\b\b\u0002\u0010&\u001a\u00020'2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/2\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00063"}, d2={"Lorg/jetbrains/settingsRepository/git/Pull;", "", "manager", "Lorg/jetbrains/settingsRepository/git/GitRepositoryClient;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "commitMessageFormatter", "Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;", "(Lorg/jetbrains/settingsRepository/git/GitRepositoryClient;Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;)V", "getCommitMessageFormatter", "()Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;", "config", "Lorg/eclipse/jgit/lib/StoredConfig;", "getConfig", "()Lorg/eclipse/jgit/lib/StoredConfig;", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "getManager", "()Lorg/jetbrains/settingsRepository/git/GitRepositoryClient;", "remoteConfig", "Lorg/eclipse/jgit/transport/RemoteConfig;", "getRemoteConfig", "()Lorg/eclipse/jgit/transport/RemoteConfig;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "getRepository", "()Lorg/eclipse/jgit/lib/Repository;", "fetch", "Lorg/eclipse/jgit/lib/Ref;", "prevRefUpdateResult", "Lorg/eclipse/jgit/lib/RefUpdate$Result;", "refUpdateProcessor", "Lkotlin/Function1;", "Lorg/eclipse/jgit/transport/TrackingRefUpdate;", "", "merge", "Lorg/jetbrains/settingsRepository/git/MergeResultEx;", "unpeeledRef", "mergeStrategy", "Lorg/eclipse/jgit/merge/MergeStrategy;", "commit", "", "fastForwardMode", "Lorg/eclipse/jgit/api/MergeCommand$FastForwardMode;", "squash", "forceMerge", "commitMessage", "", "pull", "Lorg/jetbrains/settingsRepository/UpdateResult;", "prefetchedRefToMerge", "settings-repository"})
public class Pull {
    @NotNull
    private final Repository repository;
    @NotNull
    private final StoredConfig config;
    @NotNull
    private final RemoteConfig remoteConfig;
    @NotNull
    private final GitRepositoryClient manager;
    @Nullable
    private final ProgressIndicator indicator;
    @NotNull
    private final CommitMessageFormatter commitMessageFormatter;

    @NotNull
    public final Repository getRepository() {
        return this.repository;
    }

    @NotNull
    public final StoredConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final UpdateResult pull(@NotNull MergeStrategy mergeStrategy, @Nullable String commitMessage, @Nullable Ref prefetchedRefToMerge) {
        UpdateResult updateResult;
        void $receiver$iv;
        Exception e$iv;
        Intrinsics.checkParameterIsNotNull((Object)mergeStrategy, (String)"mergeStrategy");
        ProgressIndicator progressIndicator = this.indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        IcsManagerKt.getLOG().debug("Pull");
        RepositoryState state = PullKt.fixAndGetState(this.repository);
        if (!state.canCheckout()) {
            IcsManagerKt.getLOG().error("Cannot pull, repository in state " + state.getDescription());
            return null;
        }
        Ref ref = prefetchedRefToMerge;
        if (ref == null) {
            ref = Pull.fetch$default(this, null, null, 3, null);
        }
        if (ref == null) {
            return null;
        }
        Ref refToMerge = ref;
        MergeResultEx mergeResult = Pull.merge$default(this, refToMerge, mergeStrategy, false, null, false, false, commitMessage, 60, null);
        MergeResult.MergeStatus mergeStatus = mergeResult.getStatus();
        Logger logger = IcsManagerKt.getLOG();
        Object var9_9 = null;
        boolean bl = true;
        Object var11_11 = null;
        if (bl & true) {
            e$iv = null;
        }
        if ($receiver$iv.isDebugEnabled()) {
            void var13_12 = $receiver$iv;
            String string = mergeStatus.toString();
            var13_12.debug(string, (Throwable)e$iv);
        }
        if (Intrinsics.areEqual((Object)mergeStatus, (Object)MergeResult.MergeStatus.CONFLICTING)) {
            updateResult = PullKt.access$resolveConflicts(mergeResult, this.repository);
        } else {
            if (!mergeStatus.isSuccessful()) {
                throw (Throwable)new IllegalStateException(mergeResult.toString());
            }
            updateResult = mergeResult.getResult();
        }
        return updateResult;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ UpdateResult pull$default(Pull pull, MergeStrategy mergeStrategy, String string, Ref ref, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pull");
        }
        if ((n & 1) != 0) {
            ThreeWayMergeStrategy threeWayMergeStrategy = MergeStrategy.RECURSIVE;
            Intrinsics.checkExpressionValueIsNotNull((Object)threeWayMergeStrategy, (String)"MergeStrategy.RECURSIVE");
            mergeStrategy = (MergeStrategy)threeWayMergeStrategy;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            ref = null;
        }
        return pull.pull(mergeStrategy, string, ref);
    }

    @Nullable
    public final Ref fetch(@Nullable RefUpdate.Result prevRefUpdateResult, @Nullable Function1<? super TrackingRefUpdate, Unit> refUpdateProcessor) {
        ProgressIndicator progressIndicator = this.indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        FetchResult fetchResult = GitExKt.fetch(this.repository, this.remoteConfig, this.manager.getCredentialsProvider(), JGitProgressMonitorKt.asProgressMonitor(this.indicator));
        if (fetchResult == null) {
            return null;
        }
        FetchResult fetchResult2 = fetchResult;
        if (IcsManagerKt.getLOG().isDebugEnabled()) {
            GitRepositoryManagerKt.printMessages((OperationResult)fetchResult2);
            for (TrackingRefUpdate refUpdate : fetchResult2.getTrackingRefUpdates()) {
                IcsManagerKt.getLOG().debug(refUpdate.toString());
            }
        }
        ProgressIndicator progressIndicator2 = this.indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.checkCanceled();
        }
        boolean hasChanges = false;
        for (RefSpec fetchRefSpec : this.remoteConfig.getFetchRefSpecs()) {
            TrackingRefUpdate refUpdate = fetchResult2.getTrackingRefUpdate(fetchRefSpec.getDestination());
            if (refUpdate == null) {
                IcsManagerKt.getLOG().debug("No ref update for " + fetchRefSpec);
                continue;
            }
            RefUpdate.Result refUpdateResult = refUpdate.getResult();
            if (Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.LOCK_FAILURE) || Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.IO_FAILURE)) {
                if (Intrinsics.areEqual((Object)prevRefUpdateResult, (Object)refUpdateResult)) {
                    throw (Throwable)new IOException("Ref update result " + refUpdateResult.name() + ", we have already tried to fetch again, but no luck");
                }
                IcsManagerKt.getLOG().warn("Ref update result " + refUpdateResult.name() + ", trying again after 500 ms");
                Thread.sleep(500L);
                return Pull.fetch$default(this, refUpdateResult, null, 2, null);
            }
            if (!(Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.FAST_FORWARD) || Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.NEW) || Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.FORCED))) {
                throw (Throwable)new UnsupportedOperationException("Unsupported ref update result");
            }
            if (!hasChanges) {
                hasChanges = Intrinsics.areEqual((Object)refUpdateResult, (Object)RefUpdate.Result.NO_CHANGE) ^ true;
            }
            Function1<? super TrackingRefUpdate, Unit> function1 = refUpdateProcessor;
            if (function1 == null) continue;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)refUpdate);
        }
        if (!hasChanges) {
            IcsManagerKt.getLOG().debug("No remote changes");
            return null;
        }
        Ref ref = fetchResult2.getAdvertisedRef(GitExKt.getRemoteBranchFullName((Config)this.config));
        if (ref == null) {
            throw (Throwable)new IllegalStateException("Could not get advertised ref");
        }
        return ref;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Ref fetch$default(Pull pull, RefUpdate.Result result, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetch");
        }
        if ((n & 1) != 0) {
            result = null;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        return pull.fetch(result, (Function1<? super TrackingRefUpdate, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final MergeResultEx merge(@NotNull Ref unpeeledRef, @NotNull MergeStrategy mergeStrategy, boolean commit, @NotNull MergeCommand.FastForwardMode fastForwardMode, boolean squash, boolean forceMerge, @Nullable String commitMessage) {
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)unpeeledRef, (String)"unpeeledRef");
        Intrinsics.checkParameterIsNotNull((Object)mergeStrategy, (String)"mergeStrategy");
        Intrinsics.checkParameterIsNotNull((Object)fastForwardMode, (String)"fastForwardMode");
        ProgressIndicator progressIndicator = this.indicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        Ref ref = this.repository.findRef("HEAD");
        if (ref == null) {
            throw (Throwable)new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
        }
        Ref head = ref;
        Ref ref2 = this.repository.peel(unpeeledRef);
        ObjectId objectId = ref2.getPeeledObjectId();
        if (objectId == null) {
            objectId = ref2.getObjectId();
        }
        ObjectId objectId2 = objectId;
        RevWalk revWalk = new RevWalk(this.repository);
        DirCacheCheckout dirCacheCheckout = null;
        try {
            MergeResultEx mergeResultEx;
            ImmutableUpdateResult result;
            ImmutableUpdateResult immutableUpdateResult;
            boolean noProblems;
            String mergeMessage;
            RevCommit srcCommit = revWalk.lookupCommit((AnyObjectId)objectId2);
            ObjectId headId = head.getObjectId();
            if (headId == null) {
                MergeResultEx elements$iv;
                MergeResultEx mergeResultEx2;
                revWalk.parseHeaders((RevObject)srcCommit);
                dirCacheCheckout = new DirCacheCheckout(this.repository, this.repository.lockDirCache(), (ObjectId)srcCommit.getTree());
                dirCacheCheckout.setFailOnConflict(false);
                dirCacheCheckout.checkout();
                RefUpdate refUpdate = this.repository.updateRef(head.getTarget().getName());
                refUpdate.setNewObjectId((AnyObjectId)objectId2);
                refUpdate.setExpectedOldObjectId(null);
                refUpdate.setRefLogMessage("initial pull", false);
                if (Intrinsics.areEqual((Object)refUpdate.update(), (Object)RefUpdate.Result.NEW) ^ true) {
                    throw (Throwable)new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                ObjectId[] objectIdArray = new ObjectId[]{null, (ObjectId)srcCommit};
                MergeResult.MergeStatus mergeStatus = MergeResult.MergeStatus.FAST_FORWARD;
                MergeResultEx mergeResultEx3 = mergeResultEx2;
                MergeResultEx mergeResultEx4 = mergeResultEx2;
                Object[] objectArray = (Object[])elements$iv;
                ObjectId[] objectIdArray2 = (ObjectId[])objectArray;
                Collection collection = dirCacheCheckout.getUpdated().keySet();
                List list = dirCacheCheckout.getRemoved();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dirCacheCheckout.removed");
                mergeResultEx3(mergeStatus, objectIdArray2, new ImmutableUpdateResult(collection, list), null, 8, null);
                elements$iv = mergeResultEx4;
                return elements$iv;
            }
            StringBuilder refLogMessage = new StringBuilder("merge ");
            refLogMessage.append(ref2.getName());
            RevCommit headCommit = revWalk.lookupCommit((AnyObjectId)headId);
            if (!forceMerge && revWalk.isMergedInto(srcCommit, headCommit)) {
                MergeResultEx elements$iv;
                MergeResultEx mergeResultEx5;
                ObjectId[] objectIdArray = new ObjectId[]{(ObjectId)headCommit, (ObjectId)srcCommit};
                MergeResult.MergeStatus mergeStatus = MergeResult.MergeStatus.ALREADY_UP_TO_DATE;
                MergeResultEx mergeResultEx6 = mergeResultEx5;
                MergeResultEx mergeResultEx7 = mergeResultEx5;
                Object[] objectArray = (Object[])elements$iv;
                mergeResultEx6(mergeStatus, (ObjectId[])objectArray, RepositoryManagerKt.getEMPTY_UPDATE_RESULT(), null, 8, null);
                elements$iv = mergeResultEx7;
                return elements$iv;
            }
            if (!forceMerge && Intrinsics.areEqual((Object)fastForwardMode, (Object)MergeCommand.FastForwardMode.NO_FF) ^ true && revWalk.isMergedInto(headCommit, srcCommit)) {
                MergeResultEx elements$iv;
                MergeResultEx mergeResultEx8;
                ObjectId[] squashedCommits;
                MergeResult.MergeStatus mergeStatus;
                refLogMessage.append(": ").append(MergeResult.MergeStatus.FAST_FORWARD);
                dirCacheCheckout = new DirCacheCheckout(this.repository, (ObjectId)headCommit.getTree(), this.repository.lockDirCache(), (ObjectId)srcCommit.getTree());
                dirCacheCheckout.setFailOnConflict(false);
                dirCacheCheckout.checkout();
                if (squash) {
                    mergeStatus = MergeResult.MergeStatus.FAST_FORWARD_SQUASHED;
                    squashedCommits = RevWalkUtils.find((RevWalk)revWalk, (RevCommit)srcCommit, (RevCommit)headCommit);
                    this.repository.writeSquashCommitMsg(new SquashMessageFormatter().format((List)squashedCommits, head));
                } else {
                    RevCommit revCommit = srcCommit;
                    Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"srcCommit");
                    PullKt.access$updateHead(refLogMessage, (ObjectId)revCommit, headId, this.repository);
                    mergeStatus = MergeResult.MergeStatus.FAST_FORWARD;
                }
                squashedCommits = new ObjectId[]{(ObjectId)headCommit, (ObjectId)srcCommit};
                MergeResult.MergeStatus mergeStatus2 = mergeStatus;
                MergeResultEx mergeResultEx9 = mergeResultEx8;
                MergeResultEx mergeResultEx10 = mergeResultEx8;
                Object[] objectArray = (Object[])elements$iv;
                ObjectId[] objectIdArray = (ObjectId[])objectArray;
                Collection collection = dirCacheCheckout.getUpdated().keySet();
                List list = dirCacheCheckout.getRemoved();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dirCacheCheckout.removed");
                mergeResultEx9(mergeStatus2, objectIdArray, new ImmutableUpdateResult(collection, list), null, 8, null);
                elements$iv = mergeResultEx10;
                return elements$iv;
            }
            if (Intrinsics.areEqual((Object)fastForwardMode, (Object)MergeCommand.FastForwardMode.FF_ONLY)) {
                MergeResultEx elements$iv;
                MergeResultEx mergeResultEx11;
                ObjectId[] mergeStatus = new ObjectId[]{(ObjectId)headCommit, (ObjectId)srcCommit};
                MergeResult.MergeStatus mergeStatus3 = MergeResult.MergeStatus.ABORTED;
                MergeResultEx mergeResultEx12 = mergeResultEx11;
                MergeResultEx mergeResultEx13 = mergeResultEx11;
                Object[] objectArray = (Object[])elements$iv;
                mergeResultEx12(mergeStatus3, (ObjectId[])objectArray, RepositoryManagerKt.getEMPTY_UPDATE_RESULT(), null, 8, null);
                elements$iv = mergeResultEx13;
                return elements$iv;
            }
            if (squash) {
                mergeMessage = "";
                this.repository.writeSquashCommitMsg(new SquashMessageFormatter().format(RevWalkUtils.find((RevWalk)revWalk, (RevCommit)srcCommit, (RevCommit)headCommit), head));
            } else {
                mergeMessage = this.commitMessageFormatter.mergeMessage(CollectionsKt.listOf((Object)ref2), head);
                this.repository.writeMergeCommitMsg(mergeMessage);
                this.repository.writeMergeHeads(CollectionsKt.listOf((Object)ref2.getObjectId()));
            }
            Merger merger = mergeStrategy.newMerger(this.repository);
            Map lowLevelResults = null;
            Map failingPaths = null;
            List unmergedPaths = null;
            if (merger instanceof ResolveMerger) {
                void elements$iv;
                String[] stringArray = new String[]{"BASE", "HEAD", ref2.getName()};
                object2 = (ResolveMerger)merger;
                object = (Object[])elements$iv;
                object2.setCommitNames((String[])object);
                ((ResolveMerger)merger).setWorkingTreeIterator((WorkingTreeIterator)new FileTreeIterator(this.repository));
                noProblems = merger.merge(new AnyObjectId[]{(AnyObjectId)headCommit, (AnyObjectId)srcCommit});
                lowLevelResults = ((ResolveMerger)merger).getMergeResults();
                failingPaths = ((ResolveMerger)merger).getFailingPaths();
                unmergedPaths = ((ResolveMerger)merger).getUnmergedPaths();
            } else {
                noProblems = merger.merge(new AnyObjectId[]{(AnyObjectId)headCommit, (AnyObjectId)srcCommit});
            }
            refLogMessage.append(": Merge made by ");
            refLogMessage.append(revWalk.isMergedInto(headCommit, srcCommit) ? "recursive" : mergeStrategy.getName());
            refLogMessage.append('.');
            if (merger instanceof ResolveMerger) {
                Collection collection = ((ResolveMerger)merger).getToBeCheckedOut().keySet();
                List list = ((ResolveMerger)merger).getToBeDeleted();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"merger.toBeDeleted");
                immutableUpdateResult = new ImmutableUpdateResult(collection, list);
            } else {
                immutableUpdateResult = result = null;
            }
            if (noProblems) {
                void elements$iv;
                MergeResultEx mergeResultEx14;
                if (!(merger instanceof ResolveMerger)) {
                    dirCacheCheckout = new DirCacheCheckout(this.repository, (ObjectId)headCommit.getTree(), this.repository.lockDirCache(), merger.getResultTreeId());
                    dirCacheCheckout.setFailOnConflict(false);
                    dirCacheCheckout.checkout();
                    Collection collection = dirCacheCheckout.getUpdated().keySet();
                    List list = dirCacheCheckout.getRemoved();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"dirCacheCheckout.removed");
                    result = new ImmutableUpdateResult(collection, list);
                }
                MergeResult.MergeStatus mergeStatus = null;
                if (!commit && squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED_NOT_COMMITTED;
                }
                if (!commit && !squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_NOT_COMMITTED;
                }
                if (commit && !squash) {
                    GitExKt.commit$default(this.repository, commitMessage, refLogMessage.toString(), null, null, 12, null).getId();
                    mergeStatus = MergeResult.MergeStatus.MERGED;
                }
                if (commit && squash) {
                    mergeStatus = MergeResult.MergeStatus.MERGED_SQUASHED;
                }
                MergeResult.MergeStatus mergeStatus4 = mergeStatus;
                if (mergeStatus4 == null) {
                    Intrinsics.throwNpe();
                }
                Object object3 = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
                MergeResult.MergeStatus mergeStatus5 = mergeStatus4;
                object = mergeResultEx14;
                object2 = mergeResultEx14;
                Object[] objectArray = (Object[])elements$iv;
                ObjectId[] objectIdArray = (ObjectId[])objectArray;
                ImmutableUpdateResult immutableUpdateResult2 = result;
                if (immutableUpdateResult2 == null) {
                    Intrinsics.throwNpe();
                }
                object(mergeStatus5, objectIdArray, immutableUpdateResult2, null, 8, null);
                object3 = object2;
                return object3;
            }
            if (failingPaths == null) {
                Object elements$iv;
                MergeResultEx mergeResultEx15;
                this.repository.writeMergeCommitMsg(new MergeMessageFormatter().formatWithConflicts(mergeMessage, unmergedPaths));
                ObjectId[] mergeStatus = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
                MergeResult.MergeStatus mergeStatus6 = MergeResult.MergeStatus.CONFLICTING;
                object = mergeResultEx15;
                object2 = mergeResultEx15;
                Object[] objectArray = elements$iv;
                ObjectId[] objectIdArray = (ObjectId[])objectArray;
                ImmutableUpdateResult immutableUpdateResult3 = result;
                if (immutableUpdateResult3 == null) {
                    Intrinsics.throwNpe();
                }
                object(mergeStatus6, objectIdArray, immutableUpdateResult3, lowLevelResults);
                elements$iv = object2;
                return elements$iv;
            }
            this.repository.writeMergeCommitMsg(null);
            this.repository.writeMergeHeads(null);
            ObjectId[] elements$iv = new ObjectId[]{headCommit.getId(), srcCommit.getId()};
            MergeResult.MergeStatus mergeStatus = MergeResult.MergeStatus.FAILED;
            object = mergeResultEx;
            object2 = mergeResultEx;
            Object[] objectArray = elements$iv;
            ObjectId[] objectIdArray = (ObjectId[])objectArray;
            ImmutableUpdateResult immutableUpdateResult4 = result;
            if (immutableUpdateResult4 == null) {
                Intrinsics.throwNpe();
            }
            object(mergeStatus, objectIdArray, immutableUpdateResult4, lowLevelResults);
            Object object4 = object2;
            return object4;
        }
        catch (CheckoutConflictException e) {
            Object[] objectArray;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = objectArray;
            Object object5 = dirCacheCheckout;
            if (object5 == null || (object5 = object5.getConflicts()) == null) {
                object = objectArray2;
                object2 = objectArray3;
                List list = CollectionsKt.emptyList();
                objectArray3 = object2;
                objectArray2 = object;
                object5 = list;
            }
            objectArray2((List)object5, e);
            throw (Throwable)objectArray3;
        }
        finally {
            revWalk.close();
        }
    }

    @NotNull
    public static /* bridge */ /* synthetic */ MergeResultEx merge$default(Pull pull, Ref ref, MergeStrategy mergeStrategy, boolean bl, MergeCommand.FastForwardMode fastForwardMode, boolean bl2, boolean bl3, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: merge");
        }
        if ((n & 2) != 0) {
            ThreeWayMergeStrategy threeWayMergeStrategy = MergeStrategy.RECURSIVE;
            Intrinsics.checkExpressionValueIsNotNull((Object)threeWayMergeStrategy, (String)"MergeStrategy.RECURSIVE");
            mergeStrategy = (MergeStrategy)threeWayMergeStrategy;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            fastForwardMode = MergeCommand.FastForwardMode.FF;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        if ((n & 0x40) != 0) {
            string = null;
        }
        return pull.merge(ref, mergeStrategy, bl, fastForwardMode, bl2, bl3, string);
    }

    @NotNull
    public final GitRepositoryClient getManager() {
        return this.manager;
    }

    @Nullable
    public final ProgressIndicator getIndicator() {
        return this.indicator;
    }

    @NotNull
    public final CommitMessageFormatter getCommitMessageFormatter() {
        return this.commitMessageFormatter;
    }

    public Pull(@NotNull GitRepositoryClient manager, @Nullable ProgressIndicator indicator, @NotNull CommitMessageFormatter commitMessageFormatter) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull((Object)commitMessageFormatter, (String)"commitMessageFormatter");
        this.manager = manager;
        this.indicator = indicator;
        this.commitMessageFormatter = commitMessageFormatter;
        this.repository = this.manager.getRepository();
        StoredConfig storedConfig = this.repository.getConfig();
        if (storedConfig == null) {
            Intrinsics.throwNpe();
        }
        this.config = storedConfig;
        this.remoteConfig = new RemoteConfig((Config)this.config, "origin");
    }

    public /* synthetic */ Pull(GitRepositoryClient gitRepositoryClient, ProgressIndicator progressIndicator, CommitMessageFormatter commitMessageFormatter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            commitMessageFormatter = new IdeaCommitMessageFormatter();
        }
        this(gitRepositoryClient, progressIndicator, commitMessageFormatter);
    }
}

