/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.BindingBuildInfo;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import java.lang.annotation.Annotation;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;

public class BuildInfoUtil {
    private static BindingBuildInfo sCached;

    public static BindingBuildInfo load(RoundEnvironment roundEnvironment) {
        if (sCached == null && (sCached = BuildInfoUtil.extractNotNull(roundEnvironment, BindingBuildInfo.class)) != null) {
            L.setDebugLog((boolean)sCached.enableDebugLogs());
            ScopedException.encodeOutput((boolean)sCached.printEncodedError());
        }
        return sCached;
    }

    private static <T extends Annotation> T extractNotNull(RoundEnvironment roundEnv, Class<T> annotationClass) {
        T result = null;
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationClass)) {
            T info = element.getAnnotation(annotationClass);
            if (info == null) continue;
            Preconditions.check((result == null ? 1 : 0) != 0, (String)"Should have only one %s", (Object[])new Object[]{annotationClass.getCanonicalName()});
            result = info;
        }
        return result;
    }
}

