/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.ComparisonExpr;
import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.scopes.ScopeProvider;
import android.databinding.tool.reflection.Callable;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.solver.ExecutionPath;
import android.databinding.tool.util.L;
import android.databinding.tool.writer.KCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MethodCallExpr
extends Expr {
    final String mName;
    Callable mGetter;
    private boolean mAllowProtected;

    static List<Expr> concat(Expr e, List<Expr> list) {
        ArrayList<Expr> merged = new ArrayList<Expr>();
        merged.add(e);
        merged.addAll(list);
        return merged;
    }

    MethodCallExpr(Expr target, String name, List<Expr> args) {
        super(MethodCallExpr.concat(target, args));
        this.mName = name;
    }

    @Override
    public void updateExpr(ModelAnalyzer modelAnalyzer) {
        try {
            Scope.enter((ScopeProvider)this);
            this.resolveType(modelAnalyzer);
            super.updateExpr(modelAnalyzer);
        }
        finally {
            Scope.exit();
        }
    }

    @Override
    protected KCode generateCode() {
        KCode code = new KCode().app("", this.getTarget().toCode()).app(".").app(this.getGetter().name).app("(");
        this.appendArgs(code);
        code.app(")");
        return code;
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.methodCall(this.getTarget().cloneToModel(model), this.mName, MethodCallExpr.cloneToModel(model, this.getArgs()));
    }

    private void appendArgs(KCode code) {
        boolean first = true;
        for (Expr arg : this.getArgs()) {
            if (first) {
                first = false;
            } else {
                code.app(", ");
            }
            code.app("", arg.toCode());
        }
    }

    @Override
    public List<ExecutionPath> toExecutionPath(List<ExecutionPath> paths) {
        List<ExecutionPath> targetPaths = this.getTarget().toExecutionPath(paths);
        ArrayList<ExecutionPath> result = new ArrayList<ExecutionPath>();
        if (this.getTarget() instanceof StaticIdentifierExpr) {
            result.addAll(this.toExecutionPathInOrder(paths, this.getArgs()));
        } else {
            for (ExecutionPath path : targetPaths) {
                ComparisonExpr cmp = this.getModel().comparison("!=", this.getTarget(), this.getModel().symbol("null", Object.class));
                path.addPath(cmp);
                ExecutionPath subPath = path.addBranch(cmp, true);
                if (subPath == null) continue;
                result.addAll(this.toExecutionPathInOrder(subPath, this.getArgs()));
            }
        }
        return result;
    }

    private List<ExecutionPath> toExecutionPathInOrder(ExecutionPath path, List<Expr> args) {
        return this.toExecutionPathInOrder(Arrays.asList(path), args);
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        if (this.mGetter == null) {
            ArrayList<ModelClass> args = new ArrayList<ModelClass>();
            for (Expr expr : this.getArgs()) {
                args.add(expr.getResolvedType());
            }
            Expr target = this.getTarget();
            boolean isStatic = target instanceof StaticIdentifierExpr;
            ModelMethod method = target.getResolvedType().getMethod(this.mName, args, isStatic, this.mAllowProtected);
            if (method == null) {
                StringBuilder argTypes = new StringBuilder();
                for (ModelClass arg : args) {
                    if (argTypes.length() != 0) {
                        argTypes.append(", ");
                    }
                    argTypes.append(arg.toJavaCode());
                }
                String message = "cannot find method '" + this.mName + "(" + argTypes + ")' in class " + target.getResolvedType().toJavaCode();
                IllegalArgumentException e = new IllegalArgumentException(message);
                L.e((Throwable)e, (String)"cannot find method %s(%s) in class %s", (Object[])new Object[]{this.mName, argTypes, target.getResolvedType().toJavaCode()});
                throw e;
            }
            if (!isStatic && method.isStatic()) {
                target.getParents().remove(this);
                this.getChildren().remove(target);
                StaticIdentifierExpr staticId = this.getModel().staticIdentifierFor(target.getResolvedType());
                this.getChildren().add(staticId);
                staticId.getParents().add(this);
                target = this.getTarget();
            }
            int flags = 1;
            if (method.isStatic()) {
                flags |= 4;
            }
            this.mGetter = new Callable(Callable.Type.METHOD, method.getName(), null, method.getReturnType(args), method.getParameterTypes().length, flags, method);
        }
        return this.mGetter.resolvedType;
    }

    @Override
    protected List<Dependency> constructDependencies() {
        List<Dependency> dependencies = this.constructDynamicChildrenDependencies();
        for (Dependency dependency : dependencies) {
            if (dependency.getOther() != this.getTarget()) continue;
            dependency.setMandatory(true);
        }
        return dependencies;
    }

    @Override
    protected String computeUniqueKey() {
        return MethodCallExpr.join(this.getTarget().computeUniqueKey(), this.mName, super.computeUniqueKey());
    }

    public Expr getTarget() {
        return this.getChildren().get(0);
    }

    public String getName() {
        return this.mName;
    }

    public List<Expr> getArgs() {
        return this.getChildren().subList(1, this.getChildren().size());
    }

    public Callable getGetter() {
        return this.mGetter;
    }

    public void setAllowProtected() {
        this.mAllowProtected = true;
    }

    @Override
    public String getInvertibleError() {
        return "Method calls may not be used in two-way expressions";
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getTarget()).append('.').append(this.mName).append('(');
        List<Expr> args = this.getArgs();
        for (int i = 0; i < args.size(); ++i) {
            Expr arg = args.get(i);
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(arg);
        }
        buf.append(')');
        return buf.toString();
    }
}

