/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.gradle.service;

import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.google.common.collect.Maps;
import com.google.gct.login.stats.UsageTrackerService;
import com.google.gct.studio.appengine.gradle.project.IdeaAppEngineProject;
import com.google.gct.studio.appengine.gradle.service.AppEngineGradleProjectSetup;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineGradleProjectDataService
extends AbstractProjectDataService<IdeaAppEngineProject, Void> {
    private static final Logger LOG = Logger.getInstance(AppEngineGradleProjectDataService.class);
    @NotNull
    public static final Key<IdeaAppEngineProject> IDE_APP_ENGINE_PROJECT = Key.create(IdeaAppEngineProject.class, (int)(AndroidProjectKeys.IMPORTED_MODULE.getProcessingWeight() + 10));
    private NotificationGroup myLoggingNotification;

    @NotNull
    public Key<IdeaAppEngineProject> getTargetDataKey() {
        return IDE_APP_ENGINE_PROJECT;
    }

    public void importData(final @NotNull Collection<DataNode<IdeaAppEngineProject>> toImport, @Nullable ProjectData projectData, @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport.isEmpty()) {
            return;
        }
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                Map importModulesMap = AppEngineGradleProjectDataService.indexByModuleName(toImport);
                for (Module module : modelsProvider.getModules()) {
                    if (!importModulesMap.containsKey(module.getName())) continue;
                    AppEngineGradleProjectSetup.addAppEngineGradleFacet((IdeaAppEngineProject)importModulesMap.get(module.getName()), module, modelsProvider);
                    AppEngineGradleProjectSetup.addAppEngineRunConfiguration(module);
                    UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "appengine.gradle.import", null, null);
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            LOG.warn("Failed to set up App Engine Gradle Modules");
            this.syncFailed(project, error.getMessage());
        }
    }

    public void syncFailed(@NotNull Project project, @NotNull String message) {
        String logMsg = "Gradle sync failed";
        if (StringUtil.isNotEmpty((String)message)) {
            logMsg = logMsg + String.format(": %1$s", message);
        }
        this.addToEventLog(project, logMsg, MessageType.ERROR);
    }

    private void addToEventLog(@NotNull Project project, @NotNull String message, @NotNull MessageType type) {
        this.getLoggingNotification().createNotification(message, type).notify(project);
    }

    private synchronized NotificationGroup getLoggingNotification() {
        if (this.myLoggingNotification == null) {
            NotificationGroup registeredGroup = NotificationGroup.findRegisteredGroup((String)"Gradle sync");
            this.myLoggingNotification = registeredGroup != null ? registeredGroup : NotificationGroup.logOnlyGroup((String)"Gradle sync");
        }
        return this.myLoggingNotification;
    }

    @NotNull
    private static Map<String, IdeaAppEngineProject> indexByModuleName(@NotNull Collection<DataNode<IdeaAppEngineProject>> dataNodes) {
        HashMap index = Maps.newHashMap();
        for (DataNode<IdeaAppEngineProject> d : dataNodes) {
            IdeaAppEngineProject appEngineProject = (IdeaAppEngineProject)d.getData();
            index.put(appEngineProject.getModuleName(), appEngineProject);
        }
        return index;
    }
}

