/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.util;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NewFileTracker {
    private final Set<VirtualFile> newFiles = Collections.synchronizedSet(new THashSet());

    public boolean poll(@NotNull VirtualFile file) {
        return this.newFiles.remove(file);
    }

    public NewFileTracker() {
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event.isFromRefresh()) {
                    return;
                }
                NewFileTracker.this.newFiles.add(event.getFile());
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event.isFromRefresh()) {
                    return;
                }
                NewFileTracker.this.newFiles.add(event.getFile());
            }
        });
    }

    public void clear() {
        this.newFiles.clear();
    }
}

