/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.AnalyticsPublisher;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.CommonMetricsData;
import com.android.utils.DateProvider;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.io.CountingOutputStream;
import com.google.wireless.android.play.playlog.proto.ClientAnalytics;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.MetaMetrics;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;

public class GoogleAnalyticsPublisher
extends AnalyticsPublisher {
    private static final Object mGate = new Object();
    static DateProvider sDateProvider = DateProvider.SYSTEM;
    private final Path mSpoolLocation;
    private final ClientAnalytics.LogRequest mBaseLogRequest;
    private final String mApplicationBuild;
    private ScheduledFuture<?> mPublishJob;
    private int mScheduleVersion = 0;
    private URL mServerUrl = GoogleAnalyticsPublisher.getDefaultServerUrl();
    private volatile long mStartTime = sDateProvider.now().getTime();
    private volatile long mBytesSentInLastPublish = 0L;
    private int mFailedConnections = 0;
    private int mFailedServerReplies = 0;
    private int mBackoffRatio = 1;
    Callable<HttpURLConnection> mCreateConnection = this::defaultCreateConnection;
    private ILogger mLogger = new StdLogger(StdLogger.Level.WARNING);

    GoogleAnalyticsPublisher(AnalyticsSettings analyticsSettings, ScheduledExecutorService scheduler, Path spoolLocation, String applicationBuild) {
        super(analyticsSettings, scheduler);
        this.mSpoolLocation = spoolLocation;
        this.mApplicationBuild = applicationBuild;
        this.mBaseLogRequest = ClientAnalytics.LogRequest.newBuilder().setClientInfo(ClientAnalytics.ClientInfo.newBuilder().setClientType(ClientAnalytics.ClientInfo.ClientType.DESKTOP).setDesktopClientInfo(ClientAnalytics.DesktopClientInfo.newBuilder().setLoggingId(analyticsSettings.getUserId()).setApplicationBuild(applicationBuild).setOs(CommonMetricsData.getOsName()).setOsMajorVersion(CommonMetricsData.getMajorOsVersion()).setOsFullVersion(System.getProperty("os.version")))).setLogSource(ClientAnalytics.LogRequest.LogSource.ANDROID_STUDIO).build();
        this.schedulePublish(this.getPublishInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = mGate;
        synchronized (object) {
            ++this.mScheduleVersion;
            this.mPublishJob.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPublishInterval(long interval, TimeUnit unit) {
        Object object = mGate;
        synchronized (object) {
            super.setPublishInterval(interval, unit);
            this.schedulePublish(this.getPublishInterval());
        }
    }

    public void setLogger(ILogger logger) {
        this.mLogger = logger;
    }

    private void publishQueuedAnalytics() {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.mSpoolLocation, "*.trk");){
            for (Path file : stream) {
                if (this.tryPublishAnalytics(file)) continue;
                return;
            }
        }
        catch (Exception e) {
            this.mLogger.error((Throwable)e, "Failure reading analytics spool directory.", new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryPublishAnalytics(Path trackFile) {
        boolean success;
        File file;
        block38: {
            file = trackFile.toFile();
            success = false;
            try (FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
                 FileLock lock = channel.tryLock();){
                if (lock == null) {
                    boolean bl = true;
                    return bl;
                }
                ArrayList<ClientAnalytics.LogEvent> entries = new ArrayList<ClientAnalytics.LogEvent>();
                InputStream inputStream = Channels.newInputStream(channel);
                ClientAnalytics.LogEvent event = null;
                while ((event = ClientAnalytics.LogEvent.parseDelimitedFrom(inputStream)) != null) {
                    entries.add(event);
                }
                if (entries.isEmpty()) {
                    success = true;
                    break block38;
                }
                long now = sDateProvider.now().getTime();
                entries.add(0, this.getMetaMetric(now));
                ClientAnalytics.LogRequest request = this.buildLogRequest(entries, now);
                int responseCode = this.trySendToServer(request);
                success = GoogleAnalyticsPublisher.isSuccess(responseCode);
                if (success) {
                    this.mBackoffRatio = 1;
                    this.mFailedConnections = 0;
                    this.mFailedServerReplies = 0;
                } else {
                    ++this.mFailedServerReplies;
                    this.mBackoffRatio *= 2;
                }
            }
            catch (IOException e) {
                this.mLogger.error((Throwable)e, "Failure publishing analytics, unable to connect to server", new Object[0]);
                ++this.mFailedConnections;
                this.mBackoffRatio *= 2;
                return false;
            }
            catch (OverlappingFileLockException e) {
                return true;
            }
        }
        if (!success) return success;
        file.delete();
        return success;
    }

    private HttpURLConnection defaultCreateConnection() throws IOException {
        URLConnection connection = this.mServerUrl.openConnection();
        if (connection instanceof HttpURLConnection) {
            return (HttpURLConnection)connection;
        }
        this.mLogger.error(null, "Unexpected connection type %s", new Object[]{connection.getClass().getName()});
        return null;
    }

    public void setCreateConnection(Callable<HttpURLConnection> createConnection) {
        this.mCreateConnection = createConnection;
    }

    private int trySendToServer(ClientAnalytics.LogRequest request) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = this.mCreateConnection.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (connection == null) {
            return 405;
        }
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Encoding", "gzip");
        byte[] requestBytes = request.toByteArray();
        try (OutputStream output = connection.getOutputStream();
             BufferedOutputStream buffered = new BufferedOutputStream(output);
             CountingOutputStream counted = new CountingOutputStream((OutputStream)buffered);){
            try (GZIPOutputStream zipped = new GZIPOutputStream((OutputStream)counted, true);){
                zipped.write(requestBytes);
            }
            this.mBytesSentInLastPublish = counted.getCount();
        }
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (!GoogleAnalyticsPublisher.isSuccess(responseCode)) {
            this.mLogger.error(null, "Failure publishing metrics. Server responded with status code '%d' and message '%s'", new Object[]{responseCode, connection.getResponseMessage()});
        }
        return responseCode;
    }

    private ClientAnalytics.LogRequest buildLogRequest(List<ClientAnalytics.LogEvent> entries, long time) {
        return ClientAnalytics.LogRequest.newBuilder(this.mBaseLogRequest).setRequestTimeMs(time).setRequestUptimeMs(time - this.mStartTime).addAllLogEvent(entries).build();
    }

    private ClientAnalytics.LogEvent getMetaMetric(long time) {
        return ClientAnalytics.LogEvent.newBuilder().setEventTimeMs(time).setSourceExtension(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.META).setKind(AndroidStudioEvent.EventKind.META_METRICS).setMetaMetrics(MetaMetrics.newBuilder().setBytesSentInLastUpload(this.mBytesSentInLastPublish).setFailedConnections(this.mFailedConnections).setFailedServerReplies(this.mFailedServerReplies)).build().toByteString()).build();
    }

    private void schedulePublish(long publishIntervalNanoSeconds) {
        int currentScheduleVersion = ++this.mScheduleVersion;
        if (this.mPublishJob != null) {
            this.mPublishJob.cancel(false);
        }
        this.mPublishJob = this.getScheduler().schedule(() -> {
            Object object = mGate;
            synchronized (object) {
                this.publishQueuedAnalytics();
                if (this.mScheduleVersion == currentScheduleVersion) {
                    this.schedulePublish(publishIntervalNanoSeconds);
                }
            }
        }, Math.min(publishIntervalNanoSeconds * (long)this.mBackoffRatio, TimeUnit.DAYS.toNanos(1L)), TimeUnit.NANOSECONDS);
    }

    private static URL getDefaultServerUrl() {
        try {
            return new URL("https://play.google.com/log?format=raw");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getServerUrl() {
        return this.mServerUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GoogleAnalyticsPublisher setServerUrl(URL serverUrl) {
        Object object = mGate;
        synchronized (object) {
            this.mServerUrl = serverUrl;
        }
        return this;
    }

    private static boolean isSuccess(int statusCode) {
        return 200 <= statusCode && statusCode < 300;
    }
}

