/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.NamespaceDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/DetectMissingPrefix;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableAttributes", "", "", "isCustomView", "element", "Lorg/w3c/dom/Element;", "isFragment", "isNoPrefixAttribute", "attribute", "visitAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "Lorg/w3c/dom/Attr;", "Issues", "lint-checks"})
public final class DetectMissingPrefix
extends LayoutDetector {
    @JvmField
    public static final Issue MISSING_NAMESPACE;
    public static final Issues Issues;

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkParameterIsNotNull((Object)folderType, (String)"folderType");
        return Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.LAYOUT) || Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.MENU) || Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.DRAWABLE) || Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.ANIM) || Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.ANIMATOR) || Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.COLOR) || Intrinsics.areEqual((Object)folderType, (Object)ResourceFolderType.INTERPOLATOR);
    }

    @Override
    @Nullable
    public Collection<String> getApplicableAttributes() {
        return Detector.XmlScanner.ALL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNoPrefixAttribute(String attribute) {
        String string = attribute;
        switch (string.hashCode()) {
            case -1109722326: {
                if (!string.equals("layout")) return false;
                return true;
            }
            case -807062458: {
                if (!string.equals("package")) return false;
                return true;
            }
            case 109780401: {
                if (!string.equals("style")) return false;
                return true;
            }
            case 954743298: {
                if (!string.equals("coreApp")) return false;
                return true;
            }
            case 94742904: {
                if (!string.equals("class")) return false;
                return true;
            }
        }
        return false;
    }

    @Override
    public void visitAttribute(@NotNull XmlContext context, @NotNull Attr attribute) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attribute, (String)"attribute");
        String uri = attribute.getNamespaceURI();
        if (uri == null || (charSequence = (CharSequence)uri).length() == 0) {
            CharSequence charSequence2;
            Element root;
            Element element;
            String string = attribute.getName();
            if (string == null) {
                return;
            }
            String name = string;
            if (this.isNoPrefixAttribute(name)) {
                return;
            }
            Element element2 = element = attribute.getOwnerElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
            if (this.isCustomView(element2) && context.getResourceFolderType() != null) {
                return;
            }
            if (Intrinsics.areEqual((Object)context.getResourceFolderType(), (Object)ResourceFolderType.LAYOUT) && Intrinsics.areEqual((Object)"layout", (Object)(root = element.getOwnerDocument().getDocumentElement()).getTagName())) {
                return;
            }
            if (StringsKt.indexOf$default((CharSequence)name, (char)':', (int)0, (boolean)false, (int)6, null) != -1) {
                return;
            }
            String elementNamespace = element.getNamespaceURI();
            if (elementNamespace != null && !((charSequence2 = (CharSequence)elementNamespace).length() == 0)) {
                return;
            }
            Issue issue = MISSING_NAMESPACE;
            Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"MISSING_NAMESPACE");
            XmlContext.report$default(context, issue, attribute, context.getLocation(attribute), "Attribute is missing the Android namespace prefix", null, 16, null);
        } else if (Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res/android", (Object)uri) ^ true && Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)uri) ^ true && Intrinsics.areEqual((Object)context.getResourceFolderType(), (Object)ResourceFolderType.LAYOUT)) {
            Element element = attribute.getOwnerElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"attribute.ownerElement");
            if (!this.isCustomView(element)) {
                Element element3 = attribute.getOwnerElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"attribute.ownerElement");
                if (!this.isFragment(element3) && !StringsKt.startsWith$default((String)attribute.getLocalName(), (String)"layout_", (boolean)false, (int)2, null) && attribute.getOwnerElement().getParentNode().getNodeType() == 1) {
                    Node node = attribute.getOwnerElement().getParentNode();
                    if (node == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.Element");
                    }
                    if (!this.isCustomView((Element)node)) {
                        String prefix;
                        if (Intrinsics.areEqual((Object)context.getResourceFolderType(), (Object)ResourceFolderType.LAYOUT) && Intrinsics.areEqual((Object)"http://schemas.android.com/apk/res-auto", (Object)uri)) {
                            List items;
                            Element root = attribute.getOwnerDocument().getDocumentElement();
                            if (Intrinsics.areEqual((Object)"layout", (Object)root.getTagName())) {
                                return;
                            }
                            if (Intrinsics.areEqual((Object)attribute.getLocalName(), (Object)"srcCompat")) {
                                return;
                            }
                            Project project = context.getMainProject();
                            LintClient client = context.getClient();
                            AbstractResourceRepository repository = client.getResourceRepository(project, true, true);
                            if (repository != null && (items = repository.getResourceItem(ResourceType.ATTR, attribute.getLocalName())) != null && !items.isEmpty()) {
                                for (ResourceItem item : items) {
                                    String libraryName = item.getLibraryName();
                                    if (libraryName == null || !StringsKt.startsWith$default((String)libraryName, (String)"appcompat-", (boolean)false, (int)2, null)) continue;
                                    return;
                                }
                            }
                        }
                        if (Intrinsics.areEqual((Object)"xmlns", (Object)(prefix = attribute.getPrefix()))) {
                            String name = attribute.getNodeName();
                            Element root = attribute.getOwnerDocument().getDocumentElement();
                            NamedNodeMap attributes = root.getAttributes();
                            int n = attributes.getLength();
                            for (int i = 0; i < n; ++i) {
                                String string;
                                Issue issue;
                                Node item = attributes.item(i);
                                if (!Intrinsics.areEqual((Object)name, (Object)item.getNodeName()) || !Intrinsics.areEqual((Object)attribute.getValue(), (Object)item.getNodeValue())) continue;
                                Intrinsics.checkExpressionValueIsNotNull((Object)NamespaceDetector.UNUSED, (String)"NamespaceDetector.UNUSED");
                                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                                String string2 = "Unused namespace declaration %1$s; already declared on the root element";
                                Object[] objectArray = new Object[]{name};
                                Location location = context.getLocation(attribute);
                                Node node2 = attribute;
                                XmlContext xmlContext = context;
                                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                                XmlContext.report$default(xmlContext, issue, node2, location, string, null, 16, null);
                            }
                            return;
                        }
                        Issue issue = MISSING_NAMESPACE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"MISSING_NAMESPACE");
                        XmlContext.report$default(context, issue, attribute, context.getLocation(attribute), "Unexpected namespace prefix " + "\"" + prefix + "\"" + " found for tag `" + attribute.getOwnerElement().getTagName() + "`", null, 16, null);
                    }
                }
            }
        }
    }

    private final boolean isFragment(Element element) {
        return Intrinsics.areEqual((Object)"fragment", (Object)element.getTagName());
    }

    private final boolean isCustomView(Element element) {
        String tag = element.getTagName();
        if (Intrinsics.areEqual((Object)tag, (Object)"view")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)"android.support.constraint.ConstraintLayout", (Object)tag) || Intrinsics.areEqual((Object)"android.support.constraint.Guideline", (Object)tag)) {
            return false;
        }
        return StringsKt.indexOf$default((CharSequence)tag, (char)'.', (int)0, (boolean)false, (int)6, null) != -1 && (!StringsKt.startsWith$default((String)tag, (String)"android.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)tag, (String)"android.support.", (boolean)false, (int)2, null));
    }

    static {
        Issues = new Issues(null);
        MISSING_NAMESPACE = Issue.create("MissingPrefix", "Missing Android XML namespace", "\nMost Android views have attributes in the Android namespace. When referencing these attributes \\\nyou **must** include the namespace prefix, or your attribute will be interpreted by `aapt` as \\\njust a custom attribute.\n\nSimilarly, in manifest files, nearly all attributes should be in the `android:` namespace.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(DetectMissingPrefix.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, Scope.MANIFEST_SCOPE, Scope.RESOURCE_FILE_SCOPE));
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/DetectMissingPrefix$Issues;", "", "()V", "MISSING_NAMESPACE", "Lcom/android/tools/lint/detector/api/Issue;", "kotlin.jvm.PlatformType", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

