/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.CharSequences;
import com.google.common.annotations.Beta;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.w3c.dom.Node;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J*\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020)2\b\u00103\u001a\u0004\u0018\u000104H\u0004J \u00105\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020)H\u0002J\n\u00108\u001a\u0004\u0018\u00010\nH\u0016J\u0006\u00109\u001a\u00020\u0005J\u000e\u0010:\u001a\u00020\u00152\u0006\u0010.\u001a\u00020/J\u0016\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020/J3\u0010=\u001a\u00020-2\b\u0010>\u001a\u0004\u0018\u00010?2\b\u0010@\u001a\u0004\u0018\u00010)2\u0012\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010B\"\u00020\u0001\u00a2\u0006\u0002\u0010CJ,\u0010D\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020)2\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0017J*\u0010D\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020)2\b\u00103\u001a\u0004\u0018\u00010\u0001H\u0007J\u001e\u0010E\u001a\u00020-2\u0006\u0010F\u001a\u00020G2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0016\u0010(\u001a\u0004\u0018\u00010)8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006H"}, d2={"Lcom/android/tools/lint/detector/api/Context;", "", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "mainProject", "file", "Ljava/io/File;", "contents", "", "(Lcom/android/tools/lint/client/api/LintDriver;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Project;Ljava/io/File;Ljava/lang/CharSequence;)V", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getClient", "()Lcom/android/tools/lint/client/api/LintClient;", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "getConfiguration", "()Lcom/android/tools/lint/client/api/Configuration;", "containsCommentSuppress", "", "Ljava/lang/Boolean;", "getDriver", "()Lcom/android/tools/lint/client/api/LintDriver;", "phase", "", "getPhase", "()I", "getProject", "()Lcom/android/tools/lint/detector/api/Project;", "scope", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "getScope", "()Ljava/util/EnumSet;", "sdkInfo", "Lcom/android/tools/lint/client/api/SdkInfo;", "getSdkInfo", "()Lcom/android/tools/lint/client/api/SdkInfo;", "suppressCommentPrefix", "", "getSuppressCommentPrefix", "()Ljava/lang/String;", "doReport", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "quickfixData", "Lcom/android/tools/lint/detector/api/LintFix;", "findPrefixOnPreviousLine", "lineStart", "prefix", "getContents", "getMainProject", "isEnabled", "isSuppressedWithComment", "startOffset", "log", "exception", "", "format", "args", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "report", "requestRepeat", "detector", "Lcom/android/tools/lint/detector/api/Detector;", "lint-api"})
@Beta
public class Context {
    @NotNull
    private final Configuration configuration;
    private Boolean containsCommentSuppress;
    @NotNull
    private final LintDriver driver;
    @NotNull
    private final Project project;
    private final Project mainProject;
    @JvmField
    @NotNull
    public final File file;
    private CharSequence contents;

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final EnumSet<Scope> getScope() {
        return this.driver.getScope();
    }

    @NotNull
    public final Project getMainProject() {
        Project project = this.mainProject;
        if (project == null) {
            project = this.project;
        }
        return project;
    }

    @NotNull
    public final LintClient getClient() {
        return this.driver.getClient();
    }

    @Nullable
    public CharSequence getContents() {
        if (this.contents == null) {
            this.contents = this.driver.getClient().readFile(this.file);
        }
        return this.contents;
    }

    @NotNull
    public final SdkInfo getSdkInfo() {
        SdkInfo sdkInfo = this.project.getSdkInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkInfo, (String)"project.getSdkInfo()");
        return sdkInfo;
    }

    public final boolean isEnabled(@NotNull Issue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        return this.configuration.isEnabled(issue);
    }

    @JvmOverloads
    public void report(@NotNull Issue issue, @NotNull Location location, @NotNull String message, @Nullable LintFix quickfixData) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Object source = location.getSource();
        if (source instanceof Node) {
            if (this instanceof XmlContext && ((Node)source).getOwnerDocument() == ((XmlContext)this).document) {
                ((XmlContext)this).report(issue, (Node)source, location, message, quickfixData);
                return;
            }
            if (this.driver.isSuppressed(null, issue, (Node)source)) {
                return;
            }
        } else if (source instanceof PsiElement) {
            if (this instanceof JavaContext) {
                Context javaContext = this;
                if (Intrinsics.areEqual((Object)((PsiElement)source).getContainingFile(), (Object)((JavaContext)javaContext).getPsiFile())) {
                    ((JavaContext)javaContext).report(issue, (PsiElement)source, location, message, quickfixData);
                    return;
                }
            }
            if (this.driver.isSuppressed(null, issue, (PsiElement)source)) {
                return;
            }
        } else if (source instanceof UElement) {
            PsiElement element = ((UElement)source).getPsi();
            if (element != null && this instanceof JavaContext) {
                Context javaContext = this;
                if (Intrinsics.areEqual((Object)element.getContainingFile(), (Object)((JavaContext)javaContext).getPsiFile())) {
                    ((JavaContext)javaContext).report(issue, element, location, message, quickfixData);
                    return;
                }
            }
            if (this.driver.isSuppressed(null, issue, element)) {
                return;
            }
        }
        this.doReport(issue, location, message, quickfixData);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void report$default(Context context, Issue issue, Location location, String string, LintFix lintFix, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 8) != 0) {
            lintFix = null;
        }
        context.report(issue, location, string, lintFix);
    }

    @JvmOverloads
    public void report(@NotNull Issue issue, @NotNull Location location, @NotNull String message) {
        Context.report$default(this, issue, location, message, null, 8, null);
    }

    @Deprecated(message="Here for temporary compatibility; the new typed quickfix data parameter should be used instead", replaceWith=@ReplaceWith(imports={}, expression="report(issue, location, message)"))
    public final void report(@NotNull Issue issue, @NotNull Location location, @NotNull String message, @Nullable Object quickfixData) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Context.report$default(this, issue, location, message, null, 8, null);
    }

    protected final void doReport(@NotNull Issue issue, @NotNull Location location, @NotNull String message, @Nullable LintFix quickfixData) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (location == null) {
            boolean bl = false;
            if (_Assertions.ENABLED && !bl) {
                Issue issue2 = issue;
                throw (Throwable)((Object)new AssertionError(issue2));
            }
            return;
        }
        if (location == Location.NONE) {
            return;
        }
        Configuration configuration = this.configuration;
        Project project = this.driver.findProjectFor(location.getFile());
        if (project != null) {
            Configuration configuration2 = project.getConfiguration(this.driver);
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"project.getConfiguration(driver)");
            configuration = configuration2;
        }
        if (configuration != this.configuration && this.configuration.getSeverity(issue) == Severity.IGNORE) {
            return;
        }
        Severity severity = configuration.getSeverity(issue);
        if (severity == Severity.IGNORE) {
            return;
        }
        LintClient lintClient = this.driver.getClient();
        Severity severity2 = severity;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)severity2), (String)"severity");
        lintClient.report(this, issue, severity2, location, message, TextFormat.RAW, quickfixData);
    }

    public final void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        this.driver.getClient().log(exception, format, Arrays.copyOf(args, args.length));
    }

    public final int getPhase() {
        return this.driver.getPhase();
    }

    public final void requestRepeat(@NotNull Detector detector, @Nullable EnumSet<Scope> scope) {
        Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
        this.driver.requestRepeat(detector, scope);
    }

    @Nullable
    protected String getSuppressCommentPrefix() {
        String path2 = this.file.getPath();
        if (StringsKt.endsWith$default((String)path2, (String)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".gradle", (boolean)false, (int)2, null)) {
            return "//noinspection ";
        }
        if (StringsKt.endsWith$default((String)path2, (String)".xml", (boolean)false, (int)2, null)) {
            return "<!--suppress ";
        }
        if (StringsKt.endsWith$default((String)path2, (String)".cfg", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path2, (String)".pro", (boolean)false, (int)2, null)) {
            return "#suppress ";
        }
        return null;
    }

    public final boolean containsCommentSuppress() {
        if (this.containsCommentSuppress == null) {
            CharSequence contents;
            this.containsCommentSuppress = false;
            String prefix = this.getSuppressCommentPrefix();
            if (prefix != null && (contents = this.getContents()) != null) {
                this.containsCommentSuppress = CharSequences.indexOf((CharSequence)contents, (CharSequence)prefix) != -1;
            }
        }
        Boolean bl = this.containsCommentSuppress;
        if (bl == null) {
            Intrinsics.throwNpe();
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSuppressedWithComment(int startOffset, @NotNull Issue issue) {
        String $receiver$iv;
        CharSequence contents;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        String string = this.getSuppressCommentPrefix();
        if (string == null) return false;
        String prefix = string;
        if (startOffset <= 0) {
            return false;
        }
        CharSequence charSequence = this.getContents();
        if (charSequence == null) {
            charSequence = contents = (CharSequence)"";
        }
        if (startOffset >= contents.length()) {
            return false;
        }
        int lineStart = StringsKt.lastIndexOf$default((CharSequence)contents, (char)'\n', (int)startOffset, (boolean)false, (int)4, null) + 1;
        if (lineStart <= 1) {
            return false;
        }
        int index = this.findPrefixOnPreviousLine(contents, lineStart, prefix);
        if (index == -1) return false;
        if (index + prefix.length() >= lineStart) return false;
        String line = ((Object)contents.subSequence(index + prefix.length(), lineStart)).toString();
        CharSequence charSequence2 = line;
        String string2 = issue.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"issue.id");
        if (StringsKt.contains$default((CharSequence)charSequence2, (CharSequence)string2, (boolean)false, (int)2, null)) return true;
        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"all", (boolean)false, (int)2, null)) return false;
        String string3 = $receiver$iv = line;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        CharSequence $receiver$iv$iv = string3;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $receiver$iv$iv.charAt(index$iv$iv);
            boolean bl = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (!StringsKt.startsWith$default((String)((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (String)"all", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final int findPrefixOnPreviousLine(CharSequence contents, int lineStart, String prefix) {
        char first = prefix.charAt(0);
        boolean seenNonWhitespace = false;
        for (int offset = lineStart - 2; offset >= 0; --offset) {
            char c = contents.charAt(offset);
            if (seenNonWhitespace && c == '\n') {
                return -1;
            }
            if (!seenNonWhitespace && !Character.isWhitespace(c)) {
                seenNonWhitespace = true;
            }
            if (c != first || !CharSequences.regionMatches((CharSequence)contents, (int)offset, (CharSequence)prefix, (int)0, (int)prefix.length())) continue;
            return offset;
        }
        return -1;
    }

    @NotNull
    public final LintDriver getDriver() {
        return this.driver;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public Context(@NotNull LintDriver driver, @NotNull Project project, @Nullable Project mainProject, @NotNull File file, @Nullable CharSequence contents) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.driver = driver;
        this.project = project;
        this.mainProject = mainProject;
        this.file = file;
        this.contents = contents;
        Configuration configuration = this.project.getConfiguration(this.driver);
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"project.getConfiguration(driver)");
        this.configuration = configuration;
    }

    public /* synthetic */ Context(LintDriver lintDriver, Project project, Project project2, File file, CharSequence charSequence, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            charSequence = null;
        }
        this(lintDriver, project, project2, file, charSequence);
    }
}

