/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.memoryanalyzer;

import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalysisResultEntry;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalyzerTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LeakedActivityAnalyzerTask
extends MemoryAnalyzerTask {
    @Override
    protected List<AnalysisResultEntry<?>> analyze(MemoryAnalyzerTask.Configuration configuration, Snapshot snapshot) {
        ArrayList<Instance> leakingInstances = new ArrayList<Instance>();
        List<ClassObj> activityClasses = snapshot.findAllDescendantClasses("android.app.Activity");
        for (ClassObj activityClass : activityClasses) {
            ArrayList<Instance> instances = new ArrayList<Instance>();
            for (Heap heap : configuration.mHeaps) {
                instances.addAll(activityClass.getHeapInstances(heap.getId()));
            }
            block2: for (Instance instance : instances) {
                Instance immediateDominator = instance.getImmediateDominator();
                if (!(instance instanceof ClassInstance) || immediateDominator == null) continue;
                for (ClassInstance.FieldValue value : ((ClassInstance)instance).getValues()) {
                    if (!"mFinished".equals(value.getField().getName()) && !"mDestroyed".equals(value.getField().getName()) || instance.getDistanceToGcRoot() == Integer.MAX_VALUE || !(value.getValue() instanceof Boolean) || !((Boolean)value.getValue()).booleanValue()) continue;
                    leakingInstances.add(instance);
                    continue block2;
                }
            }
        }
        ArrayList results = new ArrayList(leakingInstances.size());
        for (Instance instance : leakingInstances) {
            results.add(new LeakedActivityEntry(instance.getClassObj().getClassName(), instance));
        }
        return results;
    }

    @Override
    public String getTaskName() {
        return "Detect Leaked Activities";
    }

    @Override
    public String getTaskDescription() {
        return "Detects leaked activities in Android applications.";
    }

    public static class LeakedActivityEntry
    extends MemoryAnalysisResultEntry {
        private LeakedActivityEntry(String offenseDescription, Instance offendingInstance) {
            super(offenseDescription, Collections.singletonList(offendingInstance));
        }

        @Override
        public String getWarningMessage() {
            return this.mOffender.getOffendingDescription();
        }

        @Override
        public String getCategory() {
            return "Leaked Activities";
        }
    }
}

