/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.google.common.collect.Maps;
import com.google.gct.testing.android.CloudConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudProjectIdLabel
extends JBLabel {
    private static final String CLOUD_PROJECT_PROMPT = "Please select a project...";
    private final CloudConfiguration.Kind myConfigurationKind;
    private int myCurrentConfigurationId = -1;
    private Module myCurrentModule;
    private static Map<CloudConfiguration.Kind, String> myLastChosenProjectIdPerKind = Maps.newHashMapWithExpectedSize((int)5);
    private static Map<Integer, Map<Pair<CloudConfiguration.Kind, Module>, String>> myProjectByConfigurationIdAndModuleCache = Maps.newHashMapWithExpectedSize((int)5);

    public CloudProjectIdLabel(@NotNull CloudConfiguration.Kind configurationKind) {
        this.myConfigurationKind = configurationKind;
        this.updateCloudProjectId(CLOUD_PROJECT_PROMPT);
    }

    @NotNull
    public String getProjectId() {
        return this.isProjectSpecified() ? this.getText() : "";
    }

    public boolean isProjectSpecified() {
        return !this.getText().isEmpty() && !this.getText().equals(CLOUD_PROJECT_PROMPT);
    }

    public void updateCloudProjectId(@NotNull String cloudProjectId) {
        if (cloudProjectId.isEmpty() || cloudProjectId.equals(CLOUD_PROJECT_PROMPT)) {
            Font currentFont = this.getFont();
            this.setFont(new Font("Dialog", 1, currentFont.getSize()));
            this.setForeground((Color)JBColor.RED);
            this.setText(CLOUD_PROJECT_PROMPT);
        } else {
            Font currentFont = this.getFont();
            this.setFont(new Font("Dialog", 0, currentFont.getSize()));
            this.setForeground((Color)JBColor.BLACK);
            this.setText(cloudProjectId);
        }
        this.rememberChosenProjectId();
    }

    public void setFacet(@Nullable AndroidFacet facet) {
        if (facet == null) {
            return;
        }
        this.myCurrentModule = facet.getModule();
        this.restoreChosenProjectId();
    }

    public void setRunConfigurationId(int configurationId) {
        this.myCurrentConfigurationId = configurationId;
    }

    private void rememberChosenProjectId() {
        if (this.isProjectSpecified()) {
            myLastChosenProjectIdPerKind.put(this.myConfigurationKind, this.getText());
        }
        if (this.myCurrentConfigurationId == -1 || this.myCurrentModule == null) {
            return;
        }
        HashMap projectByModuleCache = myProjectByConfigurationIdAndModuleCache.get(this.myCurrentConfigurationId);
        if (projectByModuleCache == null) {
            projectByModuleCache = Maps.newHashMapWithExpectedSize((int)5);
            myProjectByConfigurationIdAndModuleCache.put(this.myCurrentConfigurationId, projectByModuleCache);
        }
        projectByModuleCache.put(Pair.create((Object)((Object)this.myConfigurationKind), (Object)this.myCurrentModule), this.getText());
    }

    public void restoreChosenProjectId() {
        String projectId;
        if (this.myCurrentConfigurationId == -1 || this.myCurrentModule == null) {
            String lastChosenProjectId = myLastChosenProjectIdPerKind.get((Object)this.myConfigurationKind);
            if (lastChosenProjectId != null) {
                this.updateCloudProjectId(lastChosenProjectId);
            }
            return;
        }
        Map<Pair<CloudConfiguration.Kind, Module>, String> projectByModuleCache = myProjectByConfigurationIdAndModuleCache.get(this.myCurrentConfigurationId);
        if (projectByModuleCache != null && (projectId = projectByModuleCache.get(Pair.create((Object)((Object)this.myConfigurationKind), (Object)this.myCurrentModule))) != null) {
            this.updateCloudProjectId(projectId);
        }
    }
}

