/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchCompatibilityCheckerImpl;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetPickerDialog;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.ShowChooserTargetProvider;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.android.CloudMatrixTestRunningState;
import com.google.gct.testing.android.CloudTargetUtil;
import com.google.gct.testing.android.CloudTestMatrixTargetConfigurable;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudTestMatrixTargetProvider
extends DeployTargetProvider {
    @NotNull
    public String getId() {
        return TargetSelectionMode.FIREBASE_DEVICE_MATRIX.name();
    }

    @NotNull
    public String getDisplayName() {
        return "Firebase Test Lab Device Matrix";
    }

    @NotNull
    public DeployTargetState createState() {
        return new State();
    }

    public DeployTargetConfigurable createConfigurable(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        return new CloudTestMatrixTargetConfigurable(project, parentDisposable, context);
    }

    public boolean showInDevicePicker(@NotNull Executor executor) {
        return !(executor instanceof DefaultDebugExecutor);
    }

    public boolean isApplicable(boolean isTestConfig) {
        return isTestConfig;
    }

    public DeployTarget getDeployTarget() {
        return new DeployTarget(){

            public boolean hasCustomRunProfileState(@NotNull Executor executor) {
                return !(executor instanceof DefaultDebugExecutor);
            }

            public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull DeployTargetState state) throws ExecutionException {
                RunProfile runProfile = env.getRunProfile();
                if (!(runProfile instanceof AndroidTestRunConfiguration)) {
                    return null;
                }
                AndroidTestRunConfiguration runConfiguration = (AndroidTestRunConfiguration)runProfile;
                AndroidFacet facet = AndroidFacet.getInstance((Module)((JavaRunConfigurationModule)runConfiguration.getConfigurationModule()).getModule());
                State cloudTargetState = (State)state;
                return new CloudMatrixTestRunningState(env, facet, runConfiguration, cloudTargetState.SELECTED_CLOUD_MATRIX_CONFIGURATION_ID, cloudTargetState.SELECTED_CLOUD_MATRIX_PROJECT_ID);
            }

            @Nullable
            public DeviceFutures getDevices(@NotNull DeployTargetState state, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, boolean debug, int runConfigId) {
                List deployTargetProviders = Collections.emptyList();
                HashMap<String, ShowChooserTargetProvider.State> deployTargetStates = new HashMap<String, ShowChooserTargetProvider.State>();
                deployTargetStates.put(ShowChooserTargetProvider.ID, new ShowChooserTargetProvider.State());
                DeployTargetPickerDialog dialog = new DeployTargetPickerDialog(runConfigId, facet, deviceCount, deployTargetProviders, deployTargetStates, LaunchCompatibilityCheckerImpl.create((AndroidFacet)facet));
                if (dialog.showAndGet()) {
                    return dialog.getSelectedDeployTarget().getDevices(state, facet, deviceCount, debug, runConfigId);
                }
                return null;
            }
        };
    }

    public static final class State
    extends DeployTargetState {
        public int SELECTED_CLOUD_MATRIX_CONFIGURATION_ID = -1;
        public String SELECTED_CLOUD_MATRIX_PROJECT_ID = "";

        @NotNull
        public List<ValidationError> validate(@NotNull AndroidFacet facet) {
            return CloudTargetUtil.validate(facet, CloudConfiguration.Kind.MATRIX, this.SELECTED_CLOUD_MATRIX_PROJECT_ID, this.SELECTED_CLOUD_MATRIX_CONFIGURATION_ID);
        }
    }
}

