/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.dimension;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.api.services.testing.model.AndroidDeviceCatalog;
import com.google.api.services.testing.model.AndroidVersion;
import com.google.api.services.testing.model.Date;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.gct.testing.CloudConfigurationImpl;
import com.google.gct.testing.dimension.CloudConfigurationDimension;
import com.google.gct.testing.dimension.CloudTestingType;
import com.google.gct.testing.launcher.CloudAuthenticator;
import icons.AndroidIcons;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;

public class ApiDimension
extends CloudConfigurationDimension {
    public static final String DISPLAY_NAME = "Platform";
    private static ImmutableList<ApiLevel> FULL_DOMAIN;
    private static ApiLevel defaultApi;
    private final int minSdkVersion;
    private static final Comparator<ApiLevel> API_LEVEL_COMPARATOR;

    public ApiDimension(CloudConfigurationImpl googleCloudTestingConfiguration, AndroidFacet facet) {
        super(googleCloudTestingConfiguration);
        this.minSdkVersion = AndroidModuleInfo.getInstance((AndroidFacet)facet).getMinSdkVersion().getApiLevel();
    }

    @VisibleForTesting
    public ApiDimension(CloudConfigurationImpl googleCloudTestingConfiguration, int minSdkVersion) {
        super(googleCloudTestingConfiguration);
        this.minSdkVersion = minSdkVersion;
    }

    @Override
    public List<? extends CloudTestingType> getAppSupportedDomain() {
        return Lists.newArrayList((Iterable)ApiDimension.getFullDomain().stream().filter(input -> {
            if (input instanceof ApiLevel) {
                return ((ApiLevel)input).apiVersion >= this.minSdkVersion;
            }
            return false;
        }).collect(Collectors.toList()));
    }

    @Override
    public List<? extends CloudTestingType> getSupportedDomain() {
        return this.getAppSupportedDomain();
    }

    public static List<? extends CloudTestingType> getFullDomain() {
        if (ApiDimension.isFullDomainMissing() || ApiDimension.shouldPollDiscoveryTestApi(DISPLAY_NAME)) {
            LinkedList<ApiLevel> apiLevels = new LinkedList<ApiLevel>();
            AndroidDeviceCatalog androidDeviceCatalog = CloudAuthenticator.getInstance().getAndroidDeviceCatalog();
            if (androidDeviceCatalog != null) {
                for (AndroidVersion version : androidDeviceCatalog.getVersions()) {
                    HashMap<String, String> details = new HashMap<String, String>();
                    Date date = version.getReleaseDate();
                    details.put("Release date", date == null ? "???" : String.format("%4d-%02d-%02d", date.getYear(), date.getMonth(), date.getDay()));
                    ApiLevel apiLevel = new ApiLevel(version.getId(), version.getCodeName(), version.getVersionString(), version.getApiLevel(), details);
                    apiLevels.add(apiLevel);
                    List tags = version.getTags();
                    if (tags == null || !tags.contains("default")) continue;
                    defaultApi = apiLevel;
                }
            }
            if (ApiDimension.isFullDomainMissing() || !apiLevels.isEmpty()) {
                FULL_DOMAIN = ImmutableList.copyOf((Collection)Ordering.from(API_LEVEL_COMPARATOR).reverse().sortedCopy(apiLevels));
            }
            ApiDimension.resetDiscoveryTestApiUpdateTimestamp(DISPLAY_NAME);
        }
        return FULL_DOMAIN;
    }

    private static boolean isFullDomainMissing() {
        return FULL_DOMAIN == null || FULL_DOMAIN.isEmpty();
    }

    private static ApiLevel getDefaultApi() {
        if (defaultApi == null) {
            ApiDimension.getFullDomain();
        }
        return defaultApi;
    }

    public void enableDefault() {
        if (ApiDimension.getDefaultApi() == null) {
            return;
        }
        List<? extends CloudTestingType> appSupportedDomain = this.getAppSupportedDomain();
        if (appSupportedDomain.contains(defaultApi)) {
            this.enable(defaultApi);
        } else if (!appSupportedDomain.isEmpty()) {
            this.enable(appSupportedDomain.get(0));
        }
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String getId() {
        return "APILEVEL";
    }

    @Override
    public Icon getIcon() {
        return AndroidIcons.SdkManager;
    }

    static {
        API_LEVEL_COMPARATOR = (level1, level2) -> ((ApiLevel)level1).apiVersion - ((ApiLevel)level2).apiVersion;
    }

    public static class ApiLevel
    extends CloudTestingType {
        private final String id;
        private final String codeName;
        private final String osVersion;
        private final int apiVersion;

        public ApiLevel(String id, String codeName, String osVersion, int apiVersion, Map<String, String> details) {
            this.id = id;
            this.codeName = codeName;
            this.osVersion = osVersion;
            this.details = details;
            this.apiVersion = apiVersion;
        }

        @Override
        public String getConfigurationDialogDisplayName() {
            return String.format("Android %s, API Level %d (%s)", this.osVersion, this.apiVersion, this.codeName);
        }

        @Override
        public String getId() {
            return this.id;
        }

        public int getApiVersion() {
            return this.apiVersion;
        }
    }
}

