/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.configure;

import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleSourceSetDataServiceKt;
import org.jetbrains.kotlin.idea.framework.JSLibraryTypeKt;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006H\u0016J6\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/android/configure/KotlinAndroidGradleLibraryDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/android/tools/idea/gradle/project/model/JavaModuleModel;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "postProcess", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "idea-android"})
public final class KotlinAndroidGradleLibraryDataService
extends AbstractProjectDataService<JavaModuleModel, Void> {
    @NotNull
    public Key<JavaModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.JAVA_MODULE_MODEL;
    }

    public void postProcess(@NotNull Collection<DataNode<JavaModuleModel>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkParameterIsNotNull(toImport, (String)"toImport");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        for (DataNode<JavaModuleModel> dataNode : toImport) {
            DataNode dataNode2 = dataNode.getParent();
            if (dataNode2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.externalSystem.model.DataNode<com.intellij.openapi.externalSystem.model.project.ModuleData>");
            }
            TargetPlatformKind<?> targetPlatformKind = KotlinGradleSourceSetDataServiceKt.detectPlatformByPlugin((DataNode<ModuleData>)dataNode2);
            Object targetLibraryKind = targetPlatformKind != null ? JSLibraryTypeKt.getLibraryKind(targetPlatformKind) : null;
            if (targetLibraryKind == null) continue;
            for (JarLibraryDependency dep : ((JavaModuleModel)dataNode.getData()).getJarLibraryDependencies()) {
                PersistentLibraryKind<?> persistentLibraryKind;
                LibraryEx library2;
                if ((LibraryEx)modelsProvider.getLibraryByName(dep.getName()) == null) {
                    continue;
                }
                if (library2.getKind() != null) continue;
                Library.ModifiableModel modifiableModel = modelsProvider.getModifiableLibraryModel((Library)library2);
                if (modifiableModel == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx.ModifiableModelEx");
                }
                LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)modifiableModel;
                VirtualFile[] virtualFileArray = model.getFiles(OrderRootType.CLASSES);
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"model.getFiles(OrderRootType.CLASSES)");
                if (LibraryKindsKt.detectLibraryKind(virtualFileArray) == null) continue;
                PersistentLibraryKind<?> it = persistentLibraryKind;
                model.setKind(it);
            }
        }
    }
}

