/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.quickfix;

import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.checks.CommentDetector;
import com.android.tools.lint.checks.ParcelDetector;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFixProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.quickfix.AddTargetApiQuickFix;
import org.jetbrains.kotlin.android.quickfix.AddTargetVersionCheckQuickFix;
import org.jetbrains.kotlin.android.quickfix.ParcelableQuickFix;
import org.jetbrains.kotlin.android.quickfix.SuppressLintQuickFix;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ=\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/KotlinAndroidQuickFixProvider;", "Lorg/jetbrains/android/inspections/lint/AndroidLintQuickFixProvider;", "()V", "getApiQuickFixes", "", "Lorg/jetbrains/android/inspections/lint/AndroidLintQuickFix;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "element", "Lcom/intellij/psi/PsiElement;", "message", "", "(Lcom/android/tools/lint/detector/api/Issue;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lorg/jetbrains/android/inspections/lint/AndroidLintQuickFix;", "getQuickFixes", "startElement", "endElement", "data", "", "(Lcom/android/tools/lint/detector/api/Issue;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Ljava/lang/String;Ljava/lang/Object;)[Lorg/jetbrains/android/inspections/lint/AndroidLintQuickFix;", "getRequiredVersion", "", "errorMessage", "Companion", "idea-android"})
public final class KotlinAndroidQuickFixProvider
implements AndroidLintQuickFixProvider {
    @NotNull
    private static final String REQUIRES_API_ANNOTATION = "android.support.annotation.RequiresApi";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull Issue issue, @NotNull PsiElement startElement2, @NotNull PsiElement endElement2, @NotNull String message2, @Nullable Object data) {
        AndroidLintQuickFix[] fixes;
        AndroidLintQuickFix[] androidLintQuickFixArray;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)startElement2, (String)"startElement");
        Intrinsics.checkParameterIsNotNull((Object)endElement2, (String)"endElement");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Issue issue2 = issue;
        if (Intrinsics.areEqual((Object)issue2, (Object)ApiDetector.UNSUPPORTED) || Intrinsics.areEqual((Object)issue2, (Object)ApiDetector.INLINED)) {
            androidLintQuickFixArray = this.getApiQuickFixes(issue, startElement2, message2);
        } else if (Intrinsics.areEqual((Object)issue2, (Object)ParcelDetector.ISSUE)) {
            Object[] elements$iv = new AndroidLintQuickFix[]{new ParcelableQuickFix()};
            androidLintQuickFixArray = (AndroidLintQuickFix[])elements$iv;
        } else {
            androidLintQuickFixArray = fixes = new AndroidLintQuickFix[]{};
        }
        if (Intrinsics.areEqual((Object)issue, (Object)CommentDetector.STOP_SHIP) ^ true) {
            Object[] objectArray = fixes;
            String string = issue.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"issue.id");
            return (AndroidLintQuickFix[])ArraysKt.plus((Object[])objectArray, (Object)new SuppressLintQuickFix(string));
        }
        return fixes;
    }

    @NotNull
    public final AndroidLintQuickFix[] getApiQuickFixes(@NotNull Issue issue, @NotNull PsiElement element3, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        int api = this.getRequiredVersion(message2);
        if (api == -1) {
            Intrinsics.checkExpressionValueIsNotNull((Object)AndroidLintQuickFix.EMPTY_ARRAY, (String)"AndroidLintQuickFix.EMPTY_ARRAY");
            return AndroidLintQuickFix.EMPTY_ARRAY;
        }
        Project project = element3.getProject();
        if (JavaPsiFacade.getInstance((Project)project).findClass(Companion.getREQUIRES_API_ANNOTATION(), GlobalSearchScope.allScope((Project)project)) != null) {
            Object[] elements$iv = new AndroidLintQuickFix[]{new AddTargetApiQuickFix(api, true), new AddTargetApiQuickFix(api, false), new AddTargetVersionCheckQuickFix(api)};
            return (AndroidLintQuickFix[])elements$iv;
        }
        Object[] elements$iv = new AndroidLintQuickFix[]{new AddTargetApiQuickFix(api, false), new AddTargetVersionCheckQuickFix(api)};
        return (AndroidLintQuickFix[])elements$iv;
    }

    private final int getRequiredVersion(String errorMessage) {
        Pattern pattern = Pattern.compile("\\s(\\d+)\\s");
        Matcher matcher2 = pattern.matcher(errorMessage);
        if (matcher2.find()) {
            return Integer.parseInt(matcher2.group(1));
        }
        return -1;
    }

    static {
        REQUIRES_API_ANNOTATION = REQUIRES_API_ANNOTATION;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/android/quickfix/KotlinAndroidQuickFixProvider$Companion;", "", "()V", "REQUIRES_API_ANNOTATION", "", "getREQUIRES_API_ANNOTATION", "()Ljava/lang/String;", "idea-android"})
    public static final class Companion {
        @NotNull
        public final String getREQUIRES_API_ANNOTATION() {
            return REQUIRES_API_ANNOTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

