/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.containers.Stack;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.builder.LightElementOrigin;
import org.jetbrains.kotlin.asJava.builder.LightElementOriginKt;
import org.jetbrains.kotlin.asJava.builder.MemberIndex;
import org.jetbrains.kotlin.codegen.AbstractClassBuilder;
import org.jetbrains.kotlin.fileClasses.OldPackageFacadeClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class StubClassBuilder
extends AbstractClassBuilder {
    private static final InnerClassSourceStrategy<Object> EMPTY_STRATEGY = new InnerClassSourceStrategy<Object>(){

        public Object findInnerClass(String s, Object o) {
            return null;
        }

        public void accept(Object innerClass, StubBuildingVisitor<Object> visitor2) {
            throw new UnsupportedOperationException("Shall not be called!");
        }
    };
    private final StubElement parent;
    private final PsiJavaFileStub fileStub;
    private StubBuildingVisitor v;
    private final Stack<StubElement> parentStack;
    private boolean isPackageClass;
    private int memberIndex;

    public StubClassBuilder(@NotNull Stack<StubElement> parentStack, @NotNull PsiJavaFileStub fileStub) {
        if (parentStack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentStack", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "<init>"));
        }
        if (fileStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStub", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "<init>"));
        }
        this.isPackageClass = false;
        this.memberIndex = 0;
        this.parentStack = parentStack;
        this.parent = (StubElement)parentStack.peek();
        this.fileStub = fileStub;
    }

    @Override
    @NotNull
    public ClassVisitor getVisitor() {
        assert (this.v != null) : "Called before class is defined";
        StubBuildingVisitor stubBuildingVisitor = this.v;
        if (stubBuildingVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "getVisitor"));
        }
        return stubBuildingVisitor;
    }

    @Override
    public void defineClass(PsiElement origin, int version, int access, @NotNull String name2, @Nullable String signature, @NotNull String superName, @NotNull String[] interfaces) {
        FqName packageName;
        String packageClassName;
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "defineClass"));
        }
        if (superName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superName", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "defineClass"));
        }
        if (interfaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interfaces", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "defineClass"));
        }
        assert (this.v == null) : "defineClass() called twice?";
        this.v = new StubBuildingVisitor(null, EMPTY_STRATEGY, this.parent, access, this.calculateShortName(name2));
        super.defineClass(origin, version, access, name2, signature, superName, interfaces);
        if (origin instanceof KtFile && (name2.equals(packageClassName = OldPackageFacadeClassUtils.getPackageClassName(packageName = ((KtFile)origin).getPackageFqName())) || name2.endsWith("/" + packageClassName))) {
            this.isPackageClass = true;
        }
        if (!this.isPackageClass) {
            this.parentStack.push((Object)this.v.getResult());
        }
        ((StubBase)this.v.getResult()).putUserData(ClsWrapperStubPsiFactory.ORIGIN, (Object)LightElementOriginKt.toLightClassOrigin(origin));
    }

    @Nullable
    private String calculateShortName(@NotNull String internalName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "calculateShortName"));
        }
        if (this.parent instanceof PsiJavaFileStub) {
            assert (this.parent == this.fileStub);
            String packagePrefix = this.getPackageInternalNamePrefix();
            assert (internalName.startsWith(packagePrefix)) : internalName + " : " + packagePrefix;
            return internalName.substring(packagePrefix.length());
        }
        if (this.parent instanceof PsiClassStub) {
            String parentPrefix = this.getClassInternalNamePrefix((PsiClassStub)this.parent);
            if (parentPrefix == null) {
                return null;
            }
            assert (internalName.startsWith(parentPrefix)) : internalName + " : " + parentPrefix;
            return internalName.substring(parentPrefix.length());
        }
        return null;
    }

    @Nullable
    private String getClassInternalNamePrefix(@NotNull PsiClassStub classStub) {
        if (classStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classStub", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "getClassInternalNamePrefix"));
        }
        String packageName = this.fileStub.getPackageName();
        String classStubQualifiedName = classStub.getQualifiedName();
        if (classStubQualifiedName == null) {
            return null;
        }
        if (packageName.isEmpty()) {
            return classStubQualifiedName.replace('.', '$') + "$";
        }
        return packageName.replace('.', '/') + "/" + classStubQualifiedName.substring(packageName.length() + 1).replace('.', '$') + "$";
    }

    @NotNull
    private String getPackageInternalNamePrefix() {
        String packageName = this.fileStub.getPackageName();
        if (packageName.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "getPackageInternalNamePrefix"));
            }
            return "";
        }
        String string = packageName.replace('.', '/') + "/";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "getPackageInternalNamePrefix"));
        }
        return string;
    }

    @Override
    @NotNull
    public MethodVisitor newMethod(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "newMethod"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "newMethod"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "newMethod"));
        }
        MethodVisitor internalVisitor = super.newMethod(origin, access, name2, desc, signature, exceptions);
        if (internalVisitor != EMPTY_METHOD_VISITOR) {
            this.markLastChild(origin);
        }
        MethodVisitor methodVisitor = internalVisitor;
        if (methodVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "newMethod"));
        }
        return methodVisitor;
    }

    @Override
    @NotNull
    public FieldVisitor newField(@NotNull JvmDeclarationOrigin origin, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature, @Nullable Object value2) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "newField"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "newField"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "newField"));
        }
        FieldVisitor internalVisitor = super.newField(origin, access, name2, desc, signature, value2);
        if (internalVisitor != EMPTY_FIELD_VISITOR) {
            this.markLastChild(origin);
        }
        FieldVisitor fieldVisitor = internalVisitor;
        if (fieldVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "newField"));
        }
        return fieldVisitor;
    }

    private void markLastChild(@NotNull JvmDeclarationOrigin origin) {
        if (origin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "origin", "org/jetbrains/kotlin/asJava/builder/StubClassBuilder", "markLastChild"));
        }
        List children2 = this.v.getResult().getChildrenStubs();
        StubBase last = (StubBase)children2.get(children2.size() - 1);
        LightElementOrigin oldOrigin = (LightElementOrigin)last.getUserData(ClsWrapperStubPsiFactory.ORIGIN);
        if (oldOrigin != null) {
            PsiElement originalElement2 = oldOrigin.getOriginalElement();
            throw new IllegalStateException("Rewriting origin element: " + (originalElement2 != null ? originalElement2.getText() : null) + " for stub " + last.toString());
        }
        last.putUserData(ClsWrapperStubPsiFactory.ORIGIN, (Object)LightElementOriginKt.toLightMemberOrigin(origin));
        last.putUserData(MemberIndex.KEY, (Object)new MemberIndex(this.memberIndex++));
    }

    @Override
    public void done() {
        if (!this.isPackageClass) {
            StubElement pop2 = (StubElement)this.parentStack.pop();
            assert (pop2 == this.v.getResult()) : "parentStack: got " + pop2 + ", expected " + this.v.getResult();
        }
        super.done();
    }
}

