/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.DebugInfoUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.AbstractDiagnosticWithParametersRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.MultiTargetPlatform;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

public class CheckerTestUtil {
    public static final Comparator<ActualDiagnostic> DIAGNOSTIC_COMPARATOR = (o1, o2) -> {
        List<TextRange> ranges1 = o1.diagnostic.getTextRanges();
        List<TextRange> ranges2 = o2.diagnostic.getTextRanges();
        int minNumberOfRanges = ranges1.size() < ranges2.size() ? ranges1.size() : ranges2.size();
        for (int i = 0; i < minNumberOfRanges; ++i) {
            int endOffset2;
            int startOffset2;
            TextRange range1 = ranges1.get(i);
            TextRange range2 = ranges2.get(i);
            int startOffset1 = range1.getStartOffset();
            if (startOffset1 != (startOffset2 = range2.getStartOffset())) {
                return startOffset1 - range2.getStartOffset();
            }
            int endOffset1 = range1.getEndOffset();
            if (endOffset1 == (endOffset2 = range2.getEndOffset())) continue;
            return endOffset2 - endOffset1;
        }
        return ranges1.size() - ranges2.size();
    };
    private static final String IGNORE_DIAGNOSTIC_PARAMETER = "IGNORE";
    private static final String SHOULD_BE_ESCAPED = "\\)\\(;";
    private static final String DIAGNOSTIC_PARAMETER = "(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+";
    private static final String INDIVIDUAL_DIAGNOSTIC = "(\\w+:)?(\\w+)(\\((?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+(;\\s*(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+)*\\))?";
    private static final Pattern RANGE_START_OR_END_PATTERN = Pattern.compile("(<!(\\w+:)?(\\w+)(\\((?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+(;\\s*(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+)*\\))?(,\\s*(\\w+:)?(\\w+)(\\((?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+(;\\s*(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+)*\\))?)*!>)|(<!>)");
    private static final Pattern INDIVIDUAL_DIAGNOSTIC_PATTERN = Pattern.compile("(\\w+:)?(\\w+)(\\((?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+(;\\s*(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+)*\\))?");
    private static final Pattern INDIVIDUAL_PARAMETER_PATTERN = Pattern.compile("(?:(?:\\\\[\\)\\(;])|[^\\)\\(;])+");

    @NotNull
    public static List<ActualDiagnostic> getDiagnosticsIncludingSyntaxErrors(@NotNull BindingContext bindingContext2, @NotNull List<Pair<MultiTargetPlatform, BindingContext>> implementingModulesBindings, @NotNull PsiElement root, boolean markDynamicCalls, @Nullable List<DeclarationDescriptor> dynamicCallDescriptors) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        if (implementingModulesBindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementingModulesBindings", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        List<ActualDiagnostic> result2 = CheckerTestUtil.getDiagnosticsIncludingSyntaxErrors(bindingContext2, root, markDynamicCalls, dynamicCallDescriptors, null);
        List sortedBindings = CollectionsKt.sortedWith(implementingModulesBindings, (o1, o2) -> ((MultiTargetPlatform)o1.getFirst()).compareTo(o2.getFirst()));
        for (Pair binding : sortedBindings) {
            MultiTargetPlatform platform = (MultiTargetPlatform)binding.getFirst();
            assert (platform instanceof MultiTargetPlatform.Specific) : "Implementing module must have a specific platform: " + platform;
            result2.addAll(CheckerTestUtil.getDiagnosticsIncludingSyntaxErrors((BindingContext)binding.getSecond(), root, markDynamicCalls, dynamicCallDescriptors, ((MultiTargetPlatform.Specific)platform).getPlatform()));
        }
        List<ActualDiagnostic> list2 = result2;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        return list2;
    }

    @NotNull
    public static List<ActualDiagnostic> getDiagnosticsIncludingSyntaxErrors(@NotNull BindingContext bindingContext2, @NotNull PsiElement root, boolean markDynamicCalls, @Nullable List<DeclarationDescriptor> dynamicCallDescriptors, @Nullable String platform) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        ArrayList<ActualDiagnostic> diagnostics = new ArrayList<ActualDiagnostic>();
        for (Diagnostic diagnostic : bindingContext2.getDiagnostics().all()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)diagnostic.getPsiElement(), (boolean)false)) continue;
            diagnostics.add(new ActualDiagnostic(diagnostic, platform));
        }
        for (PsiErrorElement errorElement : AnalyzingUtils.getSyntaxErrorRanges(root)) {
            diagnostics.add(new ActualDiagnostic(new SyntaxErrorDiagnostic(errorElement), platform));
        }
        diagnostics.addAll(CheckerTestUtil.getDebugInfoDiagnostics(root, bindingContext2, markDynamicCalls, dynamicCallDescriptors, platform));
        ArrayList<ActualDiagnostic> arrayList = diagnostics;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        return arrayList;
    }

    @NotNull
    private static List<ActualDiagnostic> getDebugInfoDiagnostics(@NotNull PsiElement root, @NotNull BindingContext bindingContext2, final boolean markDynamicCalls, final @Nullable List<DeclarationDescriptor> dynamicCallDescriptors, final @Nullable String platform) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDebugInfoDiagnostics"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDebugInfoDiagnostics"));
        }
        final ArrayList<ActualDiagnostic> debugAnnotations = new ArrayList<ActualDiagnostic>();
        DebugInfoUtil.markDebugAnnotations(root, bindingContext2, new DebugInfoUtil.DebugInfoReporter(){

            @Override
            public void reportElementWithErrorType(@NotNull KtReferenceExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/CheckerTestUtil$1", "reportElementWithErrorType"));
                }
                this.newDiagnostic(expression2, DebugInfoDiagnosticFactory.ELEMENT_WITH_ERROR_TYPE);
            }

            @Override
            public void reportMissingUnresolved(@NotNull KtReferenceExpression expression2) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/CheckerTestUtil$1", "reportMissingUnresolved"));
                }
                this.newDiagnostic(expression2, DebugInfoDiagnosticFactory.MISSING_UNRESOLVED);
            }

            @Override
            public void reportUnresolvedWithTarget(@NotNull KtReferenceExpression expression2, @NotNull String target) {
                if (expression2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/CheckerTestUtil$1", "reportUnresolvedWithTarget"));
                }
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/checkers/CheckerTestUtil$1", "reportUnresolvedWithTarget"));
                }
                this.newDiagnostic(expression2, DebugInfoDiagnosticFactory.UNRESOLVED_WITH_TARGET);
            }

            @Override
            public void reportDynamicCall(@NotNull KtElement element3, DeclarationDescriptor declarationDescriptor) {
                if (element3 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/CheckerTestUtil$1", "reportDynamicCall"));
                }
                if (dynamicCallDescriptors != null) {
                    dynamicCallDescriptors.add(declarationDescriptor);
                }
                if (markDynamicCalls) {
                    this.newDiagnostic(element3, DebugInfoDiagnosticFactory.DYNAMIC);
                }
            }

            private void newDiagnostic(KtElement element3, DebugInfoDiagnosticFactory factory2) {
                debugAnnotations.add(new ActualDiagnostic(new DebugInfoDiagnostic(element3, factory2), platform));
            }
        });
        for (Pair factory2 : Arrays.asList(TuplesKt.to(BindingContext.SMARTCAST, (Object)DebugInfoDiagnosticFactory.SMARTCAST), TuplesKt.to(BindingContext.IMPLICIT_RECEIVER_SMARTCAST, (Object)DebugInfoDiagnosticFactory.IMPLICIT_RECEIVER_SMARTCAST), TuplesKt.to(BindingContext.SMARTCAST_NULL, (Object)DebugInfoDiagnosticFactory.CONSTANT), TuplesKt.to(BindingContext.LEAKING_THIS, (Object)DebugInfoDiagnosticFactory.LEAKING_THIS), TuplesKt.to(BindingContext.IMPLICIT_EXHAUSTIVE_WHEN, (Object)DebugInfoDiagnosticFactory.IMPLICIT_EXHAUSTIVE))) {
            for (KtExpression expression2 : bindingContext2.getSliceContents((ReadOnlySlice)factory2.getFirst()).keySet()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)expression2, (boolean)false)) continue;
                debugAnnotations.add(new ActualDiagnostic(new DebugInfoDiagnostic(expression2, (DebugInfoDiagnosticFactory)factory2.getSecond()), platform));
            }
        }
        ArrayList<ActualDiagnostic> arrayList = debugAnnotations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDebugInfoDiagnostics"));
        }
        return arrayList;
    }

    public static Map<ActualDiagnostic, TextDiagnostic> diagnosticsDiff(List<DiagnosedRange> expected, Collection<ActualDiagnostic> actual, DiagnosticDiffCallbacks callbacks) {
        HashMap<ActualDiagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic = new HashMap<ActualDiagnostic, TextDiagnostic>();
        CheckerTestUtil.assertSameFile(actual);
        Iterator<DiagnosedRange> expectedDiagnostics = expected.iterator();
        List<DiagnosticDescriptor> sortedDiagnosticDescriptors = CheckerTestUtil.getSortedDiagnosticDescriptors(actual);
        Iterator<DiagnosticDescriptor> actualDiagnostics = sortedDiagnosticDescriptors.iterator();
        DiagnosedRange currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
        DiagnosticDescriptor currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
        while (currentExpected != null || currentActual != null) {
            if (currentExpected != null) {
                if (currentActual == null) {
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                int expectedStart = currentExpected.getStart();
                int actualStart = currentActual.getStart();
                int expectedEnd = currentExpected.getEnd();
                int actualEnd = currentActual.getEnd();
                if (expectedStart < actualStart) {
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                if (expectedStart > actualStart) {
                    CheckerTestUtil.unexpectedDiagnostics(currentActual, callbacks);
                    currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                    continue;
                }
                if (expectedEnd > actualEnd) {
                    assert (expectedStart == actualStart);
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                if (expectedEnd < actualEnd) {
                    assert (expectedStart == actualStart);
                    CheckerTestUtil.unexpectedDiagnostics(currentActual, callbacks);
                    currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                    continue;
                }
                CheckerTestUtil.compareDiagnostics(callbacks, currentExpected, currentActual, diagnosticToExpectedDiagnostic);
                currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                continue;
            }
            assert (currentActual != null);
            CheckerTestUtil.unexpectedDiagnostics(currentActual, callbacks);
            currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
        }
        return diagnosticToExpectedDiagnostic;
    }

    private static void compareDiagnostics(@NotNull DiagnosticDiffCallbacks callbacks, @NotNull DiagnosedRange currentExpected, @NotNull DiagnosticDescriptor currentActual, @NotNull Map<ActualDiagnostic, TextDiagnostic> diagnosticToInput) {
        if (callbacks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callbacks", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareDiagnostics"));
        }
        if (currentExpected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentExpected", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareDiagnostics"));
        }
        if (currentActual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentActual", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareDiagnostics"));
        }
        if (diagnosticToInput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticToInput", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareDiagnostics"));
        }
        int expectedStart = currentExpected.getStart();
        int expectedEnd = currentExpected.getEnd();
        int actualStart = currentActual.getStart();
        int actualEnd = currentActual.getEnd();
        assert (expectedStart == actualStart && expectedEnd == actualEnd);
        Map<ActualDiagnostic, TextDiagnostic> actualDiagnostics = currentActual.getTextDiagnosticsMap();
        List<TextDiagnostic> expectedDiagnostics = currentExpected.getDiagnostics();
        for (TextDiagnostic expectedDiagnostic : expectedDiagnostics) {
            Map.Entry actualDiagnosticEntry = (Map.Entry)CollectionsKt.firstOrNull(actualDiagnostics.entrySet(), entry -> expectedDiagnostic.getDescription().equals(((TextDiagnostic)entry.getValue()).getDescription()));
            if (actualDiagnosticEntry != null) {
                ActualDiagnostic actualDiagnostic = (ActualDiagnostic)actualDiagnosticEntry.getKey();
                TextDiagnostic actualTextDiagnostic = (TextDiagnostic)actualDiagnosticEntry.getValue();
                if (!CheckerTestUtil.compareTextDiagnostic(expectedDiagnostic, actualTextDiagnostic)) {
                    callbacks.wrongParametersDiagnostic(expectedDiagnostic, actualTextDiagnostic, expectedStart, expectedEnd);
                }
                actualDiagnostics.remove(actualDiagnostic);
                diagnosticToInput.put(actualDiagnostic, expectedDiagnostic);
                continue;
            }
            callbacks.missingDiagnostic(expectedDiagnostic, expectedStart, expectedEnd);
        }
        for (TextDiagnostic unexpectedDiagnostic : actualDiagnostics.values()) {
            callbacks.unexpectedDiagnostic(unexpectedDiagnostic, actualStart, actualEnd);
        }
    }

    private static boolean compareTextDiagnostic(@NotNull TextDiagnostic expected, @NotNull TextDiagnostic actual) {
        if (expected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expected", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareTextDiagnostic"));
        }
        if (actual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actual", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareTextDiagnostic"));
        }
        if (!expected.getDescription().equals(actual.getDescription())) {
            return false;
        }
        if (expected.getParameters() == null) {
            return true;
        }
        if (actual.getParameters() == null || expected.getParameters().size() != actual.getParameters().size()) {
            return false;
        }
        for (int index2 = 0; index2 < expected.getParameters().size(); ++index2) {
            String expectedParameter = expected.getParameters().get(index2);
            String actualParameter = actual.getParameters().get(index2);
            if (expectedParameter.equals(IGNORE_DIAGNOSTIC_PARAMETER) || expectedParameter.equals(actualParameter)) continue;
            return false;
        }
        return true;
    }

    private static void assertSameFile(Collection<ActualDiagnostic> actual) {
        if (actual.isEmpty()) {
            return;
        }
        PsiFile file2 = ((ActualDiagnostic)CollectionsKt.first(actual)).getFile();
        for (ActualDiagnostic actualDiagnostic : actual) {
            assert (actualDiagnostic.getFile().equals(file2)) : "All diagnostics should come from the same file: " + actualDiagnostic.getFile() + ", " + file2;
        }
    }

    private static void unexpectedDiagnostics(DiagnosticDescriptor descriptor2, DiagnosticDiffCallbacks callbacks) {
        for (ActualDiagnostic diagnostic : descriptor2.diagnostics) {
            callbacks.unexpectedDiagnostic(TextDiagnostic.asTextDiagnostic(diagnostic), descriptor2.start, descriptor2.end);
        }
    }

    private static void missingDiagnostics(DiagnosticDiffCallbacks callbacks, DiagnosedRange currentExpected) {
        for (TextDiagnostic diagnostic : currentExpected.getDiagnostics()) {
            callbacks.missingDiagnostic(diagnostic, currentExpected.getStart(), currentExpected.getEnd());
        }
    }

    private static <T> T safeAdvance(Iterator<T> iterator2) {
        return iterator2.hasNext() ? (T)iterator2.next() : null;
    }

    public static String parseDiagnosedRanges(String text2, List<DiagnosedRange> result2) {
        Matcher matcher2 = RANGE_START_OR_END_PATTERN.matcher(text2);
        Stack opened = new Stack();
        int offsetCompensation = 0;
        while (matcher2.find()) {
            int effectiveOffset = matcher2.start() - offsetCompensation;
            String matchedText = matcher2.group();
            if ("<!>".equals(matchedText)) {
                ((DiagnosedRange)opened.pop()).setEnd(effectiveOffset);
            } else {
                Matcher diagnosticTypeMatcher = INDIVIDUAL_DIAGNOSTIC_PATTERN.matcher(matchedText);
                DiagnosedRange range = new DiagnosedRange(effectiveOffset);
                while (diagnosticTypeMatcher.find()) {
                    range.addDiagnostic(diagnosticTypeMatcher.group());
                }
                opened.push((Object)range);
                result2.add(range);
            }
            offsetCompensation += matchedText.length();
        }
        assert (opened.isEmpty()) : "Stack is not empty";
        matcher2.reset();
        return matcher2.replaceAll("");
    }

    public static StringBuffer addDiagnosticMarkersToText(@NotNull PsiFile psiFile, @NotNull Collection<ActualDiagnostic> diagnostics) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        return CheckerTestUtil.addDiagnosticMarkersToText(psiFile, diagnostics, Collections.emptyMap(), (Function<PsiFile, String>)((Function)PsiElement::getText));
    }

    public static StringBuffer addDiagnosticMarkersToText(@NotNull PsiFile psiFile, @NotNull Collection<ActualDiagnostic> diagnostics, @NotNull Map<ActualDiagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic, @NotNull Function<PsiFile, String> getFileText) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        if (diagnosticToExpectedDiagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticToExpectedDiagnostic", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        if (getFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getFileText", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        String text2 = (String)getFileText.fun((Object)psiFile);
        StringBuffer result2 = new StringBuffer();
        if (!(diagnostics = CollectionsKt.filter(diagnostics, actualDiagnostic -> {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "lambda$addDiagnosticMarkersToText$3"));
            }
            return psiFile.equals(actualDiagnostic.getFile());
        })).isEmpty()) {
            List<DiagnosticDescriptor> diagnosticDescriptors = CheckerTestUtil.getSortedDiagnosticDescriptors(diagnostics);
            Stack opened = new Stack();
            ListIterator<DiagnosticDescriptor> iterator2 = diagnosticDescriptors.listIterator();
            DiagnosticDescriptor currentDescriptor2 = iterator2.next();
            for (int i = 0; i < text2.length(); ++i) {
                char c = text2.charAt(i);
                while (!opened.isEmpty() && i == ((DiagnosticDescriptor)opened.peek()).end) {
                    CheckerTestUtil.closeDiagnosticString(result2);
                    opened.pop();
                }
                while (currentDescriptor2 != null && i == currentDescriptor2.start) {
                    CheckerTestUtil.openDiagnosticsString(result2, currentDescriptor2, diagnosticToExpectedDiagnostic);
                    if (currentDescriptor2.getEnd() == i) {
                        CheckerTestUtil.closeDiagnosticString(result2);
                    } else {
                        opened.push((Object)currentDescriptor2);
                    }
                    if (iterator2.hasNext()) {
                        currentDescriptor2 = iterator2.next();
                        continue;
                    }
                    currentDescriptor2 = null;
                }
                result2.append(c);
            }
            if (currentDescriptor2 != null) {
                assert (currentDescriptor2.start == text2.length());
                assert (currentDescriptor2.end == text2.length());
                CheckerTestUtil.openDiagnosticsString(result2, currentDescriptor2, diagnosticToExpectedDiagnostic);
                opened.push((Object)currentDescriptor2);
            }
            while (!opened.isEmpty() && text2.length() == ((DiagnosticDescriptor)opened.peek()).end) {
                CheckerTestUtil.closeDiagnosticString(result2);
                opened.pop();
            }
            assert (opened.isEmpty()) : "Stack is not empty: " + opened;
        } else {
            result2.append(text2);
        }
        return result2;
    }

    private static void openDiagnosticsString(StringBuffer result2, DiagnosticDescriptor currentDescriptor2, Map<ActualDiagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic) {
        result2.append("<!");
        Iterator iterator2 = currentDescriptor2.diagnostics.iterator();
        while (iterator2.hasNext()) {
            ActualDiagnostic diagnostic = (ActualDiagnostic)iterator2.next();
            TextDiagnostic expectedDiagnostic = diagnosticToExpectedDiagnostic.get(diagnostic);
            if (expectedDiagnostic != null) {
                TextDiagnostic actualTextDiagnostic = TextDiagnostic.asTextDiagnostic(diagnostic);
                if (CheckerTestUtil.compareTextDiagnostic(expectedDiagnostic, actualTextDiagnostic)) {
                    result2.append(expectedDiagnostic.asString());
                } else {
                    result2.append(actualTextDiagnostic.asString());
                }
            } else {
                if (diagnostic.platform != null) {
                    result2.append(diagnostic.platform);
                    result2.append(":");
                }
                result2.append(diagnostic.getName());
            }
            if (!iterator2.hasNext()) continue;
            result2.append(", ");
        }
        result2.append("!>");
    }

    private static void closeDiagnosticString(StringBuffer result2) {
        result2.append("<!>");
    }

    @NotNull
    private static List<DiagnosticDescriptor> getSortedDiagnosticDescriptors(@NotNull Collection<ActualDiagnostic> diagnostics) {
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getSortedDiagnosticDescriptors"));
        }
        LinkedListMultimap diagnosticsGroupedByRanges = LinkedListMultimap.create();
        for (ActualDiagnostic actualDiagnostic : diagnostics) {
            Diagnostic diagnostic = actualDiagnostic.diagnostic;
            if (!diagnostic.isValid()) continue;
            for (TextRange textRange : diagnostic.getTextRanges()) {
                diagnosticsGroupedByRanges.put((Object)textRange, (Object)actualDiagnostic);
            }
        }
        ArrayList diagnosticDescriptors = Lists.newArrayList();
        for (TextRange range : diagnosticsGroupedByRanges.keySet()) {
            diagnosticDescriptors.add(new DiagnosticDescriptor(range.getStartOffset(), range.getEndOffset(), diagnosticsGroupedByRanges.get((Object)range)));
        }
        diagnosticDescriptors.sort((d1, d2) -> ((DiagnosticDescriptor)d1).start != ((DiagnosticDescriptor)d2).start ? ((DiagnosticDescriptor)d1).start - ((DiagnosticDescriptor)d2).start : ((DiagnosticDescriptor)d2).end - ((DiagnosticDescriptor)d1).end);
        ArrayList arrayList = diagnosticDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getSortedDiagnosticDescriptors"));
        }
        return arrayList;
    }

    public static class DiagnosedRange {
        private final int start;
        private int end;
        private final List<TextDiagnostic> diagnostics = ContainerUtil.newSmartList();

        protected DiagnosedRange(int start) {
            this.start = start;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public List<TextDiagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public void addDiagnostic(String diagnostic) {
            this.diagnostics.add(TextDiagnostic.parseDiagnostic(diagnostic));
        }
    }

    public static class TextDiagnostic {
        @NotNull
        private final String name;
        @Nullable
        private final String platform;
        @Nullable
        private final List<String> parameters;

        @NotNull
        private static TextDiagnostic parseDiagnostic(String text2) {
            Matcher matcher2 = INDIVIDUAL_DIAGNOSTIC_PATTERN.matcher(text2);
            if (!matcher2.find()) {
                throw new IllegalArgumentException("Could not parse diagnostic: " + text2);
            }
            String platformPrefix = matcher2.group(1);
            assert (platformPrefix == null || platformPrefix.endsWith(":")) : platformPrefix;
            String platform = platformPrefix == null ? null : StringsKt.substringBeforeLast((String)platformPrefix, (String)":", (String)platformPrefix);
            String name2 = matcher2.group(2);
            String parameters2 = matcher2.group(3);
            if (parameters2 == null) {
                TextDiagnostic textDiagnostic = new TextDiagnostic(name2, platform, null);
                if (textDiagnostic == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "parseDiagnostic"));
                }
                return textDiagnostic;
            }
            SmartList parsedParameters = new SmartList();
            Matcher parametersMatcher = INDIVIDUAL_PARAMETER_PATTERN.matcher(parameters2);
            while (parametersMatcher.find()) {
                parsedParameters.add(TextDiagnostic.unescape(parametersMatcher.group().trim()));
            }
            TextDiagnostic textDiagnostic = new TextDiagnostic(name2, platform, (List<String>)parsedParameters);
            if (textDiagnostic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "parseDiagnostic"));
            }
            return textDiagnostic;
        }

        @NotNull
        private static String escape(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "escape"));
            }
            String string = s.replaceAll("([\\)\\(;])", "\\\\$1");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "escape"));
            }
            return string;
        }

        @NotNull
        private static String unescape(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "unescape"));
            }
            String string = s.replaceAll("\\\\([\\)\\(;])", "$1");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "unescape"));
            }
            return string;
        }

        @NotNull
        public static TextDiagnostic asTextDiagnostic(@NotNull ActualDiagnostic actualDiagnostic) {
            if (actualDiagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualDiagnostic", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asTextDiagnostic"));
            }
            Diagnostic diagnostic = actualDiagnostic.diagnostic;
            DiagnosticRenderer renderer2 = DefaultErrorMessages.getRendererForDiagnostic(diagnostic);
            String diagnosticName = actualDiagnostic.getName();
            if (renderer2 instanceof AbstractDiagnosticWithParametersRenderer) {
                Object[] renderParameters = ((AbstractDiagnosticWithParametersRenderer)renderer2).renderParameters(diagnostic);
                List parameters2 = ContainerUtil.map((Object[])renderParameters, Object::toString);
                TextDiagnostic textDiagnostic = new TextDiagnostic(diagnosticName, actualDiagnostic.platform, parameters2);
                if (textDiagnostic == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asTextDiagnostic"));
                }
                return textDiagnostic;
            }
            TextDiagnostic textDiagnostic = new TextDiagnostic(diagnosticName, actualDiagnostic.platform, null);
            if (textDiagnostic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asTextDiagnostic"));
            }
            return textDiagnostic;
        }

        public TextDiagnostic(@NotNull String name2, @Nullable String platform, @Nullable List<String> parameters2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "<init>"));
            }
            this.name = name2;
            this.platform = platform;
            this.parameters = parameters2;
        }

        @Nullable
        public String getPlatform() {
            return this.platform;
        }

        @NotNull
        public String getDescription() {
            String string = (this.platform != null ? this.platform + ":" : "") + this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "getDescription"));
            }
            return string;
        }

        @Nullable
        public List<String> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextDiagnostic that = (TextDiagnostic)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) {
                return false;
            }
            return !(this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null);
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = 31 * result2 + (this.platform != null ? this.platform.hashCode() : 0);
            result2 = 31 * result2 + (this.parameters != null ? this.parameters.hashCode() : 0);
            return result2;
        }

        @NotNull
        public String asString() {
            StringBuilder result2 = new StringBuilder();
            if (this.platform != null) {
                result2.append(this.platform);
                result2.append(":");
            }
            result2.append(this.name);
            if (this.parameters != null) {
                result2.append("(");
                result2.append(StringUtil.join(this.parameters, TextDiagnostic::escape, (String)"; "));
                result2.append(")");
            }
            String string = result2.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asString"));
            }
            return string;
        }

        public String toString() {
            return this.asString();
        }
    }

    public static class ActualDiagnostic {
        public final Diagnostic diagnostic;
        public final String platform;

        ActualDiagnostic(@NotNull Diagnostic diagnostic, @Nullable String platform) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/checkers/CheckerTestUtil$ActualDiagnostic", "<init>"));
            }
            this.diagnostic = diagnostic;
            this.platform = platform;
        }

        @NotNull
        public String getName() {
            String string = this.diagnostic.getFactory().getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$ActualDiagnostic", "getName"));
            }
            return string;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.diagnostic.getPsiFile();
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$ActualDiagnostic", "getFile"));
            }
            return psiFile;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ActualDiagnostic)) {
                return false;
            }
            ActualDiagnostic other = (ActualDiagnostic)obj;
            return other.diagnostic == this.diagnostic && (other.platform == null ? this.platform == null : other.platform.equals(this.platform));
        }

        public int hashCode() {
            return System.identityHashCode(this.diagnostic) * 31 + (this.platform != null ? this.platform.hashCode() : 0);
        }

        public String toString() {
            return (this.platform != null ? this.platform + ":" : "") + this.diagnostic.toString();
        }
    }

    private static class DiagnosticDescriptor {
        private final int start;
        private final int end;
        private final List<ActualDiagnostic> diagnostics;

        DiagnosticDescriptor(int start, int end, List<ActualDiagnostic> diagnostics) {
            this.start = start;
            this.end = end;
            this.diagnostics = diagnostics;
        }

        public Map<ActualDiagnostic, TextDiagnostic> getTextDiagnosticsMap() {
            HashMap<ActualDiagnostic, TextDiagnostic> diagnosticMap = new HashMap<ActualDiagnostic, TextDiagnostic>();
            for (ActualDiagnostic diagnostic : this.diagnostics) {
                diagnosticMap.put(diagnostic, TextDiagnostic.asTextDiagnostic(diagnostic));
            }
            return diagnosticMap;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public TextRange getTextRange() {
            return new TextRange(this.start, this.end);
        }
    }

    public static class DebugInfoDiagnostic
    extends AbstractDiagnosticForTests {
        public DebugInfoDiagnostic(@NotNull KtElement element3, @NotNull DebugInfoDiagnosticFactory factory2) {
            if (element3 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DebugInfoDiagnostic", "<init>"));
            }
            if (factory2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DebugInfoDiagnostic", "<init>"));
            }
            super((PsiElement)element3, factory2);
        }
    }

    public static class DebugInfoDiagnosticFactory
    extends DiagnosticFactory<DebugInfoDiagnostic> {
        public static final DebugInfoDiagnosticFactory SMARTCAST = new DebugInfoDiagnosticFactory("SMARTCAST");
        public static final DebugInfoDiagnosticFactory IMPLICIT_RECEIVER_SMARTCAST = new DebugInfoDiagnosticFactory("IMPLICIT_RECEIVER_SMARTCAST");
        public static final DebugInfoDiagnosticFactory CONSTANT = new DebugInfoDiagnosticFactory("CONSTANT");
        public static final DebugInfoDiagnosticFactory LEAKING_THIS = new DebugInfoDiagnosticFactory("LEAKING_THIS");
        public static final DebugInfoDiagnosticFactory IMPLICIT_EXHAUSTIVE = new DebugInfoDiagnosticFactory("IMPLICIT_EXHAUSTIVE");
        public static final DebugInfoDiagnosticFactory ELEMENT_WITH_ERROR_TYPE = new DebugInfoDiagnosticFactory("ELEMENT_WITH_ERROR_TYPE");
        public static final DebugInfoDiagnosticFactory UNRESOLVED_WITH_TARGET = new DebugInfoDiagnosticFactory("UNRESOLVED_WITH_TARGET");
        public static final DebugInfoDiagnosticFactory MISSING_UNRESOLVED = new DebugInfoDiagnosticFactory("MISSING_UNRESOLVED");
        public static final DebugInfoDiagnosticFactory DYNAMIC = new DebugInfoDiagnosticFactory("DYNAMIC");
        private final String name;

        private DebugInfoDiagnosticFactory(String name2, Severity severity) {
            super(severity);
            this.name = name2;
        }

        private DebugInfoDiagnosticFactory(String name2) {
            this(name2, Severity.ERROR);
        }

        @Override
        @NotNull
        public String getName() {
            String string = "DEBUG_INFO_" + this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DebugInfoDiagnosticFactory", "getName"));
            }
            return string;
        }
    }

    public static class SyntaxErrorDiagnostic
    extends AbstractDiagnosticForTests {
        public SyntaxErrorDiagnostic(@NotNull PsiErrorElement errorElement) {
            if (errorElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorElement", "org/jetbrains/kotlin/checkers/CheckerTestUtil$SyntaxErrorDiagnostic", "<init>"));
            }
            super((PsiElement)errorElement, SyntaxErrorDiagnosticFactory.INSTANCE);
        }
    }

    public static class SyntaxErrorDiagnosticFactory
    extends DiagnosticFactory<SyntaxErrorDiagnostic> {
        public static final SyntaxErrorDiagnosticFactory INSTANCE = new SyntaxErrorDiagnosticFactory();

        private SyntaxErrorDiagnosticFactory() {
            super(Severity.ERROR);
        }

        @Override
        @NotNull
        public String getName() {
            if ("SYNTAX" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$SyntaxErrorDiagnosticFactory", "getName"));
            }
            return "SYNTAX";
        }
    }

    public static class AbstractDiagnosticForTests
    implements Diagnostic {
        private final PsiElement element;
        private final DiagnosticFactory<?> factory;

        public AbstractDiagnosticForTests(@NotNull PsiElement element3, @NotNull DiagnosticFactory<?> factory2) {
            if (element3 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "<init>"));
            }
            if (factory2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "<init>"));
            }
            this.element = element3;
            this.factory = factory2;
        }

        @Override
        @NotNull
        public DiagnosticFactory<?> getFactory() {
            DiagnosticFactory<?> diagnosticFactory = this.factory;
            if (diagnosticFactory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getFactory"));
            }
            return diagnosticFactory;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            Severity severity = Severity.ERROR;
            if (severity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getSeverity"));
            }
            return severity;
        }

        @Override
        @NotNull
        public PsiElement getPsiElement() {
            PsiElement psiElement2 = this.element;
            if (psiElement2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getPsiElement"));
            }
            return psiElement2;
        }

        @Override
        @NotNull
        public List<TextRange> getTextRanges() {
            List<TextRange> list2 = Collections.singletonList(this.element.getTextRange());
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getTextRanges"));
            }
            return list2;
        }

        @Override
        @NotNull
        public PsiFile getPsiFile() {
            PsiFile psiFile = this.element.getContainingFile();
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getPsiFile"));
            }
            return psiFile;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    public static interface DiagnosticDiffCallbacks {
        public void missingDiagnostic(TextDiagnostic var1, int var2, int var3);

        public void wrongParametersDiagnostic(TextDiagnostic var1, TextDiagnostic var2, int var3, int var4);

        public void unexpectedDiagnostic(TextDiagnostic var1, int var2, int var3);
    }
}

