/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public enum CompilerMessageSeverity {
    EXCEPTION,
    ERROR,
    STRONG_WARNING,
    WARNING,
    INFO,
    LOGGING,
    OUTPUT;

    public static final EnumSet<CompilerMessageSeverity> ERRORS;
    public static final EnumSet<CompilerMessageSeverity> VERBOSE;

    public boolean isError() {
        return ERRORS.contains((Object)this);
    }

    @NotNull
    public String getPresentableName() {
        switch (this) {
            case EXCEPTION: {
                if ("exception" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity", "getPresentableName"));
                }
                return "exception";
            }
            case ERROR: {
                if ("error" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity", "getPresentableName"));
                }
                return "error";
            }
            case STRONG_WARNING: 
            case WARNING: {
                if ("warning" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity", "getPresentableName"));
                }
                return "warning";
            }
            case INFO: {
                if ("info" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity", "getPresentableName"));
                }
                return "info";
            }
            case LOGGING: {
                if ("logging" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity", "getPresentableName"));
                }
                return "logging";
            }
            case OUTPUT: {
                if ("output" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity", "getPresentableName"));
                }
                return "output";
            }
        }
        throw new UnsupportedOperationException("Unknown severity: " + (Object)((Object)this));
    }

    static {
        ERRORS = EnumSet.of(ERROR, EXCEPTION);
        VERBOSE = EnumSet.of(LOGGING);
    }
}

