/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;

public class GroupingMessageCollector
implements MessageCollector {
    private final MessageCollector delegate;
    private final Multimap<CompilerMessageLocation, Message> groupedMessages;

    public GroupingMessageCollector(@NotNull MessageCollector delegate2) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "<init>"));
        }
        this.groupedMessages = LinkedHashMultimap.create();
        this.delegate = delegate2;
    }

    @Override
    public void clear() {
        this.groupedMessages.clear();
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageLocation location2) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector", "report"));
        }
        if (CompilerMessageSeverity.VERBOSE.contains((Object)severity)) {
            this.delegate.report(severity, message2, location2);
        } else {
            this.groupedMessages.put((Object)location2, (Object)new Message(severity, message2, location2));
        }
    }

    @Override
    public boolean hasErrors() {
        return this.groupedMessages.entries().stream().anyMatch(entry -> ((Message)entry.getValue()).severity.isError());
    }

    public void flush() {
        boolean hasErrors = this.hasErrors();
        List sortedKeys = CollectionsKt.sortedWith((Iterable)this.groupedMessages.keySet(), Comparator.nullsFirst(CompilerMessageLocationComparator.INSTANCE));
        for (CompilerMessageLocation location2 : sortedKeys) {
            for (Message message2 : this.groupedMessages.get((Object)location2)) {
                if (hasErrors && !message2.severity.isError() && message2.severity != CompilerMessageSeverity.STRONG_WARNING) continue;
                this.delegate.report(message2.severity, message2.message, message2.location);
            }
        }
        this.groupedMessages.clear();
    }

    private static class Message {
        private final CompilerMessageSeverity severity;
        private final String message;
        private final CompilerMessageLocation location;

        private Message(@NotNull CompilerMessageSeverity severity, @NotNull String message2, @Nullable CompilerMessageLocation location2) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            if (message2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/GroupingMessageCollector$Message", "<init>"));
            }
            this.severity = severity;
            this.message = message2;
            this.location = location2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Message other = (Message)o;
            if (!Objects.equals(this.location, other.location)) {
                return false;
            }
            if (!this.message.equals(other.message)) {
                return false;
            }
            return this.severity == other.severity;
        }

        public int hashCode() {
            int result2 = this.severity.hashCode();
            result2 = 31 * result2 + this.message.hashCode();
            result2 = 31 * result2 + (this.location != null ? this.location.hashCode() : 0);
            return result2;
        }

        public String toString() {
            return "[" + (Object)((Object)this.severity) + "] " + this.message + (this.location != null ? " (at " + this.location + ")" : " (no location)");
        }
    }

    private static class CompilerMessageLocationComparator
    implements Comparator<CompilerMessageLocation> {
        public static final CompilerMessageLocationComparator INSTANCE = new CompilerMessageLocationComparator();

        private CompilerMessageLocationComparator() {
        }

        @Override
        public int compare(CompilerMessageLocation o1, CompilerMessageLocation o2) {
            if (o1.getColumn() == -1 && o2.getColumn() != -1) {
                return -1;
            }
            if (o1.getColumn() != -1 && o2.getColumn() == -1) {
                return 1;
            }
            if (o1.getLine() == -1 && o2.getLine() != -1) {
                return -1;
            }
            if (o1.getLine() != -1 && o2.getLine() == -1) {
                return 1;
            }
            return o1.getPath().compareTo(o2.getPath());
        }
    }
}

